/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.util;

import java.nio.charset.StandardCharsets;
import uk.org.okapibarcode.backend.OkapiInputException;

public final class Strings {
    private Strings() {
    }

    public static String escape(String s) {
        StringBuilder sb = new StringBuilder(s.length() + 10);
        block15: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0000': {
                    sb.append("\\0");
                    continue block15;
                }
                case '\u0004': {
                    sb.append("\\E");
                    continue block15;
                }
                case '\u0007': {
                    sb.append("\\a");
                    continue block15;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block15;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block15;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block15;
                }
                case '\u000b': {
                    sb.append("\\v");
                    continue block15;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block15;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block15;
                }
                case '\u001b': {
                    sb.append("\\e");
                    continue block15;
                }
                case '\u001d': {
                    sb.append("\\G");
                    continue block15;
                }
                case '\u001e': {
                    sb.append("\\R");
                    continue block15;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block15;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        sb.append(c);
                        continue block15;
                    }
                    byte[] bytes = String.valueOf(c).getBytes(StandardCharsets.ISO_8859_1);
                    String hex = String.format("%02X", bytes[0] & 0xFF);
                    sb.append("\\x").append(hex);
                }
            }
        }
        return sb.toString();
    }

    public static String unescape(String s, boolean lenient) {
        StringBuilder sb = new StringBuilder(s.length());
        block17: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\\') {
                sb.append(c);
                continue;
            }
            if (i + 1 >= s.length()) {
                String msg = "Error processing escape sequences: expected escape character, found end of string";
                throw new OkapiInputException(msg);
            }
            char c2 = s.charAt(i + 1);
            switch (c2) {
                case '0': {
                    sb.append('\u0000');
                    ++i;
                    continue block17;
                }
                case 'E': {
                    sb.append('\u0004');
                    ++i;
                    continue block17;
                }
                case 'a': {
                    sb.append('\u0007');
                    ++i;
                    continue block17;
                }
                case 'b': {
                    sb.append('\b');
                    ++i;
                    continue block17;
                }
                case 't': {
                    sb.append('\t');
                    ++i;
                    continue block17;
                }
                case 'n': {
                    sb.append('\n');
                    ++i;
                    continue block17;
                }
                case 'v': {
                    sb.append('\u000b');
                    ++i;
                    continue block17;
                }
                case 'f': {
                    sb.append('\f');
                    ++i;
                    continue block17;
                }
                case 'r': {
                    sb.append('\r');
                    ++i;
                    continue block17;
                }
                case 'e': {
                    sb.append('\u001b');
                    ++i;
                    continue block17;
                }
                case 'G': {
                    sb.append('\u001d');
                    ++i;
                    continue block17;
                }
                case 'R': {
                    sb.append('\u001e');
                    ++i;
                    continue block17;
                }
                case '\\': {
                    sb.append('\\');
                    ++i;
                    continue block17;
                }
                case 'x': {
                    if (i + 3 >= s.length()) {
                        String msg = "Error processing escape sequences: expected hex sequence, found end of string";
                        throw new OkapiInputException(msg);
                    }
                    char c3 = s.charAt(i + 2);
                    char c4 = s.charAt(i + 3);
                    if (Strings.isHex(c3) && Strings.isHex(c4)) {
                        byte b = (byte)Integer.parseInt("" + c3 + c4, 16);
                        sb.append(new String(new byte[]{b}, StandardCharsets.ISO_8859_1));
                        i += 3;
                        continue block17;
                    }
                    String msg = "Error processing escape sequences: expected hex sequence, found '" + c3 + c4 + "'";
                    throw new OkapiInputException(msg);
                }
                case 'u': {
                    if (i + 5 >= s.length()) {
                        String msg = "Error processing escape sequences: expected unicode hex sequence, found end of string";
                        throw new OkapiInputException(msg);
                    }
                    char c3 = s.charAt(i + 2);
                    char c4 = s.charAt(i + 3);
                    char c5 = s.charAt(i + 4);
                    char c6 = s.charAt(i + 5);
                    if (Strings.isHex(c3) && Strings.isHex(c4) && Strings.isHex(c5) && Strings.isHex(c6)) {
                        byte b1 = (byte)Integer.parseInt("" + c3 + c4, 16);
                        byte b2 = (byte)Integer.parseInt("" + c5 + c6, 16);
                        sb.append(new String(new byte[]{b1, b2}, StandardCharsets.UTF_16BE));
                        i += 5;
                        continue block17;
                    }
                    String msg = "Error processing escape sequences: expected unicode hex sequence, found '" + c3 + c4 + c5 + c6 + "'";
                    throw new OkapiInputException(msg);
                }
                default: {
                    if (lenient) {
                        sb.append(c);
                        continue block17;
                    }
                    throw new OkapiInputException("Error processing escape sequences: expected valid escape character, found '" + c2 + "'");
                }
            }
        }
        return sb.toString();
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static void binaryAppend(StringBuilder s, int value, int digits) {
        int start = 1 << digits - 1;
        for (int i = 0; i < digits; ++i) {
            if ((value & start >> i) == 0) {
                s.append('0');
                continue;
            }
            s.append('1');
        }
    }

    public static String toPrintableAscii(String s) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c <= '~') {
                out.append(c);
                continue;
            }
            out.append("\\u").append(String.format("%04x", c));
        }
        return out.toString();
    }

    public static int count(String s, String substring) {
        int count = 0;
        int i = s.indexOf(substring);
        while (i != -1) {
            ++count;
            i = s.indexOf(substring, i + substring.length());
        }
        return count;
    }
}

