/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.bd.cd;

import ch.dvbern.oss.construct.ConstructionException;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.FileData;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.LogicModelItemInfoDTO;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DDataDTO;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.engine.modelloader.MergedModel;
import ch.dvbern.tax.common.engine.util.MergeModelUtil;
import ch.dvbern.tax.common.integration.CustomModelValueImportParams;
import ch.dvbern.tax.common.integration.CustomModelValueImporter;
import ch.dvbern.tax.common.integration.DvbTaxIdentification;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.bd.AuthenticationData;
import ch.dvbern.tax.common.presentation.bd.cd.CDAuthenticationData;
import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.bd.cd.ModelWriter;
import ch.dvbern.tax.common.presentation.bd.cd.UndoRedoSnapshot;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.presentation.common.util.FileImageSource;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.presentation.common.util.TaxFile;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ImportType;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.PersistenceReadDTO;
import ch.dvbern.tax.common.transfer.dto.SessionStateDTO;
import ch.dvbern.tax.common.transfer.dto.UpdateResultDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import ch.dvbern.tax.common.transfer.failure.ImportCaseNotReleasedException;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import ch.dvbern.tax.common.transfer.failure.NotYetImplementedException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDvbTaxCdSessionImpl
implements DvbTaxCdSession {
    private @Nullable Map<String, ModelItemDTO> dataModel;
    private @NonNull Engine engine;
    private boolean changesSaved = true;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDvbTaxCdSessionImpl.class);
    private static final String INVALID_SESSION_STATE = "invalid session state: ";
    private @Nullable String currentDMK;
    private final @NonNull UndoRedoSnapshot undoRedoSnapshot = new UndoRedoSnapshot();
    private @Nullable TaxFile file;
    private File sourceTaxfile;
    private String password;
    private static Map<String, ModelItemDTO> specificInitValues = new HashMap<String, ModelItemDTO>();
    private static final List<CustomModelValueImporter> valueImporters = new CopyOnWriteArrayList<CustomModelValueImporter>();
    private final ImageSource formImageSource = null;

    protected AbstractDvbTaxCdSessionImpl(String modelPath, DataResource dataResource) {
        try {
            MergedModel model = MergedModel.fromFile((Path)Paths.get(modelPath, new String[0]));
            this.initializeEngine(model, dataResource);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read/parse model: " + modelPath, e);
        }
    }

    protected AbstractDvbTaxCdSessionImpl(MergedModel model, DataResource dataResource) {
        this.initializeEngine(model, dataResource);
    }

    @Override
    public synchronized void addUndoRedoStateListener(UndoRedoSnapshot.UndoRedoStateListener listener) {
        this.undoRedoSnapshot.addUndoRedoStateListener(listener);
    }

    @Override
    public synchronized void removeUndoRedoStateListener(UndoRedoSnapshot.UndoRedoStateListener listener) {
        this.undoRedoSnapshot.removeUndoRedoStateListener(listener);
    }

    @Override
    public synchronized void setFile(@Nullable File file) {
        this.file = file == null ? null : new TaxFile(file, this.password);
    }

    @Override
    public synchronized @Nullable File getFile() {
        return this.file == null ? null : this.file.getFile();
    }

    @Override
    public void setSourceTaxFile(File file) {
        this.sourceTaxfile = file;
    }

    @Override
    public File getSourceTaxfile() {
        return this.sourceTaxfile;
    }

    @Override
    public synchronized @Nullable TaxFile getTaxFile() {
        return this.file;
    }

    @Override
    public synchronized void changePassword(String oldPw, String newPw) throws InvalidAuthenticationException {
        if (!this.password.equals(oldPw)) {
            throw new InvalidAuthenticationException();
        }
        this.setPassword(newPw);
        try {
            this.saveModel();
        }
        catch (IOException e) {
            throw new ApplicationException("Failed to persist new password", (Throwable)e);
        }
    }

    private synchronized void setPassword(String pw) {
        this.password = pw;
        if (this.file != null) {
            this.file.setPassword(pw);
        }
    }

    @Override
    public synchronized void save() throws IOException {
        this.saveModel();
    }

    @Override
    public synchronized boolean changesSaved() {
        return this.changesSaved;
    }

    protected synchronized void setChangesSaved(boolean changesSaved) {
        this.changesSaved = changesSaved;
    }

    public synchronized @Nullable Map<String, ModelItemDTO> getDataModel() {
        if (this.dataModel != null) {
            return Collections.unmodifiableMap(this.dataModel);
        }
        return null;
    }

    public synchronized @Nullable ModelItemDTO getModelItem(@Nullable String dmk) {
        if (this.dataModel == null) {
            return null;
        }
        return this.dataModel.get(dmk);
    }

    public DvbTaxIdentification login(AuthenticationData authData) throws InvalidAuthenticationException {
        CDAuthenticationData cdAuth = (CDAuthenticationData)authData;
        this.changesSaved = true;
        this.undoRedoSnapshot.clear();
        this.setPassword(cdAuth.getPassword());
        try {
            this.createDataModel();
            return new CdDvbTaxIdentification();
        }
        catch (IOException e) {
            throw new ApplicationException("Failed to perform login", (Throwable)e);
        }
    }

    public synchronized @Nullable WizardDisplayInfoDTO getWizardDisplayInfo(String key) {
        return this.getWizardDisplayInfo(key, false, false);
    }

    public synchronized @Nullable WizardDisplayInfoDTO getWizardDisplayInfo(@Nullable String key, boolean autoUpdate) {
        return this.getWizardDisplayInfo(key, true, autoUpdate);
    }

    private synchronized @Nullable WizardDisplayInfoDTO getWizardDisplayInfo(@Nullable String key, boolean updateHistory, boolean autoEnable) {
        if (this.dataModel == null) {
            return null;
        }
        Engine.WizardDisplayInfoDTOAndChanges wdiDTOac = this.engine.getWizardDisplayInfo(this.dataModel, key, false, false, false, 1, autoEnable);
        if (updateHistory) {
            this.undoRedoSnapshot.update(wdiDTOac.getUndoInformations(), this.currentDMK);
            this.currentDMK = key;
        }
        return wdiDTOac.getWizardDisplayInfoDTO();
    }

    @Override
    public synchronized @Nullable WizardDisplayInfoDTO getWizardDisplayInfo() {
        return this.getWizardDisplayInfo(null, true, false);
    }

    public synchronized @Nullable ExpertDisplayInfoDTO getExpertDisplayInfo(@Nullable String key, Locale locale, int mode) {
        if (this.dataModel == null) {
            return null;
        }
        return this.engine.getExpertDisplayInfo(this.dataModel, key, locale, mode).getExpertDisplayInfoDTO();
    }

    public synchronized List<ExpertDisplayInfoDTO.NavigationDTO> getExpertNavigationItems() {
        return this.engine.getExpertNavigationItems(this.dataModel);
    }

    public synchronized @NonNull List<ExpertDisplayInfoDTO> getExpertDisplayInfos(List<String> keys, Locale locale, int mode) {
        if (this.dataModel == null) {
            return Collections.emptyList();
        }
        ArrayList<ExpertDisplayInfoDTO> result = new ArrayList<ExpertDisplayInfoDTO>(keys.size());
        for (String key : keys) {
            ExpertDisplayInfoDTO displayInfo = this.getExpertDisplayInfo(key, locale, mode);
            if (displayInfo == null) continue;
            result.add(displayInfo);
        }
        return result;
    }

    public synchronized void acceptUsageConditions(@NonNull ImportType importFlag) {
    }

    public @Nullable Locale getLanguageFromModel() {
        return null;
    }

    public boolean setLanguageInModel(@Nullable Locale userLocale) throws ImportCaseNotReleasedException {
        return false;
    }

    public synchronized @Nullable SessionStateDTO getTmoSessionState() {
        return new SessionStateDTO(3);
    }

    public synchronized void reinitializeSession() {
    }

    public synchronized void delete(@NonNull String dataModelKey) {
        try {
            Map undoInfos = this.engine.delete(this.dataModel, dataModelKey).getUndoInformations();
            this.undoRedoSnapshot.update(undoInfos, this.currentDMK);
            this.changesSaved = false;
        }
        catch (InvalidModelItemKeyException imike) {
            LOG.error("Error deleting data model key: " + String.valueOf((Object)imike));
        }
    }

    public synchronized @Nullable WizardDisplayInfoDTO update(@NonNull Map<String, ModelItemDTO> newValues, boolean errorForced, boolean deleteForced, String key) {
        WizardDisplayInfoDTO result = null;
        try {
            int tmoState = this.getTmoSessionState().getState();
            if (tmoState != 3) {
                throw new ApplicationException(INVALID_SESSION_STATE + tmoState);
            }
            UpdateResultDTO updateResultDTO = this.engine.update(this.dataModel, newValues, errorForced, deleteForced, key, false, false);
            if (!updateResultDTO.getUndoInformations().isEmpty()) {
                this.changesSaved = false;
            }
            this.undoRedoSnapshot.update(updateResultDTO.getUndoInformations(), this.currentDMK);
            this.currentDMK = key;
            result = updateResultDTO.getWizardDisplayInfoDTO();
        }
        catch (InvalidModelItemKeyException imike) {
            LOG.error("Error updating ModelItemDTO: " + String.valueOf((Object)imike));
        }
        return result;
    }

    public synchronized int touchCompleteModel() {
        int result = 1;
        try {
            int tmoState = this.getTmoSessionState().getState();
            if (tmoState != 3) {
                throw new ApplicationException(INVALID_SESSION_STATE + tmoState);
            }
            UpdateResultDTO urDTO = this.engine.touchCompleteModel(this.dataModel);
            this.undoRedoSnapshot.update(urDTO.getUndoInformations(), this.currentDMK);
            ExpertDisplayInfoDTO ediDTO = urDTO.getExpertDisplayInfoDTO();
            if (ediDTO != null) {
                result = ediDTO.getState();
            }
        }
        catch (InvalidModelItemKeyException imike) {
            LOG.error("Error touching complete model: " + String.valueOf((Object)imike));
        }
        return result;
    }

    @Override
    public synchronized void updateSilent(Map<String, ModelItemDTO> newValues) {
        int tmoState = this.getTmoSessionState().getState();
        if (tmoState != 3) {
            throw new ApplicationException(INVALID_SESSION_STATE + tmoState);
        }
        this.engine.update(this.dataModel, newValues, true);
    }

    public synchronized void update(@NonNull Map<String, ModelItemDTO> newValues, boolean allowDelete) {
        int tmoState = this.getTmoSessionState().getState();
        if (tmoState != 3) {
            throw new ApplicationException(INVALID_SESSION_STATE + tmoState);
        }
        UpdateResultDTO updateResultDTO = this.engine.update(this.dataModel, newValues, allowDelete);
        if (!updateResultDTO.getUndoInformations().isEmpty()) {
            this.changesSaved = false;
        }
        this.undoRedoSnapshot.update(updateResultDTO.getUndoInformations(), this.currentDMK);
    }

    public synchronized void importData(@NonNull Map<String, ModelItemDTO> newValues, boolean allowDelete) {
        int tmoState = this.getTmoSessionState().getState();
        if (tmoState != 3) {
            throw new ApplicationException(INVALID_SESSION_STATE + tmoState);
        }
        UpdateResultDTO updateResultDTO = this.engine.importData(this.dataModel, newValues, allowDelete);
        if (!updateResultDTO.getUndoInformations().isEmpty()) {
            this.changesSaved = false;
        }
        this.undoRedoSnapshot.update(updateResultDTO.getUndoInformations(), this.currentDMK);
    }

    @Override
    public synchronized @Nullable String undo() {
        if (!this.undoRedoSnapshot.isUndoable()) {
            return null;
        }
        this.changesSaved = false;
        UndoRedoSnapshot.UndoRedoSnapshotDTO result = this.undoRedoSnapshot.undo(this.dataModel, this.currentDMK);
        if (result != null) {
            this.dataModel = result.getDataModel();
            return result.getDmk();
        }
        return null;
    }

    @Override
    public synchronized String redo() {
        if (!this.undoRedoSnapshot.isRedoable()) {
            return null;
        }
        this.changesSaved = false;
        UndoRedoSnapshot.UndoRedoSnapshotDTO result = this.undoRedoSnapshot.redo(this.dataModel, this.currentDMK);
        if (result != null) {
            this.dataModel = result.getDataModel();
            return result.getDmk();
        }
        return null;
    }

    @Override
    public synchronized void createModelSnapshot() {
        this.undoRedoSnapshot.createModelSnapshot(this.dataModel, this.currentDMK);
    }

    @Override
    public synchronized String backtoModelSnapshot() {
        UndoRedoSnapshot.UndoRedoSnapshotDTO result = this.undoRedoSnapshot.backtoModelSnapshot(this.dataModel, this.currentDMK);
        if (result != null) {
            this.dataModel = result.getDataModel();
            return result.getDmk();
        }
        return null;
    }

    public synchronized WizardDisplayInfoDTO release(String key, Locale userLocale) {
        return null;
    }

    public synchronized void logout() {
        this.setFile(null);
        this.dataModel = null;
        this.password = null;
        this.changesSaved = true;
        this.undoRedoSnapshot.clear();
    }

    public synchronized void completeReset() {
        block4: {
            try {
                this.createDataModel(true);
            }
            catch (InvalidAuthenticationException e) {
                assert (false) : "Illegal code path when forceEmpty flag set to 'true'";
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)"Illegal code path when forceEmpty flag set to 'true'");
            }
        }
    }

    public synchronized void completeReset(Map<String, ModelItemDTO> dataModel) {
        throw new UnsupportedOperationException("completeReset(Map<String, dataModel> dataModel) is not supported by this implementation");
    }

    private void saveModel() throws IOException {
        if (this.dataModel == null) {
            throw new IllegalStateException("can't save. dataModel must not be null");
        }
        if (this.file == null) {
            throw new IllegalStateException("can't save. file must not be null");
        }
        this.saveModel(() -> this.file.saveModel(this.dataModel));
    }

    protected final synchronized void saveModel(@NonNull ModelWriter modelWriter) throws IOException {
        modelWriter.writeModel();
        this.changesSaved = true;
    }

    @Override
    public synchronized void autosave(File autosaveFile) {
        if (this.dataModel == null) {
            return;
        }
        if (autosaveFile == null) {
            throw new IllegalStateException("can't save. file must not be null");
        }
        TaxFile taxFile = new TaxFile(autosaveFile, null);
        try {
            taxFile.saveModel(this.dataModel);
        }
        catch (IOException e) {
            LOG.error("Auto-save failed", (Throwable)e);
        }
    }

    private synchronized void initializeEngine(MergedModel modelFile, DataResource dataResource) {
        if (TaxmeController.getInstance().isModelReload() || Boolean.getBoolean("model.reload.enabled")) {
            this.mergeModelFromSource();
        }
        try {
            this.engine = Engine.createEngine((String)modelFile.asString(), (DataResource)dataResource, (boolean)false);
            this.dataModel = new HashMap<String, ModelItemDTO>();
        }
        catch (ConstructionException e) {
            LOG.error("Error initializing engine: ", (Throwable)e);
            throw new ApplicationException("can't initialize engine", (Throwable)e);
        }
    }

    private void mergeModelFromSource() {
        String modelBaseDir = System.getProperty("model.reload.basedir");
        if (modelBaseDir == null) {
            throw new IllegalArgumentException("Absoluter Pfad zum Model-Directory muss gesetzt sein in Property: model.reload.basedir");
        }
        String xmlConfPath = System.getProperty("model.reload.xmlconf.pathrelative");
        if (xmlConfPath == null) {
            throw new IllegalArgumentException("relativer Pfad zu xml.conf muss gesetzt sein in Property: model.reload.xmlconf.pathrelative");
        }
        File baseDir = new File(modelBaseDir);
        File xmlConf = new File(baseDir, xmlConfPath);
        if (!xmlConf.exists()) {
            throw new IllegalArgumentException("xml.conf existiert nich im Pfad: " + String.valueOf(xmlConf));
        }
        try {
            new MergeModelUtil(baseDir, xmlConf).merge(new File(TaxmeConfig.getString("path.model.xml")));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to reload model from disk.", e);
        }
    }

    public static synchronized void setSpecificInitValues(Map<String, ModelItemDTO> values) {
        specificInitValues = values;
    }

    public static void addCustomModelValueImporter(CustomModelValueImporter customImporter) {
        if (customImporter == null) {
            throw new NullPointerException("Custom value importer cannot be null");
        }
        valueImporters.add(customImporter);
    }

    private synchronized void initializeDataModel() {
        HashMap<String, ModelItemDTO> changes = new HashMap<String, ModelItemDTO>();
        changes.putAll(specificInitValues);
        this.engine.update(this.dataModel, changes, false);
    }

    private synchronized void createDataModel() throws InvalidAuthenticationException, IOException {
        this.createDataModel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createDataModel(boolean forceEmpty) throws InvalidAuthenticationException, IOException {
        this.dataModel = new HashMap<String, ModelItemDTO>();
        boolean done = false;
        try {
            CustomModelValueImportParams valueImporterParams = new CustomModelValueImportParams(null, null, this.engine, this.dataModel, null, null, null, null, null);
            for (CustomModelValueImporter valueImporter : valueImporters) {
                try {
                    valueImporter.importIntoEmptyModel(valueImporterParams);
                }
                catch (ImportException e) {
                    throw new ApplicationException("Failed to process CustomModelValueImporter for empty model", (Throwable)e);
                }
            }
            Map<Object, Object> persistentValues = forceEmpty ? Collections.emptyMap() : this.readDataModel();
            boolean mustRecalculate = !persistentValues.isEmpty();
            for (CustomModelValueImporter valueImporter : valueImporters) {
                try {
                    valueImporter.importPersistent(persistentValues, valueImporterParams);
                }
                catch (ImportException e) {
                    throw new ApplicationException("Failed to process CustomModelValueImporter for import-persistent phase", (Throwable)e);
                }
            }
            this.dataModel.putAll(persistentValues);
            for (CustomModelValueImporter valueImporter : valueImporters) {
                valueImporter.importPostUpdate(persistentValues, valueImporterParams);
            }
            this.engine.initializeDefaultValues(this.dataModel);
            for (CustomModelValueImporter valueImporter : valueImporters) {
                valueImporter.importPostDefaults(persistentValues, valueImporterParams);
            }
            this.initializeDataModel();
            for (CustomModelValueImporter valueImporter : valueImporters) {
                valueImporter.importPostInitialization(persistentValues, valueImporterParams);
            }
            if (mustRecalculate) {
                this.recalculate();
                for (CustomModelValueImporter valueImporter : valueImporters) {
                    valueImporter.importPostRecaltulate(persistentValues, valueImporterParams);
                }
            }
            done = true;
        }
        finally {
            if (!done) {
                this.dataModel = null;
            }
        }
    }

    protected Map<String, ModelItemDTO> readDataModel() throws InvalidAuthenticationException, IOException {
        return this.file != null ? this.file.readModel() : new HashMap(200);
    }

    public synchronized ExpertDisplayInfoDTO expertUpdate(@NonNull Map<String, ModelItemDTO> newValues, boolean errorForced, boolean deleteForced, String key, Locale locale, boolean touchItems) {
        UpdateResultDTO result = this.engine.expertUpdate(this.dataModel, newValues, errorForced, deleteForced, key, locale, touchItems);
        if (!result.getUndoInformations().isEmpty()) {
            this.changesSaved = false;
        }
        this.undoRedoSnapshot.update(result.getUndoInformations(), this.currentDMK);
        return result.getExpertDisplayInfoDTO();
    }

    public synchronized Map<?, ?> getOptions(String code, Object arg2) {
        return null;
    }

    public Map<?, ?> getOptionsLocalized(String code, Object arg2) {
        return null;
    }

    public synchronized @Nullable DvbTaxIdentification getTmoIdentification() {
        return null;
    }

    public synchronized void recalculate() {
        this.engine.recalculate(this.dataModel);
    }

    public Barcode2DDataDTO generateBarcode(Barcode2DGenerator generator) {
        Map barcodeMap;
        try {
            barcodeMap = TaxmeConfig.getDataResource().get("barcode", null, null);
        }
        catch (IllegalArgumentException e) {
            barcodeMap = Collections.emptyMap();
        }
        List barcodeLines = null;
        if (barcodeMap != null) {
            barcodeLines = (List)barcodeMap.get("barcode");
        }
        return this.engine.generateBarcode(this.dataModel, generator, barcodeLines);
    }

    public synchronized String getImageVariant() {
        ModelItemDTO imageVariantDTO;
        if (this.dataModel != null && (imageVariantDTO = this.dataModel.get("Stammdaten.ImageVariant")) != null) {
            return (String)imageVariantDTO.getValue();
        }
        return null;
    }

    public void exitForm() {
    }

    public synchronized List<String> getExpertNavigationItemAccessKeys() {
        ArrayList<String> expNavItems = new ArrayList<String>();
        List l = this.engine.getExpertNavigationItems(this.dataModel);
        for (ExpertDisplayInfoDTO.NavigationDTO navigationDTO : l) {
            this.addSubItems(navigationDTO, expNavItems);
        }
        return expNavItems;
    }

    private void addSubItems(ExpertDisplayInfoDTO.NavigationDTO navigationDTO, List<String> items) {
        if (navigationDTO.getSubItems() != null) {
            for (Object element : navigationDTO.getSubItems()) {
                ExpertDisplayInfoDTO.NavigationDTO childDTO = (ExpertDisplayInfoDTO.NavigationDTO)element;
                this.addSubItems(childDTO, items);
            }
        } else {
            items.add(navigationDTO.getAccessKey());
        }
    }

    public List<PersistenceReadDTO> getPersistenceReadDTOs() {
        return this.engine.getPersistenceReadDTOs();
    }

    public boolean hasMultipleCasesForZpv(int zpv) {
        return false;
    }

    public Map<String, LogicModelItemInfoDTO> getLogicModelItemsInfo() {
        return this.engine.getLogicModelItemsInfo();
    }

    public int getDataModelState() {
        return this.engine.getDataModelState(this.dataModel);
    }

    public @NonNull Map<String, LogicModelItem> getLogicModel() {
        return Collections.unmodifiableMap(this.engine.getLogicModel());
    }

    @Override
    public ImageSource getFormImageSource() {
        return new FileImageSource(new File(TaxmeConfig.getFormImagesDir()));
    }

    @Override
    public ImageSource getImageSource() {
        return new FileImageSource(new File(TaxmeConfig.getImageDir()));
    }

    public @Nullable FileData getFileData(@NonNull DMK dmk) {
        throw new NotYetImplementedException("for DMK: " + String.valueOf(dmk));
    }

    private static final class CdDvbTaxIdentification
    implements DvbTaxIdentification,
    Cloneable {
        private static final long serialVersionUID = 1L;

        private CdDvbTaxIdentification() {
        }

        public boolean isDemoMode() {
            return false;
        }

        public int getSteuerjahr() {
            return ApplicationConfig.getInstance().getJahr();
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

