/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd;

import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.TaxFileConfig;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Autosave
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Autosave.class);
    private static Thread autosaveThread = null;
    private long autosaveInterval = 0L;
    private String autosaveDir = null;
    private String autosaveUsbDir = null;
    private String autosaveAboluteDir = null;

    public Autosave(long autosaveInterval, String autosaveDir, String autosaveUsbDir, String autosaveAbsoluteDir) {
        this.autosaveInterval = autosaveInterval;
        this.autosaveDir = autosaveDir;
        this.autosaveUsbDir = autosaveUsbDir;
        this.autosaveAboluteDir = autosaveAbsoluteDir;
    }

    public static void startAutosave() {
        Autosave.stopAutosave();
        String sAutosaveInterval = TaxmeConfig.getString("autosave.interval");
        long lAutosaveInterval = 30000L;
        try {
            lAutosaveInterval = Long.valueOf(sAutosaveInterval);
        }
        catch (NumberFormatException nfe) {
            LOG.error("Error getting autosave interval: " + String.valueOf(nfe));
        }
        String sAutosaveDir = TaxmeConfig.getString("autosave.savedir");
        String sAutosaveUsbDir = TaxmeConfig.getString("autosave.usb.savedir");
        String sAutosaveAbsoluteDir = TaxmeConfig.getString("autosave.absolute.savedir");
        if (sAutosaveDir == null && sAutosaveUsbDir == null && sAutosaveAbsoluteDir == null) {
            return;
        }
        autosaveThread = new Thread(new Autosave(lAutosaveInterval, sAutosaveDir, sAutosaveUsbDir, sAutosaveAbsoluteDir));
        autosaveThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void stopAutosave() {
        if (autosaveThread == null) return;
        Class<Autosave> clazz = Autosave.class;
        synchronized (Autosave.class) {
            autosaveThread.interrupt();
            // ** MonitorExit[var0] (shouldn't be in output)
            autosaveThread = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (true) {
                Thread.sleep(this.autosaveInterval);
                Class<Autosave> clazz = Autosave.class;
                // MONITORENTER : ch.dvbern.tax.common.presentation.cd.Autosave.class
                this.doAutosave();
                // MONITOREXIT : clazz
            }
        }
        catch (InterruptedException ie) {
            LOG.debug("Autosaving has been interrupted");
            return;
        }
    }

    private void doAutosave() {
        try {
            DvbTaxCdSession session = TaxmeController.getInstance().getTmoCdSession();
            String autosavePrefix = TaxFileConfig.getInstance().getAutosavePrefix(session.getDataModel());
            if (autosavePrefix == null) {
                return;
            }
            LOG.debug("Start autosaving");
            File[] autosaveFiles = this.getAutosaveDir().listFiles();
            File autosaveFile = null;
            String autosaveFilename = null;
            long autosaveLastModified = 0L;
            long autosaveLastModifiedCompare = 0L;
            int autosaveFileCounter = 0;
            Object newAutosaveFilename = null;
            for (File autosaveFile2 : autosaveFiles) {
                autosaveFile = autosaveFile2;
                autosaveFilename = autosaveFile.getName();
                if (!autosaveFilename.startsWith(autosavePrefix)) continue;
                ++autosaveFileCounter;
                autosaveLastModified = autosaveFile.lastModified();
                if (autosaveLastModifiedCompare != 0L && autosaveLastModified >= autosaveLastModifiedCompare) continue;
                autosaveLastModifiedCompare = autosaveLastModified;
                newAutosaveFilename = autosaveFilename;
            }
            if (++autosaveFileCounter <= 5) {
                newAutosaveFilename = autosavePrefix + "_" + autosaveFileCounter + TaxFileConfig.getInstance().getAutosaveSuffix();
            }
            File newAutosaveFile = new File(this.getAutosaveDir(), (String)newAutosaveFilename);
            session.autosave(newAutosaveFile);
            LOG.debug("Autosaving done");
        }
        catch (Exception e) {
            LOG.error("Autosave failed", (Throwable)e);
        }
    }

    public File getAutosaveDir() {
        File dir = null;
        dir = this.autosaveUsbDir != null ? new File(this.autosaveUsbDir) : (this.autosaveAboluteDir != null ? new File(this.autosaveAboluteDir) : new File(TaxmeConfig.getUserHome(), this.autosaveDir));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }
}

