/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.Autosave;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ButtonRecalculateAction;
import ch.dvbern.tax.common.presentation.cd.action.ButtonValorSearchAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FilePrintAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileStartAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilUpdateAction;
import ch.dvbern.tax.common.presentation.cd.util.BrowserUtil;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommands;
import ch.dvbern.tax.common.presentation.cd.util.ConnectionUtil;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.common.imports.ImportConfig;
import ch.dvbern.tax.common.presentation.common.imports.ImportUtil;
import ch.dvbern.tax.common.presentation.common.print.FormRendererUtil;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.jboss.weld.environment.se.Weld;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaxmeLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(TaxmeLauncher.class);
    private static boolean restart;
    private static boolean open;

    private TaxmeLauncher() {
    }

    public static void launchTaxme() {
        LOG.info("Application is starting.");
        if (LOG.isDebugEnabled()) {
            LOG.debug("System infos: \n" + TaxmeLauncher.getSysInfo());
        }
        System.setProperty("org.jboss.weld.se.archive.isolation", "false");
        final Weld weld = new Weld();
        weld.initialize();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LOG.debug("Shutting down weld");
                weld.shutdown();
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.error("Uncaught exception => " + String.valueOf(t), e);
            }
        });
        TaxmeConfig.check();
        TaxmeController ctrl = TaxmeController.getInstance();
        Locale.setDefault(ctrl.getLocale());
        TimeZone.setDefault(ApplicationConfig.TIMEZONE);
        ImportConfig importConfig = TaxmeConfig.getImportConfig();
        if (importConfig != null) {
            TaxmeController.getInstance().setImportUtil(new ImportUtil(importConfig));
        }
        ButtonCommands.register("/print.cmd", new FilePrintAction(), false);
        ButtonCommands.register("/valor.search.cmd", new ButtonValorSearchAction(), false);
        ButtonCommands.register("/recalc.cmd", new ButtonRecalculateAction(), false);
        BrowserUtil.registerBrowserAction("https://start.cmd/", new FileStartAction());
        ConnectionUtil.configure();
        FormRendererUtil.setApplicationVersion((String)TaxmeConfig.getApplicationVersion());
        do {
            restart = false;
            TaxmeLauncher.launchApplication();
        } while (restart);
        System.exit(0);
    }

    private static String getSysInfo() {
        String cp;
        StringBuilder sb;
        block3: {
            sb = new StringBuilder();
            sb.append("Operating System: ").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append("\n").append("JVM Name: ").append(System.getProperty("java.vm.name")).append("\n").append("JVM Vendor: ").append(System.getProperty("java.vm.vendor")).append("\n").append("JVM Version: ").append(System.getProperty("java.vm.version")).append("\n").append("SWT Version: ").append(SWT.getVersion()).append("-").append(SWT.getPlatform()).append("\n").append("Java Home: ").append(System.getProperty("java.home")).append("\n");
            TimeZone tz = TimeZone.getDefault();
            sb.append("Default Timezone: ").append(tz.getID()).append("\n");
            sb.append("Default Locale: ").append(Locale.getDefault()).append("\n");
            cp = System.getProperty("java.class.path");
            if (cp != null) {
                try {
                    cp = cp.replaceAll(System.getProperty("path.separator"), "\n");
                }
                catch (PatternSyntaxException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)"Cannot parse class path.");
                }
            }
        }
        sb.append("Classpath: ").append(cp);
        return sb.toString();
    }

    public static void setRestart(boolean newValue) {
        restart = newValue;
    }

    public static boolean isRestart() {
        return restart;
    }

    private static void launchApplication() {
        Display display = Display.getDefault();
        final Shell splash = new Shell(16384);
        splash.setText(Messages.configurableTranslate("taxme.cd.title", (Control)splash, new Object[0]));
        GridLayout layout = new GridLayout(1, false);
        splash.setLayout((Layout)layout);
        final Image image = new Image((Device)display, TaxmeConfig.getIconFilePath(TaxmeConfig.getString("splash.icon")));
        Label label = new Label((Composite)splash, 0);
        label.setImage(image);
        final ProgressBar bar = new ProgressBar((Composite)splash, 0);
        bar.setLayoutData((Object)new GridData(768));
        splash.pack();
        Rectangle splashRect = splash.getBounds();
        Rectangle displayRect = display.getBounds();
        int x = (displayRect.width - splashRect.width) / 2;
        int y = (displayRect.height - splashRect.height) / 2;
        splash.setLocation(x, y);
        splash.open();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                TaxmeController.getInstance().startup(bar);
                splash.close();
                image.dispose();
            }
        });
        TaxmeController controller = TaxmeController.getInstance();
        while (controller.getShell() == null) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        String updateAtStartupEnabled = TaxmeConfig.getString("update.atStartup.enabled");
        if (updateAtStartupEnabled != null && updateAtStartupEnabled.equals("true")) {
            new UtilUpdateAction("startup.update", 1).run();
        }
        String autosaveEnabled = TaxmeConfig.getString("autosave.enabled");
        String passwordEnabled = TaxmeConfig.getString("password.enabled");
        if (autosaveEnabled != null && autosaveEnabled.equals("true")) {
            if (passwordEnabled != null && passwordEnabled.equals("true")) {
                DialogUtil.showErrorDialog("error.autosave.passwordActivated", new Object[0]);
            } else {
                Autosave.startAutosave();
            }
        }
        boolean bl = open = !controller.getShell().isDisposed();
        if (open) {
            controller.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent ev) {
                    open = false;
                }
            });
            while (open) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        Autosave.stopAutosave();
    }
}

