/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action;

import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.printing.PrintEntry;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MixedPrintableAction {
    private final @NonNull List<PrintEntry> entries;
    private final @NonNull FormRendererConfiguration rendererConfiguration;
    private final @NonNull String label;

    public MixedPrintableAction(@NonNull List<PrintEntry> entries, @NonNull FormRendererConfiguration rendererConfiguration) {
        this.entries = Objects.requireNonNull(entries);
        this.rendererConfiguration = Objects.requireNonNull(rendererConfiguration);
        this.label = "";
    }

    public MixedPrintableAction(@NonNull List<PrintEntry> entries, @NonNull FormRendererConfiguration rendererConfiguration, @NonNull String label) {
        this.entries = Objects.requireNonNull(entries);
        this.rendererConfiguration = Objects.requireNonNull(rendererConfiguration);
        this.label = Objects.requireNonNull(label);
    }

    public MixedPrintableAction(@NonNull PrintEntry entry, @NonNull FormRendererConfiguration rendererConfiguration) {
        this(Collections.singletonList(entry), rendererConfiguration);
    }

    public MixedPrintableAction(@NonNull PrintEntry entry, @NonNull FormRendererConfiguration rendererConfiguration, @NonNull String label) {
        this(Collections.singletonList(entry), rendererConfiguration, label);
    }

    public @NonNull List<PrintEntry> getPrintEntries() {
        return this.entries;
    }

    public FormRendererConfiguration getRendererConfiguration() {
        return this.rendererConfiguration;
    }

    public @NonNull String getLabel() {
        return this.label;
    }
}

