/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action.menu;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import java.util.regex.Pattern;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class FontSizeContributionItem
extends ContributionItem {
    protected Combo addressBox;
    protected ToolItem item;
    protected CoolItem coolItem;

    public void fill(ToolBar parent, int index) {
        this.item = new ToolItem(parent, 2);
        Control box = this.createAddressBox((Composite)parent);
        this.item.setControl(box);
        this.item.setWidth(80);
    }

    private Control createAddressBox(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        top.setLayout((Layout)layout);
        this.addressBox = new Combo(top, 12);
        Font f = new Font((Device)Display.getCurrent(), new FontData[]{new FontData("Arial", 12, 0)});
        this.addressBox.setFont(f);
        this.addressBox.addSelectionListener(new SelectionListener(this){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                int selectedSize = Integer.parseInt(((Combo)arg0.widget).getText());
                GuiUtil.setFontSize(selectedSize);
                TaxmeController.getInstance().getApp().rebuild();
                TaxmeController.getInstance().update();
            }
        });
        this.addressBox.setLayoutData((Object)new GridData(2, 2, false, true));
        int lastSelectedSize = TaxmeConfig.getInt("font.size");
        if (lastSelectedSize == 0) {
            lastSelectedSize = 8;
        }
        GuiUtil.setFontSize(lastSelectedSize);
        String choices = TaxmeConfig.getString("window.show.fontsize.choices");
        choices = choices.replaceAll(" ", "");
        Pattern pattern = Pattern.compile(",");
        String[] items = pattern.split(choices);
        for (int i = 0; i < items.length; ++i) {
            String string = items[i];
            this.addressBox.add(string);
            if (!string.equals(String.valueOf(lastSelectedSize))) continue;
            this.addressBox.select(i);
        }
        return top;
    }

    public void fill(Composite parent) {
        this.createAddressBox(parent);
    }

    public void setText(String text) {
        if (this.addressBox != null) {
            this.addressBox.setText(text);
        }
    }
}

