/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action.menu;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.dialog.SetApplicationPathDialog;
import org.eclipse.swt.widgets.Shell;

public class UtilSetApplicationPathAction
extends ActionBase {
    private final String applicationTitleKey;
    private final String useConfigKey;
    private final String applicationPathKey;

    public UtilSetApplicationPathAction(String actionMsgKey, String applicationTitleKey, String useConfigKey, String applicationPathKey) {
        super(actionMsgKey);
        if (applicationTitleKey == null || useConfigKey == null || applicationPathKey == null) {
            throw new NullPointerException("Invalid null argument");
        }
        this.applicationTitleKey = applicationTitleKey;
        this.useConfigKey = useConfigKey;
        this.applicationPathKey = applicationPathKey;
    }

    public void run() {
        SetApplicationPathDialog dlg;
        Shell crtShell = TaxmeController.getInstance().getShell();
        boolean useCustomApplication = TaxmeConfig.getBoolean(this.useConfigKey);
        String applicationPath = TaxmeConfig.getString(this.applicationPathKey);
        if (applicationPath == null || applicationPath.isEmpty()) {
            useCustomApplication = false;
        }
        if ((dlg = new SetApplicationPathDialog(crtShell, Messages.configurableTranslate(this.applicationTitleKey, new Object[0]), useCustomApplication, applicationPath)).open() == 0) {
            String path = dlg.getPath();
            useCustomApplication = !path.isEmpty() && dlg.isUseCustomApplication();
            TaxmeConfig.setValue(this.useConfigKey, useCustomApplication);
            if (useCustomApplication) {
                TaxmeConfig.setValue(this.applicationPathKey, dlg.getPath());
            }
        }
    }
}

