/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action.menu;

import ch.dvbern.lib.update.IProgressListener;
import ch.dvbern.lib.update.UpdateManager;
import ch.dvbern.lib.update.UpdateProvider;
import ch.dvbern.lib.update.UpdateVersion;
import ch.dvbern.lib.update.exception.CommunicationException;
import ch.dvbern.lib.update.type.UpdateConfig;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeProgressMonitorDialog;
import ch.dvbern.tax.common.presentation.cd.dialog.UpdateCommunicationErrorDialog;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.ImmediatelyCancelable;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilUpdateAction
extends ActionBase {
    public static final int USER_REQUEST = 0;
    public static final int STARTUP_REQUEST = 1;
    private static final Logger LOG = LoggerFactory.getLogger(UtilUpdateAction.class);
    private static final UpdateConfig UPDATE_CONFIG = new UpdateConfig(TaxmeConfig.getString("update.protocol"), TaxmeConfig.getString("update.server"), TaxmeConfig.getInt("update.port"), TaxmeConfig.getString("update.path"), TaxmeConfig.getUpdateSignatureVerifier(), TaxmeConfig.getUpdateSiteTrustManagerProvider(), UtilUpdateAction.coalesceNN(TaxmeConfig.getString("update.signature.file-extension"), ".dsig"));
    private int requestSource = 0;
    private boolean forceUpdate = TaxmeConfig.getBoolean("update.force", false);

    public UtilUpdateAction(String nameKey, int requestSource) {
        super(nameKey);
        this.requestSource = requestSource;
    }

    @SafeVarargs
    private static <T> @Nullable T coalesce(T ... tries) {
        for (T aTry : tries) {
            if (aTry == null) continue;
            return aTry;
        }
        return null;
    }

    @SafeVarargs
    private static <T> T coalesceNN(T ... tries) {
        return Objects.requireNonNull(UtilUpdateAction.coalesce(tries));
    }

    public void run() {
        block16: {
            if (!this.isUpdateNeeded()) {
                return;
            }
            Shell parentShell = TaxmeController.getInstance().getShell();
            boolean doingUpdate = false;
            try {
                ImmediatelyCancelable<UpdateManager> searchTask = new ImmediatelyCancelable<UpdateManager>(this, (Callable)new Callable<UpdateManager>(this){

                    @Override
                    public UpdateManager call() throws Exception {
                        return UpdateManager.openUpdateSite((UpdateProvider)UPDATE_CONFIG);
                    }
                }){

                    @Override
                    protected void start(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.translate("label.application.update.search", new Object[0]), -1);
                    }
                };
                this.run(searchTask);
                final UpdateManager updateManager = (UpdateManager)searchTask.getResult();
                assert (updateManager != null);
                NavigableSet availableUpdates = updateManager.getAvailableUpdates();
                if (!updateManager.isUpdateAvailable()) {
                    if (this.requestSource == 0) {
                        boolean factoryVersion;
                        boolean bl = factoryVersion = availableUpdates.isEmpty() && updateManager.getAvailableVersions().size() <= 1;
                        if (factoryVersion) {
                            DialogUtil.showInfoDialog(parentShell, "label.application.update.noinitialupdate", new Object[0]);
                        } else {
                            DialogUtil.showInfoDialog(parentShell, "label.application.update.nothing", new Object[0]);
                        }
                    }
                    return;
                }
                String updatesText = this.formatUpdates(TaxmeController.getInstance().getLocale(), availableUpdates);
                if (this.forceUpdate || DialogUtil.showConfirmDialog(parentShell, "label.application.update.ask", updatesText)) {
                    doingUpdate = true;
                    ImmediatelyCancelable<Void> downloadTask = new ImmediatelyCancelable<Void>(this, (Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            updateManager.update();
                            return null;
                        }
                    }){

                        @Override
                        protected void start(final IProgressMonitor monitor) {
                            monitor.beginTask(Messages.translate("label.application.update.downloading", new Object[0]), 100);
                            updateManager.addProgressListener(new IProgressListener(){
                                int progress = 0;

                                public void updateProgress(String resource) {
                                    monitor.subTask(resource);
                                }

                                public void updateProgress(int percent) {
                                    int advance = percent - this.progress;
                                    if (advance > 0) {
                                        monitor.worked(advance);
                                        this.progress = percent;
                                    }
                                }

                                public void updateFinished() {
                                }

                                public void updateCancelled() {
                                }
                            });
                        }
                    };
                    this.run(downloadTask);
                    DialogUtil.showInfoDialog(parentShell, "label.application.update.finished", new Object[0]);
                    TaxmeController.getInstance().close();
                }
                assert (updateManager != null);
            }
            catch (InterruptedException e) {
                LOG.debug("Update interrupted.", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error("update search failed", (Throwable)e);
                if (doingUpdate || this.requestSource == 0) {
                    String msgKey = e.getCause() instanceof CommunicationException ? "label.application.update.error.communication" : "label.application.update.error";
                    DialogUtil.showErrorDialog(TaxmeController.getInstance().getShell(), msgKey, new Object[0]);
                } else {
                    String sShowStartupUpdateErrorView = TaxmeConfig.getString("update.atStartup.showStartupUpdateErrorView");
                    boolean showStartupUpdateErrorView = Boolean.valueOf(sShowStartupUpdateErrorView);
                    if (showStartupUpdateErrorView) {
                        UpdateCommunicationErrorDialog dialog = new UpdateCommunicationErrorDialog(parentShell);
                        dialog.open();
                        int returnCode = dialog.getReturnCode();
                        TaxmeConfig.setValue("update.atStartup.showStartupUpdateErrorView", String.valueOf(dialog.isShowStartupUpdateErrorView()));
                        if (returnCode == 0) {
                            this.run();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error("update search failed", (Throwable)e);
                if (!doingUpdate && this.requestSource != 0) break block16;
                DialogUtil.showErrorDialog(parentShell, "label.application.update.error", new Object[0]);
            }
        }
    }

    private @NonNull String formatUpdates(@NonNull Locale locale, @NonNull NavigableSet<UpdateVersion> availableUpdates) {
        assert (locale != null);
        assert (availableUpdates != null);
        StringBuilder bld = new StringBuilder();
        for (UpdateVersion v : availableUpdates.descendingSet()) {
            bld.append("--- ").append(v.getVersionNumber()).append(" ---").append('\n');
            String desc = v.getDescription(locale);
            if (desc != null) {
                bld.append(desc);
            }
            bld.append('\n');
            bld.append('\n');
        }
        return bld.toString();
    }

    private boolean isUpdateNeeded() {
        if (this.requestSource == 1) {
            long updateIntervalInHoursAsMiliseconds;
            long lNextUpdate;
            Date nextUpdate;
            int updateIntervalInHours = 5;
            String sUpdateIntervalInHours = TaxmeConfig.getString("update.atStartup.intervalInHours");
            try {
                updateIntervalInHours = Integer.parseInt(sUpdateIntervalInHours);
            }
            catch (NumberFormatException nfe) {
                LOG.error("no correct update interval set", (Throwable)nfe);
            }
            long lLastUpdate = 0L;
            String sLastUpdate = TaxmeConfig.getString("update.atStartup.lastUpdate");
            if (sLastUpdate != null) {
                try {
                    lLastUpdate = Long.parseLong(sLastUpdate);
                }
                catch (NumberFormatException nfe) {
                    LOG.error("last update date not set", (Throwable)nfe);
                }
            }
            Date actualDate = new Date();
            if (lLastUpdate > 0L && actualDate.before(nextUpdate = new Date(lNextUpdate = lLastUpdate + (updateIntervalInHoursAsMiliseconds = (long)updateIntervalInHours * 60L * 60L * 1000L)))) {
                return false;
            }
            TaxmeConfig.setValue("update.atStartup.lastUpdate", String.valueOf(actualDate.getTime()));
        }
        return true;
    }

    private void run(IRunnableWithProgress r) throws InvocationTargetException, InterruptedException {
        TaxmeProgressMonitorDialog dlg = new TaxmeProgressMonitorDialog(TaxmeController.getInstance().getShell());
        dlg.run(true, true, r);
    }
}

