/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.builders.common;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.builders.common.AControlBuilder;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.AExpertItem;
import ch.dvbern.tax.common.presentation.cd.parts.CheckboxPart;
import ch.dvbern.tax.common.presentation.cd.parts.ComboboxPart;
import ch.dvbern.tax.common.presentation.cd.parts.HelpPart;
import ch.dvbern.tax.common.presentation.cd.parts.HiddenPart;
import ch.dvbern.tax.common.presentation.cd.parts.HighlightFocusElementListener;
import ch.dvbern.tax.common.presentation.cd.parts.RadioGroupPart;
import ch.dvbern.tax.common.presentation.cd.parts.TextAreaPart;
import ch.dvbern.tax.common.presentation.cd.parts.TextPart;
import ch.dvbern.tax.common.presentation.cd.resourcetools.manager.ToolCommunication;
import ch.dvbern.tax.common.presentation.cd.util.MessageControlMapper;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeCompositeValue;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.failure.NotYetImplementedException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class ValueBuilder
extends AControlBuilder {
    private static final String DATA_KEY_SHORTHELP = "shortHelpKey";
    private IValueItem valueDTO = null;
    private Control control = null;
    private final boolean toolsEnabled = TaxmeConfig.getBoolean("ToolsEnabled");

    public void init(@NonNull IValueItem valueDTO) {
        this.valueDTO = valueDTO;
        this.control = null;
    }

    @Override
    public void createControl() {
        this.control = this.createValuePart(this.valueDTO);
    }

    protected @NonNull Control createValuePart(IValueItem item) {
        Collection<MessageItemDTO> msgs;
        String shortHelpKey;
        TaxmeCompositeValue valueCtrl = (TaxmeCompositeValue)this.controlReuseUtil.getControl(item.getUID());
        if (valueCtrl == null) {
            switch (item.getType()) {
                case 0: {
                    valueCtrl = new TextPart(this.parent);
                    break;
                }
                case 4: {
                    valueCtrl = new TextAreaPart(this.parent);
                    break;
                }
                case 3: {
                    valueCtrl = new CheckboxPart(this.parent);
                    break;
                }
                case 1: {
                    valueCtrl = new RadioGroupPart(this.parent, item.getLayout());
                    break;
                }
                case 2: {
                    valueCtrl = new ComboboxPart(this.parent);
                    break;
                }
                case 5: {
                    throw new NotYetImplementedException("SuggestionBox not yet implemented for CD.");
                }
                default: {
                    valueCtrl = new HiddenPart(this.parent);
                }
            }
            this.addFocusListener((Control)valueCtrl);
            this.controlReuseUtil.addControl(item.getUID(), (Control)valueCtrl);
            if (item.isMoveToForeground()) {
                valueCtrl.moveAbove(null);
            }
            if (item instanceof AExpertItem) {
                valueCtrl.addFocusListener(new HighlightFocusElementListener());
            }
        }
        valueCtrl.init(item);
        if (TaxmeController.isGuiEditEnabled()) {
            valueCtrl.makeGuiEditable();
        }
        if ((shortHelpKey = item.getShortHelpKey()) == null) {
            shortHelpKey = "";
        }
        valueCtrl.setData(DATA_KEY_SHORTHELP, shortHelpKey);
        Rectangle bounds = item.getBounds();
        if (bounds != null) {
            valueCtrl.setBounds(bounds);
        }
        if ((msgs = item.getMessages()) != null && !msgs.isEmpty()) {
            for (MessageItemDTO msg : msgs) {
                MessageControlMapper.getInstance().put(msg, (Control)valueCtrl);
            }
        }
        return valueCtrl;
    }

    private void addFocusListener(final @NonNull Control ctrl) {
        ctrl.addFocusListener((FocusListener)new FocusAdapter(this){

            public void focusGained(FocusEvent ev) {
                HelpPart part = TaxmeController.getInstance().getApp().getCompositeManager().getHelpPart();
                if (part != null) {
                    String key = (String)ctrl.getData(ValueBuilder.DATA_KEY_SHORTHELP);
                    boolean shortHelpMappingExists = TaxmeController.getInstance().getShortHelpMapping().contains(key);
                    if (!key.isEmpty() && shortHelpMappingExists) {
                        part.setContent(key);
                    }
                }
            }
        });
        if (this.toolsEnabled) {
            ctrl.addMouseListener((MouseListener)new MouseAdapter(this){

                public void mouseDoubleClick(MouseEvent ev) {
                    if (ev.button == 1) {
                        String key = (String)ctrl.getData(ValueBuilder.DATA_KEY_SHORTHELP);
                        ToolCommunication.getInstance().manageShortHelpMappingOnControls(TaxmeController.getInstance().getApp(), key);
                    }
                }
            });
        }
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public List<? extends Control> getTabOrder() {
        return Collections.singletonList(this.control);
    }
}

