/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeTitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ChangePasswordDialog
extends TaxmeTitleAreaDialog {
    private Text textOldPassword;
    private Text textNewPassword;
    private Text textConfPassword;

    public ChangePasswordDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.configurableTranslate("title.password.change", new Object[0]));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.configurableTranslate("title.password.change", new Object[0]));
        this.setMessage(Messages.configurableTranslate("label.password.change.message", new Object[0]));
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        panel.setFont(parent.getFont());
        Label labelOldPassword = new Label(panel, 0);
        labelOldPassword.setText(Messages.configurableTranslate("label.password.change.old", (Control)labelOldPassword, new Object[0]));
        this.textOldPassword = new Text(panel, 2048);
        this.textOldPassword.setEchoChar('*');
        this.textOldPassword.setLayoutData((Object)new GridData(768));
        this.textOldPassword.setFocus();
        Label labelNewPassword = new Label(panel, 0);
        labelNewPassword.setText(Messages.configurableTranslate("label.password.change.new", (Control)labelNewPassword, new Object[0]));
        this.textNewPassword = new Text(panel, 2048);
        this.textNewPassword.setEchoChar('*');
        this.textNewPassword.setLayoutData((Object)new GridData(768));
        Label labelConfPassword = new Label(panel, 0);
        labelConfPassword.setText(Messages.configurableTranslate("label.password.change.confirm", (Control)labelConfPassword, new Object[0]));
        this.textConfPassword = new Text(panel, 2048);
        this.textConfPassword.setEchoChar('*');
        this.textConfPassword.setLayoutData((Object)new GridData(768));
        return panel;
    }

    protected void okPressed() {
        if (!this.textNewPassword.getText().equals(this.textConfPassword.getText())) {
            DialogUtil.showErrorDialog("message.password.change.confirm.invalid", new Object[0]);
        } else {
            try {
                TaxmeController.getInstance().getTmoCdSession().changePassword(this.textOldPassword.getText(), this.textNewPassword.getText());
                this.close();
            }
            catch (InvalidAuthenticationException ex) {
                DialogUtil.showErrorDialog("message.password.change.old.invalid", new Object[0]);
            }
        }
    }
}

