/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpMainhelpAction;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class CustomMessageDialog
extends MessageDialog {
    private Rectangle bounds = null;
    private String messageKey;
    private Object[] msgArgs;

    public CustomMessageDialog(Shell shell, int image, String titleKey, Object[] titleArgs, int defButton, String messageKey, Object[] msgArgs, String[] buttons) {
        super(shell, Messages.translate(titleKey, titleArgs), null, Messages.translate(messageKey, msgArgs), image, buttons, defButton);
        this.messageKey = messageKey;
        this.msgArgs = msgArgs;
    }

    public CustomMessageDialog(Shell shell, int image, String titleKey, Object[] titleArgs, int defButton, String messageKey, Object[] msgArgs, String[] buttons, Rectangle bounds) {
        super(shell, Messages.translate(titleKey, titleArgs), null, Messages.translate(messageKey, msgArgs), image, buttons, defButton);
        this.bounds = bounds;
        this.messageKey = messageKey;
        this.msgArgs = msgArgs;
    }

    public CustomMessageDialog(Shell shell, String title, Image titleImage, String message, int dialogMessageType, String[] buttons, int defButton) {
        super(shell, title, titleImage, message, dialogMessageType, buttons, defButton);
    }

    public CustomMessageDialog(Shell shell, String title, Image titleImage, String message, int dialogMessageType, String[] buttons, int defButton, Rectangle bounds) {
        super(shell, title, titleImage, message, dialogMessageType, buttons, defButton);
        this.bounds = bounds;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (TaxmeConfig.getBoolean("centerPopups") && this.bounds != null) {
            shell.setBounds(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            DialogUtil.centerInCurrentMonitor(shell);
        }
    }

    protected Control createMessageArea(Composite composite) {
        SelectionListener openHelpLst = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                HelpMainhelpAction help = new HelpMainhelpAction(CustomMessageDialog.this.getShell(), event.text);
                help.run();
            }
        };
        Image image1 = this.getImage();
        if (image1 != null) {
            this.imageLabel = new Label(composite, 0);
            image1.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image1);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            Link link = new Link(composite, this.getMessageLabelStyle());
            if (this.messageKey != null) {
                link.setText(Messages.translate(this.messageKey, this.msgArgs));
            } else {
                link.setText(this.message);
            }
            link.addSelectionListener(openHelpLst);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)link);
        }
        return composite;
    }
}

