/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.MixedPrintableAction;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeTitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.printing.PrintEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MixedPrintDialog
extends TaxmeTitleAreaDialog {
    protected final @NonNull List<Button> buttonsEinzeln = new ArrayList<Button>();
    protected final @NonNull List<Button> buttonsAlle = new ArrayList<Button>();
    protected final @NonNull List<PrintEntry> printables;
    protected final @NonNull List<MixedPrintableAction> printAllPrintables;
    private static final int MARGIN_LEFT = 20;
    private @Nullable MixedPrintableAction mixedPrintableAction = null;

    public MixedPrintDialog(@NonNull Shell parentShell, @NonNull Collection<PrintEntry> printEntries, @Nullable Collection<MixedPrintableAction> printAllPrintables) {
        super(parentShell);
        this.printables = Collections.unmodifiableList(new ArrayList<PrintEntry>(printEntries));
        ArrayList<MixedPrintableAction> allPrintables = new ArrayList<MixedPrintableAction>();
        if (printAllPrintables != null) {
            allPrintables.addAll(printAllPrintables);
        }
        this.printAllPrintables = Collections.unmodifiableList(allPrintables);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.configurableTranslate("title.shell.print.dialog", new Object[0]));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.configurableTranslate("title.print.dialog", new Object[0]));
        this.setMessage(Messages.configurableTranslate("label.print.message", new Object[0]));
        TaxmeController ctrl = TaxmeController.getInstance();
        DvbTaxCdSession session = ctrl.getTmoCdSession();
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData());
        Label labelEinzeln = new Label(panel, 64);
        GridData gd = new GridData();
        gd.widthHint = 500;
        labelEinzeln.setLayoutData((Object)gd);
        labelEinzeln.setText(Messages.configurableTranslate("label.print.einzelformulare", (Control)labelEinzeln, new Object[0]));
        this.buttonsEinzeln.clear();
        for (PrintEntry printEntry : this.printables) {
            GridData gd2 = new GridData();
            gd2.horizontalIndent = 20;
            Button buttonEinzeln = new Button(panel, 32);
            buttonEinzeln.setLayoutData((Object)gd2);
            buttonEinzeln.setData((Object)printEntry);
            String title = Messages.configurableTranslate(printEntry.getTitleKey(), new Object[0]);
            buttonEinzeln.setText(title);
            buttonEinzeln.setEnabled(printEntry.isFormularEnabled());
            this.buttonsEinzeln.add(buttonEinzeln);
        }
        Label labelAlles = new Label(panel, 64);
        GridData gdAlles = new GridData();
        gdAlles.widthHint = 500;
        labelAlles.setLayoutData((Object)gdAlles);
        labelAlles.setText(Messages.configurableTranslate("label.print.alleformulare", (Control)labelAlles, new Object[0]));
        int stateStek = session.getDataModelState();
        if (stateStek != 1 && stateStek != 2) {
            Label labelWarnung = new Label(panel, 64);
            GridData gdWarnung = new GridData();
            gdWarnung.widthHint = 500;
            labelWarnung.setLayoutData((Object)gdWarnung);
            labelWarnung.setFont(GuiUtil.getFontRegistry().getBold("font.normal"));
            labelWarnung.setForeground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_RED));
            labelWarnung.setText(Messages.configurableTranslate("label.print.warnung.nicht.gruen", (Control)labelWarnung, new Object[0]));
        }
        this.buttonsAlle.clear();
        for (MixedPrintableAction printable : this.printAllPrintables) {
            GridData gd4 = new GridData();
            gd4.horizontalIndent = 20;
            Button buttonAlles = new Button(panel, 32);
            if (stateStek == 1 || stateStek == 2) {
                buttonAlles.setEnabled(true);
            } else {
                buttonAlles.setEnabled(false);
            }
            buttonAlles.setLayoutData((Object)gd4);
            buttonAlles.setText(printable.getLabel());
            buttonAlles.addSelectionListener((SelectionListener)new PrintAllSelectionListener());
            buttonAlles.setData((Object)printable);
            this.buttonsAlle.add(buttonAlles);
        }
        return panel;
    }

    protected synchronized void okPressed() {
        this.mixedPrintableAction = this.buildPrintAction();
        super.okPressed();
    }

    public @Nullable MixedPrintableAction getMixedPrintableAction() {
        return this.mixedPrintableAction;
    }

    protected @Nullable MixedPrintableAction buildPrintAction() {
        for (Button button : this.buttonsAlle) {
            if (!button.getSelection() || !(button.getData() instanceof MixedPrintableAction)) continue;
            return (MixedPrintableAction)button.getData();
        }
        List<PrintEntry> checked = this.getChecked();
        if (!checked.isEmpty()) {
            @NonNull FormRendererConfiguration config = new FormRendererConfiguration().withCopyWatermark(true);
            MixedPrintableAction printAction = new MixedPrintableAction(checked, config);
            return printAction;
        }
        return null;
    }

    private List<PrintEntry> getChecked() {
        ArrayList<PrintEntry> checked = new ArrayList<PrintEntry>();
        for (Button button : this.buttonsEinzeln) {
            if (!button.getSelection()) continue;
            PrintEntry printEntry = (PrintEntry)button.getData();
            checked.add(printEntry);
        }
        return checked;
    }

    protected void enableButtonsEinzeln() {
        for (Button button : this.buttonsEinzeln) {
            PrintEntry printEntry = (PrintEntry)button.getData();
            button.setEnabled(printEntry.isFormularEnabled());
        }
        Iterator<Button> iterator = this.buttonsAlle.iterator();
        while (iterator.hasNext()) {
            Button element;
            Button button = element = iterator.next();
            button.setEnabled(true);
        }
    }

    protected void disableButtonsEinzeln() {
        for (Button button : this.buttonsEinzeln) {
            button.setSelection(false);
            button.setEnabled(false);
        }
    }

    protected class PrintAllSelectionListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent ev) {
            if (((Button)ev.getSource()).getSelection()) {
                MixedPrintDialog.this.disableButtonsEinzeln();
                Iterator<Button> iterator = MixedPrintDialog.this.buttonsAlle.iterator();
                while (iterator.hasNext()) {
                    Button element;
                    Button button = element = iterator.next();
                    if (ev.getSource() == button) continue;
                    button.setEnabled(false);
                }
            } else {
                MixedPrintDialog.this.enableButtonsEinzeln();
            }
        }
    }
}

