/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeTitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.ProxyConfig;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeButton;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProxySettingsDialog
extends TaxmeTitleAreaDialog {
    private Button systemSettingsBtn;
    private Button customSettingsBtn;
    private Button buttonEnabled;
    private Text textHost;
    private Text textPort;
    private final ProxyConfig initialConfig;
    private ProxyConfig newConfig = null;

    public ProxySettingsDialog(Shell parentShell, ProxyConfig config) {
        super(parentShell);
        if (config == null) {
            throw new NullPointerException("Proxy configuration cannot be null");
        }
        this.initialConfig = config;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.configurableTranslate("title.proxy.conf", new Object[0]));
        if (TaxmeConfig.getBoolean("centerPopups")) {
            shell.setBounds(0, 0, 600, 300);
            DialogUtil.centerInCurrentMonitor(shell);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.configurableTranslate("title.proxy.conf", new Object[0]));
        this.setMessage(Messages.configurableTranslate("label.proxy.conf.message", new Object[0]));
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        this.buttonEnabled = new TaxmeButton(panel, 32);
        this.buttonEnabled.setText(Messages.configurableTranslate("label.proxy.conf.enabled", (Control)this.buttonEnabled, new Object[0]));
        GridDataFactory spanDataFactory = GridDataFactory.fillDefaults().span(2, 1);
        this.buttonEnabled.setLayoutData((Object)spanDataFactory.create());
        this.customSettingsBtn = new Button(panel, 16);
        this.customSettingsBtn.setText(Messages.configurableTranslate("label.proxy.conf.customSettings", new Object[0]));
        this.customSettingsBtn.setLayoutData((Object)spanDataFactory.create());
        Label labelHost = new Label(panel, 0);
        labelHost.setText(Messages.configurableTranslate("label.proxy.conf.host", (Control)labelHost, new Object[0]));
        this.textHost = new Text(panel, 2048);
        this.textHost.setLayoutData((Object)new GridData(768));
        Label labelPort = new Label(panel, 0);
        labelPort.setText(Messages.configurableTranslate("label.proxy.conf.port", (Control)labelPort, new Object[0]));
        this.textPort = new Text(panel, 2048);
        this.textPort.setLayoutData((Object)new GridData(768));
        this.buttonEnabled.setSelection(this.initialConfig.isProxyEnabled());
        String host = this.initialConfig.getHost();
        int port = this.initialConfig.getPort();
        if (host != null) {
            this.textHost.setText(host);
        }
        if (port != 0) {
            this.textPort.setText(Integer.toString(port));
        }
        this.systemSettingsBtn = new Button(panel, 16);
        this.systemSettingsBtn.setText(Messages.configurableTranslate("label.proxy.conf.systemSettings", new Object[0]));
        this.systemSettingsBtn.setLayoutData((Object)spanDataFactory.create());
        boolean systemSettingsEnabled = this.initialConfig.isSystemSettingsEnabled();
        this.customSettingsBtn.setSelection(!systemSettingsEnabled);
        this.systemSettingsBtn.setSelection(systemSettingsEnabled);
        this.setFieldsState();
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                ProxySettingsDialog.this.setFieldsState();
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }
        };
        this.buttonEnabled.addSelectionListener(listener);
        this.systemSettingsBtn.addSelectionListener(listener);
        if (this.buttonEnabled.getSelection()) {
            this.textHost.setFocus();
        } else {
            this.buttonEnabled.setFocus();
        }
        return panel;
    }

    protected void okPressed() {
        int port;
        try {
            port = Integer.parseInt(this.textPort.getText());
        }
        catch (NumberFormatException nfe) {
            DialogUtil.showErrorDialog("error.proxy.config.port", new Object[0]);
            return;
        }
        this.newConfig = new ProxyConfig(this.buttonEnabled.getSelection(), this.systemSettingsBtn.getSelection(), this.textHost.getText(), port);
        super.okPressed();
    }

    public ProxyConfig getNewProxyConfig() {
        return this.newConfig;
    }

    private void setFieldsState() {
        boolean proxyEnabled = this.buttonEnabled.getSelection();
        boolean customSettingsEnabled = proxyEnabled && this.customSettingsBtn.getSelection();
        this.textHost.setEnabled(customSettingsEnabled);
        this.textPort.setEnabled(customSettingsEnabled);
        this.customSettingsBtn.setEnabled(proxyEnabled);
        this.systemSettingsBtn.setEnabled(proxyEnabled);
    }
}

