/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.expertdisplay;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeComposite;
import ch.dvbern.tax.common.presentation.common.util.StringUtil;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.List;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ExpertMultiFormIndexPart
extends TaxmeComposite {
    private static final Image IMG_DELETE = GuiUtil.getImageRegistry().get("icon.button.delete");
    private static final Image IMG_ADD = GuiUtil.getImageRegistry().get("icon.button.add");
    private static final Image IMG_OK = GuiUtil.getImageRegistry().get("icon.state.ok");
    private static final Image IMG_WARNING = GuiUtil.getImageRegistry().get("icon.state.warning");
    private static final Image IMG_MISSING = GuiUtil.getImageRegistry().get("icon.state.missingvalue");
    private static final Image IMG_ERROR = GuiUtil.getImageRegistry().get("icon.state.error");
    private static final Color COL_OK = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREEN);
    private static final Color COL_WARNING = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_YELLOW);
    private static final Color COL_MISSING = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE);
    private static final Color COL_TRANSP = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY);
    private static final Color COL_ERROR = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_RED);
    private static final Color COL_WHITE = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE);
    private static final Color COL_GREY_LIGHT = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY_LIGHT);
    private final ImageRegistry imageRegistry = new ImageRegistry();

    public ExpertMultiFormIndexPart(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(4, false));
        this.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
    }

    public void setContent(ExpertDisplayInfoDTO expertInfoDTO) {
        ExpertDisplayInfoDTO.NavigationDTO newEntry = null;
        for (Object element2 : expertInfoDTO.getNavigationItems()) {
            ExpertDisplayInfoDTO.NavigationDTO element = (ExpertDisplayInfoDTO.NavigationDTO)element2;
            if (!element.isSelected()) continue;
            this.createRows(element.getSubItems());
            newEntry = element.getNewEntryItem();
        }
        if (newEntry != null) {
            this.addNewEntry(newEntry);
        }
        this.layout();
    }

    private void createHeaderLine() {
        Label header = this.createHeaderLabel();
        header.setText(Messages.configurableTranslate("label.multiform.header.delete", (Control)header, new Object[0]));
        header = this.createHeaderLabel();
        header.setText(Messages.configurableTranslate("label.multiform.header.state", (Control)header, new Object[0]));
        header = this.createHeaderLabel();
        header.setText(Messages.configurableTranslate("label.multiform.header.desc", (Control)header, new Object[0]));
        header = this.createHeaderLabel();
        header.setText(Messages.configurableTranslate("label.multiform.header.forms", (Control)header, new Object[0]));
    }

    private Label createHeaderLabel() {
        Label label = new Label((Composite)this, 0);
        GridData gd = new GridData(768);
        label.setLayoutData((Object)gd);
        label.setBackground(COL_GREY_LIGHT);
        label.setFont(GuiUtil.getFontRegistry().get("font.header.table"));
        return label;
    }

    private void addNewEntry(ExpertDisplayInfoDTO.NavigationDTO newEntry) {
        final TaxmeController ctrl = TaxmeController.getInstance();
        TaxmeComposite c = new TaxmeComposite(this, 0);
        c.setBackground(COL_WHITE);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 4;
        c.setLayoutData(gd);
        c.setLayout((Layout)new GridLayout(2, false));
        Label b = new Label((Composite)c, 0);
        b.setImage(IMG_ADD);
        final String fak = newEntry.getAccessKey();
        b.addMouseListener((MouseListener)new MouseAdapter(this){

            public void mouseDown(MouseEvent ev) {
                ctrl.setFormAccessKey(fak);
            }
        });
        if (newEntry.getDescriptionKey() != null) {
            Label desc = new Label((Composite)c, 0);
            AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), newEntry.getTableEntryDMK());
            String msg = ExpertDisplayInfoDTO.getLabelText((String)newEntry.getDescriptionKey(), (List)newEntry.getDesciptionAddOns(), (AbstractConverter.ConverterContext)ctx);
            msg = StringUtil.htmlToText((String)msg);
            desc.setText(msg);
            desc.setBackground(COL_WHITE);
            desc.setFont(GuiUtil.getFontRegistry().get("font.normal"));
        }
    }

    private void createRows(List<ExpertDisplayInfoDTO.NavigationDTO> forms) {
        boolean rowFound = false;
        if (forms != null) {
            for (ExpertDisplayInfoDTO.NavigationDTO subItem : forms) {
                if (!subItem.isEditable() && !subItem.isDeleteable()) continue;
                rowFound = true;
            }
            if (rowFound) {
                this.createHeaderLine();
            }
            for (ExpertDisplayInfoDTO.NavigationDTO element : forms) {
                if (!element.isEditable() && !element.isDeleteable()) continue;
                this.createRow(element);
            }
        }
        Label l = new Label((Composite)this, 0);
        l.setFont(GuiUtil.getFontRegistry().get("font.normal"));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 4;
        l.setLayoutData((Object)gd);
        l.setBackground(COL_WHITE);
        if (rowFound) {
            l.setText(Messages.configurableTranslate("label.expert.erklaerung.bearbeiten", (Control)l, new Object[0]));
        } else {
            l.setText(Messages.configurableTranslate("label.kein.eintrag", (Control)l, new Object[0]));
        }
    }

    private void createRow(final ExpertDisplayInfoDTO.NavigationDTO element) {
        GridData gd;
        final TaxmeController ctrl = TaxmeController.getInstance();
        TaxmeComposite c = new TaxmeComposite(this, 0);
        c.setLayoutData(new GridData(1808));
        c.setLayout((Layout)new GridLayout(1, false));
        c.setBackground(COL_GREY_LIGHT);
        if (element.isDeleteable()) {
            Label b = new Label((Composite)c, 0);
            gd = new GridData(1808);
            gd.horizontalAlignment = 0x1000000;
            gd.verticalAlignment = 0x1000000;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            b.setLayoutData((Object)gd);
            b.setImage(IMG_DELETE);
            b.setToolTipText(Messages.translate("label.button.delete", b));
            b.addMouseListener((MouseListener)new MouseAdapter(this){

                public void mouseDown(MouseEvent ev) {
                    if (DialogUtil.showYesNoDialog("message.askTableRowDelete", new Object[0])) {
                        ctrl.getTmoCdSession().delete(element.getTableEntryDMK());
                        ctrl.update();
                    }
                }
            });
        }
        c = new TaxmeComposite(this, 0);
        c.setLayoutData(new GridData(1808));
        c.setLayout((Layout)new GridLayout(1, false));
        c.setBackground(COL_GREY_LIGHT);
        Label state = new Label((Composite)c, 0);
        gd = new GridData(1808);
        gd.horizontalAlignment = 2;
        gd.verticalAlignment = 2;
        state.setLayoutData((Object)gd);
        state.setBackground(COL_GREY_LIGHT);
        switch (element.getState()) {
            case 4: {
                state.setImage(IMG_ERROR);
                break;
            }
            case 2: {
                state.setImage(IMG_WARNING);
                break;
            }
            case 3: {
                state.setImage(IMG_MISSING);
                break;
            }
            default: {
                state.setImage(IMG_OK);
            }
        }
        TaxmeComposite desc = new TaxmeComposite(this, 0);
        desc.setLayout((Layout)new GridLayout(1, false));
        desc.setLayoutData(new GridData(1808));
        desc.setBackground(COL_GREY_LIGHT);
        Label name = new Label((Composite)desc, 0);
        name.setBackground(COL_GREY_LIGHT);
        name.setFont(GuiUtil.getFontRegistry().get("font.normal"));
        if (element.getDescriptionKey() != null) {
            AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), element.getTableEntryDMK());
            String msg = ExpertDisplayInfoDTO.getLabelText((String)element.getDescriptionKey(), (List)element.getDesciptionAddOns(), (AbstractConverter.ConverterContext)ctx);
            msg = StringUtil.htmlToText((String)msg);
            name.setText(msg);
        }
        TaxmeComposite forms = new TaxmeComposite(this, 0);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        forms.setLayoutData(gd);
        forms.setBackground(COL_GREY_LIGHT);
        GridLayout fl = new GridLayout(element.getSubItemsCount(), false);
        forms.setLayout((Layout)fl);
        if (element.getSubItems() == null || element.getSubItems().isEmpty()) {
            this.addForm(forms, element);
        } else {
            for (Object element2 : element.getSubItems()) {
                ExpertDisplayInfoDTO.NavigationDTO form = (ExpertDisplayInfoDTO.NavigationDTO)element2;
                this.addForm(forms, form);
            }
        }
    }

    private void addForm(TaxmeComposite forms, final ExpertDisplayInfoDTO.NavigationDTO form) {
        final TaxmeController ctrl = TaxmeController.getInstance();
        TaxmeComposite formComp = new TaxmeComposite(forms, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginRight = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 6;
        formComp.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 2;
        gd.verticalAlignment = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        formComp.setLayoutData(gd);
        switch (form.getState()) {
            case 4: {
                formComp.setBackground(COL_ERROR);
                break;
            }
            case 2: {
                formComp.setBackground(COL_WARNING);
                break;
            }
            case 3: {
                formComp.setBackground(COL_MISSING);
                break;
            }
            case 11: {
                formComp.setBackground(COL_TRANSP);
                break;
            }
            default: {
                formComp.setBackground(COL_OK);
            }
        }
        Label fb = new Label((Composite)formComp, 0);
        Image img = this.readImage(form.getIconName());
        if (img != null) {
            fb.setImage(img);
        }
        if (form.getDescriptionKey() != null) {
            AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), form.getTableEntryDMK());
            String msg = ExpertDisplayInfoDTO.getLabelText((String)form.getDescriptionKey(), (List)form.getDesciptionAddOns(), (AbstractConverter.ConverterContext)ctx);
            msg = StringUtil.htmlToText((String)msg);
            fb.setToolTipText(msg);
        }
        fb.addMouseListener((MouseListener)new MouseAdapter(this){

            public void mouseDown(MouseEvent arg0) {
                ctrl.setFormAccessKey(form.getAccessKey());
            }
        });
    }

    private Image readImage(String name) {
        return GuiUtil.getImage(TaxmeController.getInstance().getFormSource(), name, this.imageRegistry);
    }
}

