/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.help.util;

import ch.dvbern.tax.common.presentation.common.util.HelpMapping;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;

public final class EditableHelpMapping
extends HelpMapping {
    private final Properties config;

    private EditableHelpMapping(Properties config, boolean fallbackOnParent) {
        super((Map)config, fallbackOnParent, "kurzhilfeDefault.html");
        assert (config != null);
        this.config = config;
    }

    public static EditableHelpMapping loadEmpty(boolean fallbackOnParent) {
        return new EditableHelpMapping(new Properties(), fallbackOnParent);
    }

    public static EditableHelpMapping load(InputStream input, boolean fallbackOnParent) throws IOException {
        if (input == null) {
            throw new NullPointerException("Input stream cannot be null");
        }
        Properties props = new Properties();
        props.load(input);
        return new EditableHelpMapping(props, fallbackOnParent);
    }

    public void store(OutputStream output) throws IOException {
        if (output == null) {
            throw new NullPointerException("Output stream cannot be null");
        }
        this.config.store(output, "Help Mapping");
    }

    public String set(String key, String path) {
        if (key == null || path == null) {
            throw new NullPointerException("Invalid null in key-value pair (" + key + "=" + path + ")");
        }
        return (String)this.config.put(key, path);
    }

    public String remove(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return (String)this.config.remove(key);
    }
}

