/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.EValueItem;
import ch.dvbern.tax.common.presentation.cd.util.ScrollingFocusListener;
import ch.dvbern.tax.common.presentation.cd.widgets.BorderedLabel;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeButton;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeCompositeValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CheckboxPart
extends TaxmeCompositeValue {
    private static ScrollingFocusListener focusListener = new ScrollingFocusListener();
    private BorderedLabel label;
    private TaxmeButton button;
    private IValueItem item;
    private final List<FocusListener> focusListeners = new ArrayList<FocusListener>();
    private final List<MouseListener> mouseListeners = new ArrayList<MouseListener>();

    public CheckboxPart(Composite parent) {
        super(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.setLayoutData(gd);
    }

    public void addFocusListener(FocusListener arg0) {
        this.focusListeners.add(arg0);
        if (this.button != null) {
            this.button.addFocusListener(arg0);
        }
    }

    public void removeFocusListener(FocusListener arg0) {
        this.focusListeners.remove(arg0);
        if (this.button != null) {
            this.button.removeFocusListener(arg0);
        }
    }

    public void addMouseListener(MouseListener arg0) {
        super.addMouseListener(arg0);
        this.mouseListeners.add(arg0);
        if (this.button != null) {
            this.button.addMouseListener(arg0);
        }
    }

    public void removeMouseListener(MouseListener arg0) {
        super.addMouseListener(arg0);
        this.mouseListeners.remove(arg0);
        if (this.button != null) {
            this.button.removeMouseListener(arg0);
        }
    }

    @Override
    public void init(IValueItem item) {
        this.item = item;
        GridData gd = (GridData)this.getLayoutData();
        gd.horizontalSpan = item.getColspan();
        this.setLayoutData(gd);
        this.setBackground(item.getBackgroundColor());
        this.setForeground(item.getForegroundColor());
        switch (item.getStyle()) {
            case 1: {
                this.initReadOnly();
                break;
            }
            case 3: {
                this.initReadOnly();
                break;
            }
            case 2: {
                this.initTransparent();
                break;
            }
            default: {
                this.initEnabled();
            }
        }
        this.layout();
    }

    private void initReadOnly() {
        if (this.label == null) {
            this.label = new BorderedLabel(this, 0);
            this.label.setLayoutData(new GridData(768));
            if (this.button != null) {
                this.button.dispose();
                this.button = null;
            }
        }
        if (this.item instanceof EValueItem) {
            if (this.getSelectionFromItem()) {
                this.label.setText("X");
                this.label.setAlignment(0x1000000);
            } else {
                this.label.setText("");
            }
        } else {
            this.label.setText(this.item.getRenderedValue());
        }
        this.label.setFont(this.item.getFont());
        this.label.setForeground(this.item.getForegroundColor());
        this.label.setBackground(this.item.getBackgroundColor());
    }

    private void initTransparent() {
        this.initializeButton();
        this.button.setEnabled(false);
    }

    private void initEnabled() {
        this.initializeButton();
        this.button.setEnabled(true);
        this.button.setForeground(this.item.getForegroundColor());
        this.button.setBackground(this.item.getBackgroundColor());
    }

    private void initializeButton() {
        if (this.button == null) {
            FocusListener li;
            this.button = new TaxmeButton(this, 32);
            this.button.addSelectionListener(new CheckBoxListener());
            this.button.addFocusListener(focusListener);
            Iterator<FocusListener> iterator = this.focusListeners.iterator();
            while (iterator.hasNext()) {
                FocusListener focusListener;
                li = focusListener = iterator.next();
                this.button.addFocusListener(li);
            }
            for (FocusListener focusListener : this.mouseListeners) {
                li = (MouseListener)focusListener;
                this.button.addMouseListener((MouseListener)li);
            }
            GridData gdButton = new GridData(768);
            gdButton.horizontalAlignment = 0x1000000;
            this.button.setLayoutData(gdButton);
            if (this.label != null) {
                this.label.dispose();
                this.label = null;
            }
        }
        this.button.setSelection(this.getSelectionFromItem());
        if (this.item.getValue() == null) {
            this.item.setDefaultValue(this.getValue(this.button.getSelection()));
        }
    }

    private boolean getSelectionFromItem() {
        if (this.item.getOptionValue() == null) {
            if (this.item.getValue() instanceof Boolean) {
                return (Boolean)this.item.getValue();
            }
            if (this.item.getValue() instanceof String) {
                return Boolean.valueOf((String)this.item.getValue());
            }
            return this.item.getValue() != null;
        }
        String s1 = this.item.getOptionValue().toString();
        String s2 = this.item.getValue() != null ? this.item.getValue().toString() : null;
        return s1.equals(s2);
    }

    private String getValue(boolean selected) {
        if (this.item.getOptionValue() != null) {
            return this.item.getOptionValue().toString();
        }
        return String.valueOf(selected);
    }

    public boolean setFocus() {
        if (null != this.button) {
            return this.button.setFocus();
        }
        return super.setFocus();
    }

    public boolean forceFocus() {
        if (null != this.button) {
            return this.button.forceFocus();
        }
        return super.forceFocus();
    }

    @Override
    public void makeGuiEditable() {
        super.makeGuiEditable(this.item, (Control)this.button, this.label);
    }

    private class CheckBoxListener
    implements SelectionListener {
        private CheckBoxListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            CheckboxPart.this.item.update(CheckboxPart.this.getValue(CheckboxPart.this.button.getSelection()));
            CheckboxPart.this.button.setFocus();
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }
    }
}

