/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.cd.util.ScrollingFocusListener;
import ch.dvbern.tax.common.presentation.cd.widgets.BorderedLabel;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeCompositeValue;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeText;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TextAreaPart
extends TaxmeCompositeValue {
    private static final Control[] EMPTY_TAB_LIST = new Control[0];
    private static final ScrollingFocusListener focusListener = new ScrollingFocusListener();
    private static final Color WHITE = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE);
    private static final Color YELLOW = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_YELLOW);
    private static final Color ORANGE = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_ORANGE);
    private static final Color RED = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_RED);
    private TaxmeText text;
    private BorderedLabel label;
    private final TextListener textListener = new TextListener();
    private Pattern pattern;
    private String regex;
    private IValueItem item;
    private String oldValue;
    private final List<FocusListener> focusListeners = new ArrayList<FocusListener>();
    private final List<MouseListener> mouseListeners = new ArrayList<MouseListener>();

    public TextAreaPart(Composite parent) {
        super(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.setLayoutData(gd);
    }

    public void addFocusListener(FocusListener arg0) {
        this.focusListeners.add(arg0);
        if (this.text != null) {
            this.text.addFocusListener(arg0);
        }
    }

    public void removeFocusListener(FocusListener arg0) {
        this.focusListeners.remove(arg0);
        if (this.text != null) {
            this.text.removeFocusListener(arg0);
        }
    }

    public void addMouseListener(MouseListener arg0) {
        super.addMouseListener(arg0);
        this.mouseListeners.add(arg0);
        if (this.text != null) {
            this.text.addMouseListener(arg0);
        }
    }

    public void removeMouseListener(MouseListener arg0) {
        super.addMouseListener(arg0);
        this.mouseListeners.remove(arg0);
        if (this.text != null) {
            this.text.removeMouseListener(arg0);
        }
    }

    private void initText() {
        boolean border = this.item.hasBorder();
        if (this.label != null) {
            this.label.dispose();
            this.label = null;
        }
        if (this.text != null) {
            boolean hasBorder;
            boolean bl = hasBorder = (this.text.getStyle() & 0x800) != 0;
            if (border != hasBorder) {
                this.text.dispose();
                this.text = null;
            }
        }
        if (this.text == null) {
            int align = 16384;
            if ("right".equals(this.item.getAlign())) {
                align = 131072;
            } else if ("center".equals(this.item.getAlign())) {
                align = 0x1000000;
            }
            this.text = new TaxmeText(this, 0x42 | (border ? 2048 : 0) | align);
            this.text.setLayoutData(new GridData(1808));
            this.text.addTraverseListener(new TraverseListener(this){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 16 || e.detail == 8) {
                        e.doit = true;
                    }
                }
            });
            this.text.addFocusListener(focusListener);
            this.text.addFocusListener(this.textListener);
            this.text.addModifyListener(this.textListener);
            for (FocusListener focusListener : this.focusListeners) {
                this.text.addFocusListener(focusListener);
            }
            for (MouseListener mouseListener : this.mouseListeners) {
                this.text.addMouseListener(mouseListener);
            }
            if (OsSupport.isMacOs()) {
                this.text.addListener(27, this.textListener);
            }
        }
        this.textListener.setEnabled(false);
        this.oldValue = this.item.getRenderedValue();
        this.text.setText(this.oldValue);
        if (OsSupport.isMaxOsPpc() && OsSupport.getVersion().startsWith("10.3")) {
            this.text.setBackground(WHITE);
            if (YELLOW.equals((Object)this.item.getBackgroundColor())) {
                this.text.setForeground(ORANGE);
            } else if (RED.equals((Object)this.item.getBackgroundColor())) {
                this.text.setForeground(RED);
            } else {
                this.text.setForeground(this.item.getForegroundColor());
            }
        } else {
            this.text.setBackground(this.item.getBackgroundColor());
            this.text.setForeground(this.item.getForegroundColor());
        }
        this.text.setFont(this.item.getFont());
        if (this.item.getStyle() != 0) {
            if (this.item.getForegroundColor() == null) {
                this.text.setEnabled(false);
            }
            if (!this.doSetFocusOnReadonlyFields()) {
                this.text.setEditable(false);
            } else {
                this.text.setEditable(true);
            }
            if (this.getTabList().length > 0 && !this.doSetFocusOnReadonlyFields()) {
                this.setTabList(EMPTY_TAB_LIST);
            }
        } else {
            this.text.setEnabled(true);
            this.text.setEditable(true);
            String newRegex = this.item.getRegularExpression();
            if (newRegex == null) {
                this.pattern = null;
            } else if (!newRegex.equals(this.regex)) {
                this.pattern = Pattern.compile(newRegex);
            }
            this.regex = newRegex;
            this.textListener.setEnabled(true);
            if (this.getTabList().length == 0) {
                this.setTabList(new Control[]{this.text});
            }
        }
    }

    private void initLabel() {
        if (this.text != null) {
            this.text.dispose();
            this.text = null;
        }
        if (this.label == null) {
            int align = 16384;
            if ("right".equals(this.item.getAlign())) {
                align = 131072;
            } else if ("center".equals(this.item.getAlign())) {
                align = 0x1000000;
            }
            this.label = new BorderedLabel(this, 0 | align);
            this.label.setLayoutData(new GridData(1808));
        }
        this.label.setFont(this.item.getFont());
        this.label.setText(this.item.getRenderedValue());
        this.label.setBackground(this.item.getBackgroundColor());
        this.label.setForeground(this.item.getForegroundColor());
    }

    @Override
    public void init(IValueItem item) {
        this.item = item;
        GridData gd = (GridData)this.getLayoutData();
        gd.horizontalSpan = item.getColspan();
        gd.verticalSpan = item.getRowspan();
        this.setLayoutData(gd);
        if (item.getStyle() == 3) {
            this.initLabel();
        } else {
            this.initText();
        }
        if (item.getBackgroundColor() != null) {
            this.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY_LIGHT));
        } else {
            this.setBackground(null);
        }
        this.layout();
    }

    private boolean doSetFocusOnReadonlyFields() {
        boolean setFocus = TaxmeConfig.getBoolean("set.focus.on.readonly.fields");
        if (setFocus) {
            boolean toolsEnabled = Boolean.valueOf(TaxmeConfig.getString("ToolsEnabled"));
            return TaxmeController.getInstance().getShortHelpMapping().contains(this.item.getShortHelpKey()) || toolsEnabled;
        }
        return false;
    }

    public boolean setFocus() {
        if (this.text != null && (this.text.getEditable() || this.doSetFocusOnReadonlyFields())) {
            return this.text.setFocus();
        }
        return false;
    }

    @Override
    public void makeGuiEditable() {
        super.makeGuiEditable(this.item, (Control)this.text, this.label);
    }

    private class TextListener
    implements ModifyListener,
    FocusListener,
    Listener {
        private boolean enabled = false;

        private TextListener() {
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void modifyText(ModifyEvent event) {
            if (!this.enabled) {
                return;
            }
            this.supportEntry(event);
        }

        public void focusGained(FocusEvent ev) {
            TextAreaPart.this.text.selectAll();
        }

        public void focusLost(FocusEvent ev) {
            this.handleEvent(null);
        }

        public void handleEvent(Event ev) {
            if (!this.enabled) {
                return;
            }
            String newValue = TextAreaPart.this.text.getText();
            if (!newValue.equals(TextAreaPart.this.oldValue) || TextAreaPart.this.item.isValidateIfLeftEmpty() && TextAreaPart.this.item.getState() == 3) {
                this.enabled = false;
                TextAreaPart.this.item.update(newValue);
            }
            if (TextAreaPart.this.text != null && !TextAreaPart.this.text.isDisposed()) {
                TextAreaPart.this.text.getText();
                TextAreaPart.this.text.setSelection(0);
            }
        }

        private void supportEntry(ModifyEvent event) {
            TaxmeText textPart = (TaxmeText)((Object)event.getSource());
            int position = textPart.getCaretPosition();
            if (position <= 0) {
                return;
            }
            String text = textPart.getText();
            boolean matches = true;
            if (TextAreaPart.this.pattern != null) {
                Matcher m = TextAreaPart.this.pattern.matcher(text);
                matches = m.matches();
            }
            if (!matches || TextAreaPart.this.item.calcLength(text) > TextAreaPart.this.item.getMaxLength()) {
                String oldText = textPart.getText().substring(0, position - 1) + textPart.getText().substring(position);
                textPart.setText(oldText);
                textPart.setSelection(position - 1);
            }
        }
    }
}

