/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.resourcetools;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.dialog.TranslationDialog;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TranslationManager {
    private static final Logger LOG = LoggerFactory.getLogger(TranslationManager.class);
    private static TranslationManager instance = null;
    private Map<String, Properties> resources = null;
    private final Set<String> setTranslations = new HashSet<String>();
    private Set<String> setTranslationsPrint = null;
    private final Map<Control, String> registeredControls = new HashMap<Control, String>();
    private TranslationMouseListener mouseListener;
    private TranslationDisposeListener disposeListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TranslationManager() {
        this.resources = new HashMap<String, Properties>();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            int languageCount = TaxmeConfig.getInt("language.count");
            for (int i = 0; i < languageCount; ++i) {
                String language = TaxmeConfig.getString("language." + i);
                Properties properties = new Properties();
                fis = new FileInputStream(TaxmeConfig.getResourceBundlePath(language));
                bis = new BufferedInputStream(fis);
                properties.load(bis);
                this.resources.put(language, properties);
            }
            this.mouseListener = new TranslationMouseListener();
            this.disposeListener = new TranslationDisposeListener();
        }
        catch (Exception e) {
            LOG.warn("error in TranslationManager", (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static synchronized TranslationManager getInstance() {
        if (instance == null) {
            instance = new TranslationManager();
        }
        return instance;
    }

    public DisposeListener getDisposeListener() {
        return this.disposeListener;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public Map<Control, String> getRegisteredControls() {
        return this.registeredControls;
    }

    public Map<String, Properties> getResourceMap() {
        return this.resources;
    }

    public Set<String> getTranslationMap() {
        return this.setTranslations;
    }

    public Set<String> getPrintMap() {
        if (this.setTranslationsPrint == null) {
            this.fillPrintTranslationMap();
        }
        return this.setTranslationsPrint;
    }

    public void translate(String key) {
        if (key != null) {
            TranslationDialog dialog = new TranslationDialog(TaxmeController.getInstance().getShell(), key);
            dialog.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        for (String locale : this.resources.keySet()) {
            Properties p = this.resources.get(locale);
            FileOutputStream fos = null;
            FilterOutputStream bos = null;
            try {
                fos = new FileOutputStream(TaxmeConfig.getResourceBundlePath(locale));
                bos = new BufferedOutputStream(fos);
                p.store(bos, null);
                Messages.reload();
                TaxmeController.getInstance().update();
            }
            catch (Exception e) {
                LOG.warn("error in TranslationManager", (Throwable)e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bos == null) continue;
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void registerControl(Control control, String key) {
        if (!this.getRegisteredControls().containsKey(control)) {
            control.addMouseListener(this.getMouseListener());
            control.addDisposeListener(this.getDisposeListener());
            this.getRegisteredControls().put(control, key);
        }
    }

    private void fillPrintTranslationMap() {
        this.setTranslationsPrint = new HashSet<String>();
        if (!TaxmeConfig.isExpertModeEnabled()) {
            return;
        }
        List navDTOs = TaxmeController.getInstance().getTmoCdSession().getExpertNavigationItems();
        for (ExpertDisplayInfoDTO.NavigationDTO navigationDTO : navDTOs) {
            if (navigationDTO.isExtraForm()) continue;
            if (navigationDTO.getSubItems() != null) {
                List list = navigationDTO.getSubItems();
                for (ExpertDisplayInfoDTO.NavigationDTO childNavigationDTO : list) {
                    ExpertDisplayInfoDTO childDisplayDTO = TaxmeController.getInstance().getExpertDisplayInfoDTO(childNavigationDTO.getAccessKey(), 1);
                    this.fillPrintTranslationMap(childDisplayDTO);
                }
                continue;
            }
            ExpertDisplayInfoDTO displayDTO = TaxmeController.getInstance().getExpertDisplayInfoDTO(navigationDTO.getAccessKey(), 1);
            this.fillPrintTranslationMap(displayDTO);
        }
    }

    private void fillPrintTranslationMap(ExpertDisplayInfoDTO displayDTO) {
        if (displayDTO.getName() != null) {
            this.setTranslationsPrint.add(displayDTO.getName());
        }
        List items = displayDTO.getItems();
        for (Object element : items) {
            ExpertDisplayInfoDTO.ItemDTO itemDTO = (ExpertDisplayInfoDTO.ItemDTO)element;
            if (itemDTO instanceof ExpertDisplayInfoDTO.LabelDTO) {
                if (((ExpertDisplayInfoDTO.LabelDTO)itemDTO).getKey() == null) continue;
                this.setTranslationsPrint.add(((ExpertDisplayInfoDTO.LabelDTO)itemDTO).getKey());
                continue;
            }
            if (!(itemDTO instanceof ExpertDisplayInfoDTO.TableDTO)) continue;
            ExpertDisplayInfoDTO.TableDTO tableDTO = (ExpertDisplayInfoDTO.TableDTO)itemDTO;
            if (tableDTO.getTitle() != null) {
                this.setTranslationsPrint.add(tableDTO.getTitle());
            }
            List columnDTOs = tableDTO.getAllColumns();
            for (ExpertDisplayInfoDTO.TableDTO.ColumnDTO columnDTO : columnDTOs) {
                if (columnDTO.getTitle() == null) continue;
                this.setTranslationsPrint.add(columnDTO.getTitle());
            }
        }
    }

    class TranslationMouseListener
    implements MouseListener {
        TranslationMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent arg0) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (mouseEvent.button == 3) {
                if (mouseEvent.getSource() instanceof Tree) {
                    Tree tree = (Tree)mouseEvent.getSource();
                    TreeItem item = tree.getItem(new Point(mouseEvent.x, mouseEvent.y));
                    if (item != null) {
                        WizardDisplayInfoDTO.NavigationsItemDTO navDTO = (WizardDisplayInfoDTO.NavigationsItemDTO)item.getData();
                        TranslationManager.this.translate(navDTO.getTitle());
                    }
                } else if (mouseEvent.getSource() instanceof org.eclipse.swt.widgets.List) {
                    org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)mouseEvent.getSource();
                    int y = mouseEvent.y / list.getItemHeight();
                    if (list.getItemCount() >= y && list.getData() instanceof ArrayList) {
                        ArrayList translations = (ArrayList)list.getData();
                        TranslationManager.this.translate((String)translations.get(y));
                    }
                } else if (mouseEvent.getSource() instanceof Table) {
                    Table table = (Table)mouseEvent.getSource();
                    TableItem item = table.getItem(new Point(mouseEvent.x, mouseEvent.y));
                    Object itemData = item.getData();
                    if (itemData != null && itemData instanceof MessageItemDTO) {
                        MessageItemDTO msgItem = (MessageItemDTO)itemData;
                        TranslationManager.this.translate(msgItem.getKey());
                    }
                } else {
                    Control control = (Control)mouseEvent.getSource();
                    String key = TranslationManager.this.registeredControls.get(control);
                    TranslationManager.this.translate(key);
                }
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }
    }

    class TranslationDisposeListener
    implements DisposeListener {
        TranslationDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent disposeEvent) {
            ((Control)disposeEvent.getSource()).removeMouseListener((MouseListener)TranslationManager.this.mouseListener);
        }
    }
}

