/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.resourcetools.index;

import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.resourcetools.IToolCommunicationGui;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class IndexModel
implements ILabelProvider,
IStructuredContentProvider {
    private final IToolCommunicationGui callback;
    private final ListViewer listViewer;
    private ArrayList<HelpItem> items = null;
    private static final int HITS_PER_PAGE = 10;

    public IndexModel(IToolCommunicationGui callBack, ListViewer listViewer) {
        this.callback = callBack;
        this.listViewer = listViewer;
        this.items = new ArrayList();
    }

    public void search(String searchTerm) throws Exception {
        String line;
        String sPath = this.callback.toolGetCurrentMainHelpDirectory() + this.callback.toolGetCurrentLanguage();
        this.items.clear();
        File aFile = new File(sPath + "\\index");
        if (!aFile.exists()) {
            IndexWriter writer = new IndexWriter(sPath + "\\index", (Analyzer)new StandardAnalyzer(), true);
            this.indexDocs(writer, new File(sPath));
        }
        this.listViewer.getList().deselectAll();
        boolean bool = true;
        IndexSearcher searcher = new IndexSearcher(sPath + "\\index");
        StandardAnalyzer analyzer = new StandardAnalyzer();
        block0: while (bool && (line = searchTerm).length() != -1) {
            Query query = QueryParser.parse((String)line, (String)"contents", (Analyzer)analyzer);
            Hits hits = searcher.search(query);
            if (hits.length() <= 0) {
                bool = false;
            }
            for (int start = 0; start < hits.length(); start += 10) {
                int end = Math.min(hits.length(), start + 10);
                for (int i = start; i < end; ++i) {
                    Document doc = hits.doc(i);
                    String path = doc.get("path");
                    if (path == null) continue;
                    HelpItem item = new HelpItem();
                    item.setName(new File(path).getName());
                    item.setTopic(item.getName());
                    this.items.add(item);
                }
                bool = false;
                if (hits.length() > end && ((line = searchTerm).isEmpty() || line.charAt(0) == 'n')) continue block0;
            }
        }
    }

    public void indexDocs(IndexWriter writer, File file) throws Exception {
        if (file.isDirectory()) {
            String[] files;
            for (String file2 : files = file.list()) {
                this.indexDocs(writer, new File(file, file2));
            }
        } else {
            writer.addDocument(this.getDocument(file));
        }
    }

    private Document getDocument(File f) throws FileNotFoundException {
        Document doc = new Document();
        doc.add(Field.Text((String)"path", (String)f.getPath()));
        doc.add(Field.Keyword((String)"modified", (String)DateField.timeToString((long)f.lastModified())));
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        doc.add(Field.Text((String)"contents", (Reader)reader));
        return doc;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        List list = (List)inputElement;
        for (int i = 0; i < list.size(); ++i) {
            HelpItem currentItem = (HelpItem)list.get(i);
            String topic = currentItem.getTopic();
            if (topic.endsWith(".html") || topic.endsWith(".htm")) continue;
            list.remove(i);
        }
        return list.toArray();
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        return ((HelpItem)element).getName();
    }
}

