/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.tax.common.presentation.cd.util.BrowserNotSupportedException;
import ch.dvbern.tax.common.presentation.cd.util.LaunchUtil;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BrowserUtil {
    private static final Map<String, Action> ACTIONS = new HashMap<String, Action>();
    private static final Logger LOG = LoggerFactory.getLogger(BrowserUtil.class);

    private BrowserUtil() {
    }

    public static void registerBrowserAction(String path, Action action) {
        ACTIONS.put(path, action);
    }

    public static Browser createBrowser(Composite parent) {
        return BrowserUtil.createBrowser(parent, 0, true);
    }

    public static Browser createBrowser(Composite parent, int style) {
        return BrowserUtil.createBrowser(parent, style, true);
    }

    public static Browser createBrowser(Composite parent, boolean allHttpAsExternal) {
        return BrowserUtil.createBrowser(parent, 0, allHttpAsExternal);
    }

    public static Browser createBrowser(Composite parent, int style, boolean allHttpAsExternal) {
        try {
            final Browser browser = new Browser(parent, style);
            browser.addLocationListener((LocationListener)new LocationChangeListener(allHttpAsExternal));
            if (!OsSupport.isWindowsOs()) {
                browser.addOpenWindowListener((OpenWindowListener)new ExternalAppOnOpenWindow());
            }
            browser.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent ev) {
                    if (OsSupport.isMacOs()) {
                        try {
                            browser.setSize(0, 0);
                            browser.setVisible(false);
                        }
                        catch (Exception e) {
                            LOG.warn("Error while trying to hide the welcome page.", (Throwable)e);
                        }
                    }
                }
            });
            return browser;
        }
        catch (SWTError e) {
            throw new BrowserNotSupportedException("browser initialization failed", e);
        }
    }

    @Deprecated
    public static boolean openInWebbrowser(String url) {
        return LaunchUtil.launchBrowser(url);
    }

    public static boolean launchURI(String uri) {
        if (BrowserUtil.runRegisteredAction(uri)) {
            return true;
        }
        return LaunchUtil.launchBrowser(uri);
    }

    private static boolean runRegisteredAction(String location) {
        Action action = null;
        action = ACTIONS.get(location);
        if (action == null) {
            try {
                URI uri = new URI(location);
                if (uri.isOpaque()) {
                    String path = uri.getSchemeSpecificPart();
                    action = ACTIONS.get(path);
                } else {
                    String locationCleanup = location;
                    while (locationCleanup.endsWith("?")) {
                        locationCleanup = locationCleanup.substring(0, locationCleanup.length() - 1);
                    }
                    action = ACTIONS.get(locationCleanup);
                    if (action == null) {
                        action = ACTIONS.get(uri.getPath());
                    }
                }
            }
            catch (URISyntaxException e) {
                LOG.error("Invalid action URI: " + location);
            }
        }
        if (action != null) {
            try {
                action.run();
            }
            catch (RuntimeException e) {
                LOG.error("Exception encoutered while running the action bound to: " + location, (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private static class LocationChangeListener
    implements LocationListener {
        private final boolean allHttpAsExternal;

        public LocationChangeListener(boolean allHttpAsExternal) {
            this.allHttpAsExternal = allHttpAsExternal;
        }

        public void changing(LocationEvent ev) {
            String loc = ev.location;
            if (BrowserUtil.runRegisteredAction(loc)) {
                ev.doit = false;
            } else if (this.allHttpAsExternal && (loc.startsWith("https://") || loc.startsWith("http://"))) {
                LaunchUtil.launchBrowser(loc);
                ev.doit = false;
            }
        }

        public void changed(LocationEvent ev) {
        }
    }

    private static class ExternalAppOnOpenWindow
    implements OpenWindowListener {
        public void open(WindowEvent event) {
            Shell shell = new Shell(event.widget.getDisplay());
            Browser browser = new Browser((Composite)shell, 0);
            browser.addLocationListener(new LocationListener(this){

                public void changing(LocationEvent event) {
                    LaunchUtil.launch(event.location);
                    event.doit = false;
                }

                public void changed(LocationEvent event) {
                }
            });
            event.browser = browser;
        }
    }
}

