/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.dialog.AuthenticationDialog;
import ch.dvbern.tax.common.presentation.cd.util.ProxyConfig;
import com.btr.proxy.search.ProxySearch;
import com.btr.proxy.selector.fixed.FixedProxySelector;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionUtil.class);
    private static final String CONFIG_PROXY_PORT = "update.proxy.port";
    private static final String CONFIG_PROXY_HOST = "update.proxy.host";
    private static final String CONFIG_PROXY_AVAILABLE = "update.proxy.available";
    private static final String CONFIG_PROXY_PASSWORD = "update.proxy.password";
    private static final String CONFIG_PROXY_SYSTEM = "update.proxy.useSystemProxy";
    private static final String CONFIG_PROXY_USER = "update.proxy.user";
    private static final String CRYPTO_ENCODING = "ISO-8859-1";
    private static final String CRYPTO_ALGORITHM = "DESede";
    private static final byte[] KEY = new byte[]{-36, -22, -116, 59, 49, -99, -29, -108, -9, -82, 103, 124, 1, -56, 124, 79, 73, 91, 121, 118, -83, -104, -89, -63};
    private static SecretKey secret;

    private ConnectionUtil() {
    }

    public static void configure() {
        ProxyConfig config = ConnectionUtil.getProxyConfig();
        LOG.info("Applying proxy configuration from saved settings: {}", (Object)config);
        ConnectionUtil.configureProxy(config);
        ConnectionUtil.configureAuthenticator();
    }

    private static void configureProxy(ProxyConfig config) {
        ProxySelector selector;
        if (config != null && config.isProxyEnabled()) {
            if (config.isSystemSettingsEnabled()) {
                ProxySearch ps = new ProxySearch();
                ps.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
                selector = ps.getProxySelector();
            } else {
                selector = new FixedProxySelector(config.getHost() == null ? "" : config.getHost(), config.getPort());
            }
        } else {
            selector = null;
        }
        ProxySelector.setDefault(selector);
    }

    public static ProxyConfig getProxyConfig() {
        ProxyConfig conf = new ProxyConfig(TaxmeConfig.getBoolean(CONFIG_PROXY_AVAILABLE), TaxmeConfig.getBoolean(CONFIG_PROXY_SYSTEM), TaxmeConfig.getString(CONFIG_PROXY_HOST), TaxmeConfig.getInt(CONFIG_PROXY_PORT));
        return conf;
    }

    public static void setProxyConfig(ProxyConfig conf) {
        LOG.info("Persisting and applying new proxy settings: {}", (Object)conf);
        TaxmeConfig.setValue(CONFIG_PROXY_AVAILABLE, Boolean.toString(conf.isProxyEnabled()));
        TaxmeConfig.setValue(CONFIG_PROXY_SYSTEM, Boolean.toString(conf.isSystemSettingsEnabled()));
        TaxmeConfig.setValue(CONFIG_PROXY_HOST, conf.getHost());
        TaxmeConfig.setValue(CONFIG_PROXY_PORT, Integer.toString(conf.getPort()));
        ConnectionUtil.configureProxy(conf);
    }

    private static void configureAuthenticator() {
        Authenticator.setDefault(new SWTDialogAuthenticator());
    }

    private static void saveAuthentication(PasswordAuthentication auth) {
        assert (auth != null);
        TaxmeConfig.setValue(CONFIG_PROXY_USER, ConnectionUtil.encrypt(auth.getUserName()));
        TaxmeConfig.setValue(CONFIG_PROXY_PASSWORD, ConnectionUtil.encrypt(new String(auth.getPassword())));
    }

    private static PasswordAuthentication loadAuthentication() {
        String user = ConnectionUtil.decrypt(TaxmeConfig.getString(CONFIG_PROXY_USER));
        String pw = ConnectionUtil.decrypt(TaxmeConfig.getString(CONFIG_PROXY_PASSWORD));
        if (user != null) {
            return new PasswordAuthentication(user, pw == null ? new char[]{} : pw.toCharArray());
        }
        return null;
    }

    private static String encrypt(String pw) {
        if (pw == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(CRYPTO_ALGORITHM);
            cipher.init(1, secret);
            byte[] enc = cipher.doFinal(pw.getBytes(CRYPTO_ENCODING));
            return Base64.encodeBase64String((byte[])enc);
        }
        catch (InvalidKeyException e) {
            LOG.error("Could not encrypt string: ", (Throwable)e);
            return "";
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Could not encrypt string: ", (Throwable)e);
            return "";
        }
        catch (NoSuchPaddingException e) {
            LOG.error("Could not encrypt string: ", (Throwable)e);
            return "";
        }
        catch (IllegalBlockSizeException e) {
            LOG.error("Could not encrypt string: ", (Throwable)e);
            return "";
        }
        catch (BadPaddingException e) {
            LOG.error("Could not encrypt string: ", (Throwable)e);
            return "";
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Could not encrypt string: ", (Throwable)e);
            return "";
        }
    }

    private static String decrypt(String pw) {
        if (pw == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(CRYPTO_ALGORITHM);
            cipher.init(2, secret);
            byte[] data = Base64.decodeBase64((String)pw);
            return new String(cipher.doFinal(data), CRYPTO_ENCODING);
        }
        catch (Exception e) {
            LOG.error("Could not decrypt string: ", (Throwable)e);
            return "";
        }
    }

    static {
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(CRYPTO_ALGORITHM);
            secret = skf.generateSecret(new DESedeKeySpec(KEY));
        }
        catch (InvalidKeyException e) {
            LOG.error("Could not generate secret key (DES): ", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Could not generate secret key (DES): ", (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            LOG.error("Could not generate secret key (DES): ", (Throwable)e);
        }
    }

    private static class SWTDialogAuthenticator
    extends Authenticator {
        private volatile PasswordAuthentication authResult = ConnectionUtil.loadAuthentication();
        private volatile boolean authSaved = this.authResult != null;
        private volatile boolean firstRun = true;

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.firstRun && this.authResult != null) {
                this.firstRun = false;
                return this.authResult;
            }
            this.firstRun = false;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    AuthenticationDialog dlg = new AuthenticationDialog(TaxmeController.getInstance().getShell());
                    if (authResult != null) {
                        dlg.setAuthentication(authResult);
                    }
                    dlg.setSaveSelected(authSaved);
                    if (dlg.open() == 0) {
                        authResult = dlg.getAuthentication();
                        if (dlg.isSaveSelected()) {
                            ConnectionUtil.saveAuthentication(authResult);
                            authSaved = true;
                        } else {
                            authSaved = false;
                        }
                    } else {
                        authResult = null;
                    }
                }
            });
            return this.authResult;
        }
    }
}

