/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.dialog.CustomMessageDialog;
import ch.dvbern.tax.common.presentation.cd.util.TaxFileConfig;
import ch.dvbern.tax.common.presentation.common.util.UserMessageHolder;
import java.util.ArrayList;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public final class DialogUtil {
    private static final String[] YES_NO_CANCEL_BUTTONS = new String[]{"label.button.ja", "label.button.nein", "label.button.cancel"};
    private static final String[] YES_NO_BUTTONS = new String[]{"label.button.ja", "label.button.nein"};
    private static final String[] CONFIRMATION_BUTTONS = new String[]{"label.button.ok", "label.button.cancel"};
    private static final String[] OK_BUTTON = new String[]{"label.button.ok"};
    public static final String CENTER_POPUPS_PROPERTY = "centerPopups";
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    public static final String TITLE_ERROR_KEY = "title.error";
    public static final String TITLE_WARNING_KEY = "title.warning";
    public static final String TITLE_QUESTION_KEY = "title.question";
    public static final String TITLE_INFO_KEY = "title.info";
    public static final String TITLE_CONFIRM_KEY = "title.confirm";
    public static final int WINDOW_MSG_HEIGHT = 180;
    public static final int WINDOW_MSG_WIDTH = 600;
    public static final int WINDOW_FILE_WIDTH = 650;
    public static final int WINDOW_FILEOPEN_HEIGHT = 300;

    private DialogUtil() {
    }

    public static void showErrorDialog(@NonNull String messageKey, Object ... args) {
        DialogUtil.showErrorDialog(null, messageKey, args);
    }

    public static void showErrorDialog(@Nullable Shell shell, @NonNull String messageKey, Object ... args) {
        if (TaxmeConfig.getBoolean(CENTER_POPUPS_PROPERTY)) {
            Rectangle bounds = new Rectangle(0, 0, 600, 180);
            DialogUtil.showMessageDialog(shell, 1, TITLE_ERROR_KEY, null, OK_BUTTON, 0, messageKey, args, bounds);
        } else {
            DialogUtil.showMessageDialog(shell, 1, TITLE_ERROR_KEY, null, OK_BUTTON, 0, messageKey, args);
        }
    }

    public static void showErrorDialog(@Nullable Throwable exception, @NonNull String defaultMessageKey) {
        DialogUtil.showErrorDialog(null, exception, defaultMessageKey);
    }

    public static void showErrorDialog(@Nullable Shell shell, @Nullable Throwable exception, @NonNull String defaultMessageKey) {
        Objects.requireNonNull(defaultMessageKey, "Default message key cannot be null.");
        String titleKey = null;
        Object[] titleArgs = null;
        String messageKey = null;
        Object[] messageArgs = null;
        if (exception instanceof UserMessageHolder) {
            UserMessageHolder msgHolder = (UserMessageHolder)exception;
            messageKey = msgHolder.getMessageKey();
            if (messageKey != null) {
                messageArgs = msgHolder.getMessageArgs();
            }
            if ((titleKey = msgHolder.getShortMessageKey()) != null) {
                titleArgs = msgHolder.getShortMessageArgs();
            }
        }
        if (messageKey == null) {
            messageKey = defaultMessageKey;
        }
        DialogUtil.showErrorDialog(shell, titleKey, titleArgs, messageKey, messageArgs);
    }

    public static void showWarningDialog(@NonNull String messageKey, Object ... args) {
        if (TaxmeConfig.getBoolean(CENTER_POPUPS_PROPERTY)) {
            Rectangle bounds = new Rectangle(0, 0, 600, 180);
            DialogUtil.showMessageDialog(null, 1, TITLE_ERROR_KEY, null, OK_BUTTON, 0, messageKey, args, bounds);
        } else {
            DialogUtil.showMessageDialog(null, 4, TITLE_WARNING_KEY, null, OK_BUTTON, 0, messageKey, args);
        }
    }

    public static void showWarningDialog(@Nullable Shell shell, @NonNull String messageKey, Object ... args) {
        DialogUtil.showMessageDialog(shell, 4, TITLE_WARNING_KEY, null, OK_BUTTON, 0, messageKey, args);
    }

    public static boolean showYesNoDialog(@NonNull String messageKey, Object ... args) {
        return DialogUtil.showYesNoDialog(null, messageKey, args);
    }

    public static boolean showYesNoDialog(@Nullable Shell shell, @NonNull String messageKey, Object ... args) {
        int rc = DialogUtil.showMessageDialog(shell, 3, TITLE_QUESTION_KEY, null, YES_NO_BUTTONS, 1, messageKey, args);
        return rc == 0;
    }

    public static int showYesNoCancelDialog(@NonNull String messageKey, Object ... args) {
        return DialogUtil.showYesNoCancelDialog(null, messageKey, args);
    }

    public static int showYesNoCancelDialog(@Nullable Shell shell, @NonNull String messageKey, Object ... args) {
        return DialogUtil.showMessageDialog(shell, 3, TITLE_QUESTION_KEY, null, YES_NO_CANCEL_BUTTONS, 2, messageKey, args);
    }

    public static void showInfoDialog(@NonNull String messageKey, Object ... args) {
        DialogUtil.showInfoDialog(null, messageKey, args);
    }

    public static void showInfoDialog(@Nullable Shell shell, @NonNull String messageKey, Object ... args) {
        DialogUtil.showMessageDialog(shell, 2, TITLE_INFO_KEY, null, OK_BUTTON, 0, messageKey, args);
    }

    public static boolean showConfirmDialog(@NonNull String messageKey, Object ... args) {
        return DialogUtil.showConfirmDialog(null, messageKey, args);
    }

    public static void centerInCurrentMonitor(@NonNull Shell shell) {
        Rectangle bounds = DialogUtil.getMonitorBounds(shell);
        Rectangle rect = shell.getBounds();
        if (bounds == null || rect == null) {
            return;
        }
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
    }

    private static Rectangle getMonitorBounds(@NonNull Shell shell) {
        int i;
        Monitor[] monitors = Display.getCurrent().getMonitors();
        Monitor myMonitor = Display.getDefault().getPrimaryMonitor();
        Composite parent = shell.getParent();
        Rectangle parentBounds = parent != null ? parent.getBounds() : TaxmeController.getInstance().getShell().getBounds();
        ArrayList<Rectangle> intersectedMonitors = new ArrayList<Rectangle>();
        for (i = 0; i < monitors.length; ++i) {
            Rectangle monitorBounds = monitors[i].getBounds();
            if (!monitorBounds.intersects(parentBounds)) continue;
            intersectedMonitors.add(monitorBounds.intersection(parentBounds));
            myMonitor = monitors[i];
        }
        for (i = 0; i < intersectedMonitors.size() - 1; ++i) {
            Rectangle currentMonitor = (Rectangle)intersectedMonitors.get(i);
            Rectangle nextMonitor = (Rectangle)intersectedMonitors.get(i + 1);
            myMonitor = currentMonitor.width > nextMonitor.width ? monitors[i] : monitors[i + 1];
        }
        return myMonitor.getBounds();
    }

    public static boolean showConfirmDialog(@Nullable Shell shell, @NonNull String messageKey, Object ... args) {
        int rc = DialogUtil.showMessageDialog(shell, 3, TITLE_CONFIRM_KEY, null, CONFIRMATION_BUTTONS, 1, messageKey, args);
        return rc == 0;
    }

    private static int showErrorDialog(Shell shell, String titleKey, Object[] titleArgs, String messageKey, Object[] msgArgs) {
        int selectedButton;
        assert (messageKey != null);
        if (TaxmeConfig.getBoolean(CENTER_POPUPS_PROPERTY)) {
            Rectangle bounds = new Rectangle(0, 0, 600, 180);
            selectedButton = DialogUtil.showMessageDialog(shell, 1, TITLE_ERROR_KEY, null, OK_BUTTON, 0, messageKey, msgArgs, bounds);
        } else {
            selectedButton = DialogUtil.showMessageDialog(shell, 1, titleKey != null ? titleKey : TITLE_ERROR_KEY, titleArgs, OK_BUTTON, 0, messageKey, msgArgs);
        }
        return selectedButton;
    }

    private static int showMessageDialog(Shell shell, int image, String titleKey, Object[] titleArgs, String[] buttonKeys, int defButton, String messageKey, Object[] msgArgs) {
        CustomMessageDialog dlg;
        assert (titleKey != null && buttonKeys != null && messageKey != null);
        String[] buttons = new String[buttonKeys.length];
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i] = Messages.translate(buttonKeys[i], new Object[0]);
        }
        if (shell == null) {
            shell = Display.getCurrent().getActiveShell();
        }
        if (TaxmeConfig.getBoolean(CENTER_POPUPS_PROPERTY)) {
            Rectangle bounds = new Rectangle(0, 0, 600, 180);
            dlg = new CustomMessageDialog(shell, image, titleKey, titleArgs, defButton, messageKey, msgArgs, buttons, bounds);
        } else {
            dlg = new CustomMessageDialog(shell, image, titleKey, titleArgs, defButton, messageKey, msgArgs, buttons);
        }
        return dlg.open();
    }

    private static int showMessageDialog(Shell shell, int image, String titleKey, Object[] titleArgs, String[] buttonKeys, int defButton, String messageKey, Object[] msgArgs, Rectangle bounds) {
        assert (titleKey != null && buttonKeys != null && messageKey != null);
        String[] buttons = new String[buttonKeys.length];
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i] = Messages.translate(buttonKeys[i], new Object[0]);
        }
        if (shell == null) {
            shell = Display.getCurrent().getActiveShell();
        }
        CustomMessageDialog dlg = new CustomMessageDialog(shell, image, titleKey, titleArgs, defButton, messageKey, msgArgs, buttons, bounds);
        return dlg.open();
    }

    public static String showOpenfileDialog(String lastSaveDir) {
        Shell shell = TaxmeConfig.getBoolean(CENTER_POPUPS_PROPERTY) ? new Shell(Display.getCurrent(), 65536) : Display.getCurrent().getActiveShell();
        FileDialog dlg = null;
        dlg = TaxmeConfig.getBoolean(CENTER_POPUPS_PROPERTY) ? DialogUtil.createCenteredFileDialog(shell, 4096) : new FileDialog(shell, 4096);
        dlg.setText(Messages.translate("menu.file", new Object[0]));
        if (TaxmeConfig.getString(lastSaveDir) == null || "".equals(TaxmeConfig.getString(lastSaveDir))) {
            dlg.setFilterPath(TaxmeConfig.getSaveDir().getAbsolutePath());
        } else {
            dlg.setFilterPath(TaxmeConfig.getString(lastSaveDir));
        }
        dlg.setFilterExtensions(new String[]{"*" + TaxFileConfig.getInstance().getFileNameExtension()});
        String result = dlg.open();
        if (TaxmeConfig.getBoolean(CENTER_POPUPS_PROPERTY)) {
            shell.dispose();
        }
        return result;
    }

    public static FileDialog createCenteredFileDialog(Shell shell, int type) {
        Rectangle monitorBounds = DialogUtil.getMonitorBounds(TaxmeController.getInstance().getShell());
        int width = 650;
        int height = 300;
        shell.setLayout((Layout)new GridLayout(1, false));
        shell.setSize(width, height);
        shell.setLocation(monitorBounds.x + (monitorBounds.width - width) / 2, monitorBounds.y + (monitorBounds.height - height) / 2);
        shell.setVisible(false);
        shell.open();
        FileDialog fd = new FileDialog(shell, type);
        return fd;
    }
}

