/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ImmediatelyCancelable<T>
implements IRunnableWithProgress {
    private final Callable<T> task;
    private T result;

    public ImmediatelyCancelable(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException("Task to execute cannot be null.");
        }
        this.task = task;
    }

    public @Nullable T getResult() {
        return this.result;
    }

    public final void run(IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
        this.start(mon);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<T> futur = exec.submit(this.task);
        while (!futur.isDone()) {
            try {
                this.result = futur.get(1L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                throw new InvocationTargetException(e.getCause());
            }
            catch (TimeoutException e) {
                if (!mon.isCanceled()) continue;
                futur.cancel(true);
                throw new InterruptedException();
            }
        }
        mon.done();
    }

    protected void start(IProgressMonitor monitor) {
    }
}

