/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.resourcetools.TranslationManager;
import ch.dvbern.tax.common.transfer.dto.ResourceBundleManager;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.eclipse.swt.widgets.Control;

@ApplicationScoped
public class ResourceBundleCDManager
extends ResourceBundleManager {
    private static final Map<String, ResourceBundle> BUNDLES = new HashMap<String, ResourceBundle>();
    private static final boolean TOOLS_ENABLED = TaxmeConfig.getBoolean("ToolsEnabled");

    protected @NonNull String getString(@NonNull String key, @NonNull Locale locale) {
        String str = super.getString(key, locale);
        if (str.contains("&nbsp;")) {
            str = str.replaceAll("&nbsp;", " ");
        }
        return str;
    }

    public String configurableTranslate(@NonNull String key, @NonNull Locale locale, Object ... replacementArguments) {
        if (key == null) {
            throw new NullPointerException("Message key cannot be null.");
        }
        if (locale == null) {
            throw new NullPointerException("Locale cannot be null.");
        }
        if (TOOLS_ENABLED) {
            TranslationManager.getInstance().getTranslationMap().add(key);
        }
        return this.translate(key, locale, replacementArguments);
    }

    public String configurableTranslate(@NonNull String key, @NonNull Locale locale, @NonNull Control control, Object ... replacementArguments) {
        if (key == null) {
            throw new NullPointerException("Message key cannot be null.");
        }
        if (locale == null) {
            throw new NullPointerException("Locale cannot be null.");
        }
        if (control == null) {
            throw new NullPointerException("Control cannot be null.");
        }
        if (TOOLS_ENABLED) {
            TranslationManager.getInstance().registerControl(control, key);
        }
        return this.translate(key, locale, replacementArguments);
    }

    public void setString(@NonNull String key, @NonNull Locale locale, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("Resource key cannot be null.");
        }
        if (locale == null) {
            throw new NullPointerException("Locale key cannot be null.");
        }
        if (value == null) {
            throw new NullPointerException("Text value cannot be null.");
        }
        String lang = locale.getLanguage();
        String path = TaxmeConfig.getResourceBundlePath(lang);
        Properties p = new Properties();
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(path));
            p.load(in);
            p.setProperty(key, value);
            out = new BufferedOutputStream(new FileOutputStream(path));
            p.store(out, null);
            this.reload();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("can't load resource bundle: " + path);
            }
            catch (Throwable throwable) {
                ch.dvbern.lib.update.IOUtils.closeQuietly(in);
                ch.dvbern.lib.update.IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        ch.dvbern.lib.update.IOUtils.closeQuietly((Closeable)in);
        ch.dvbern.lib.update.IOUtils.closeQuietly((Closeable)out);
    }

    public void removeString(String key, Locale locale) {
        String lang = locale.getLanguage();
        String path = TaxmeConfig.getResourceBundlePath(lang);
        Properties p = new Properties();
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(path));
            p.load(in);
            p.remove(key);
            out = new BufferedOutputStream(new FileOutputStream(path));
            p.store(out, null);
            this.reload();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("can't load resource bundle: " + path);
            }
            catch (Throwable throwable) {
                ch.dvbern.lib.update.IOUtils.closeQuietly(in);
                ch.dvbern.lib.update.IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        ch.dvbern.lib.update.IOUtils.closeQuietly((Closeable)in);
        ch.dvbern.lib.update.IOUtils.closeQuietly((Closeable)out);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected @NonNull ResourceBundle getResourceBundle(@NonNull Locale locale) {
        String path = null;
        Map<String, ResourceBundle> map = BUNDLES;
        synchronized (map) {
            BufferedInputStream is = null;
            try {
                ResourceBundle bundle;
                String additionalPath;
                String lang = locale.getLanguage();
                Object key = lang;
                if (TaxmeController.getInstance().getTmoCdSession() != null && (additionalPath = TaxmeController.getInstance().getTmoCdSession().getImageVariant()) != null && !additionalPath.isEmpty()) {
                    key = additionalPath + "_" + locale.getLanguage();
                }
                if ((bundle = BUNDLES.get(key)) == null) {
                    path = TaxmeConfig.getResourceBundlePath((String)key);
                    is = new BufferedInputStream(new FileInputStream(path));
                    bundle = new PropertyResourceBundle(is);
                    BUNDLES.put((String)key, bundle);
                }
                ResourceBundle resourceBundle = bundle;
                return resourceBundle;
            }
            catch (IOException e) {
                throw new RuntimeException("can't load resource bundle: " + path);
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Map<String, ResourceBundle> map = BUNDLES;
        synchronized (map) {
            BUNDLES.clear();
        }
    }
}

