/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.lib.update.VersionUtil;
import ch.dvbern.lib.update.exception.ConfigurationException;
import ch.dvbern.lib.update.xjc.VersionConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemIdentifier {
    private static final Logger LOG = LoggerFactory.getLogger(SystemIdentifier.class);
    private static Version UNDEFINED_VERSION = new Version(){

        @Override
        public int getValue() {
            return 0;
        }

        @Override
        public String getName() {
            return "Undefined";
        }
    };
    private static final int JVM_BUNDLED = 2048;
    private static final Pattern LSB_DISTRIBUTOR_PTN = Pattern.compile("Distributor ID:\\s+(.*)");

    private static String escapeString(String value) {
        return "'" + value.replace("'", "\\'") + "'";
    }

    public static int getOSIdentifier() {
        int id = 0;
        OperatingSystem os = OperatingSystem.getCurrentOperatingSystem();
        id |= os.value;
        return id |= os.getCurrentVersion().getValue();
    }

    public static int getJVMIdentifier() {
        int id = 0;
        id |= JVMVendor.getCurrentJVMVendor().value;
        try {
            VersionConfig config = VersionUtil.loadVersionConfig();
            String bundledJREPath = config.getBundledJRE();
            if (bundledJREPath != null) {
                File bundledJRE = new File(bundledJREPath);
                File javaHome = new File(System.getProperty("java.home"));
                File javaInstallDir = javaHome.getParentFile();
                if (bundledJRE.getAbsoluteFile().equals(javaInstallDir)) {
                    id |= 0x800;
                }
            }
        }
        catch (ConfigurationException e) {
            LOG.debug("Failed to query application version configuration.", (Throwable)e);
        }
        id |= Arch.getCurrentArch().value;
        return id |= JVMSpec.getCurrentVersion().value;
    }

    public static void dumpOSCSVList(@NonNull Writer writer) throws IOException {
        if (writer == null) {
            throw new NullPointerException("Writer cannot be null.");
        }
        HashSet<Integer> identifiers = new HashSet<Integer>();
        for (OperatingSystem os : OperatingSystem.values()) {
            for (Version version : os.getVersions()) {
                writer.write(SystemIdentifier.escapeString(version.getName()));
                writer.write(",");
                int identifier = os.value | version.getValue();
                if (!identifiers.add(identifier)) {
                    throw new AssertionError((Object)("Duplicate identifier found: " + identifier + ". Check flag values."));
                }
                writer.write(String.valueOf(identifier));
                writer.write("\n");
            }
        }
    }

    public static void dumpJVMCSVList(@NonNull Writer writer) throws IOException {
        if (writer == null) {
            throw new NullPointerException("Writer cannot be null.");
        }
        HashSet<Integer> identifiers = new HashSet<Integer>();
        for (JVMVendor vendor : JVMVendor.values()) {
            StringBuilder sb = new StringBuilder();
            sb.append(SystemIdentifier.escapeString(vendor.name));
            sb.append(",");
            int sbVendorMark = sb.length();
            for (int bundled : new int[]{0, 2048}) {
                sb.setLength(sbVendorMark);
                sb.append(bundled == 2048 ? "bundled" : "");
                sb.append(",");
                int bundledId = vendor.value | bundled;
                int sbBundledMark = sb.length();
                for (Arch arch : Arch.values()) {
                    sb.setLength(sbBundledMark);
                    int archId = bundledId | arch.value;
                    sb.append((Object)arch);
                    sb.append(",");
                    int sbArchMark = sb.length();
                    for (JVMSpec spec : JVMSpec.values()) {
                        sb.setLength(sbArchMark);
                        sb.append(spec.majorVersion);
                        sb.append(",");
                        int identifier = archId | spec.value;
                        if (!identifiers.add(identifier)) {
                            throw new AssertionError((Object)("Duplicate identifier found: " + identifier + ". Check flag values."));
                        }
                        sb.append(String.valueOf(identifier));
                        sb.append("\n");
                        writer.write(sb.toString());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Version getCurrentLinuxVersion() {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command("lsb_release", "-a");
        pb.redirectErrorStream(true);
        BufferedReader bis = null;
        try {
            String line;
            Process p = pb.start();
            String distributor = null;
            bis = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = bis.readLine()) != null) {
                Matcher m = LSB_DISTRIBUTOR_PTN.matcher(line);
                if (!m.matches()) continue;
                distributor = m.group(1);
            }
            if (distributor == null) {
                LinuxVersion[] linuxVersionArray = LinuxVersion.UNDEFINED;
                IOUtils.closeQuietly((Reader)bis);
                return linuxVersionArray;
            }
            for (LinuxVersion linuxVersion : LinuxVersion.values()) {
                if (linuxVersion == LinuxVersion.UNDEFINED || !distributor.toLowerCase().contains(linuxVersion.identifier.toLowerCase())) continue;
                LinuxVersion linuxVersion2 = linuxVersion;
                IOUtils.closeQuietly((Reader)bis);
                return linuxVersion2;
            }
            IOUtils.closeQuietly((Reader)bis);
            return LinuxVersion.UNDEFINED;
        }
        catch (IOException e) {
            LOG.debug("Failed to query lsb_release for distribution info.", (Throwable)e);
            return LinuxVersion.UNDEFINED;
        }
        finally {
            IOUtils.closeQuietly(bis);
        }
    }

    private static enum OperatingSystem {
        UNDEFINED(0){

            @Override
            @NonNull Version getCurrentVersion() {
                return UNDEFINED_VERSION;
            }

            @Override
            @NonNull Version[] getVersions() {
                return new Version[]{UNDEFINED_VERSION};
            }
        }
        ,
        WINDOWS(256){

            @Override
            @NonNull Version getCurrentVersion() {
                String version = System.getProperty("os.version");
                for (WindowsVersion windowsVersion : WindowsVersion.values()) {
                    if (windowsVersion == WindowsVersion.UNDEFINED || !windowsVersion.versionNumber.equals(version)) continue;
                    return windowsVersion;
                }
                return WindowsVersion.UNDEFINED;
            }

            @Override
            @NonNull Version[] getVersions() {
                return WindowsVersion.values();
            }
        }
        ,
        MAC(512){

            @Override
            @NonNull Version getCurrentVersion() {
                String version = System.getProperty("os.version");
                for (MacVersion macVersion : MacVersion.values()) {
                    Pattern ptn;
                    if (macVersion == MacVersion.UNDEFINED || !(ptn = Pattern.compile(Pattern.quote(macVersion.majorVersion) + "(\\..)*")).matcher(version).matches()) continue;
                    return macVersion;
                }
                return MacVersion.UNDEFINED;
            }

            @Override
            @NonNull Version[] getVersions() {
                return MacVersion.values();
            }
        }
        ,
        LINUX(768){

            @Override
            @NonNull Version getCurrentVersion() {
                return SystemIdentifier.getCurrentLinuxVersion();
            }

            @Override
            @NonNull Version[] getVersions() {
                return LinuxVersion.values();
            }
        };

        final int value;

        private OperatingSystem(int value) {
            this.value = value;
        }

        abstract @NonNull Version getCurrentVersion();

        abstract @NonNull Version[] getVersions();

        static @NonNull OperatingSystem getCurrentOperatingSystem() {
            String name = System.getProperty("os.name").toLowerCase();
            if (name.startsWith("windows")) {
                return WINDOWS;
            }
            if (name.startsWith("mac os")) {
                return MAC;
            }
            if (name.startsWith("linux")) {
                return LINUX;
            }
            return UNDEFINED;
        }
    }

    private static interface Version {
        public int getValue();

        public String getName();
    }

    private static enum JVMVendor {
        UNDEFINED(0, "Undefined vendor"),
        JVM_HOTSPOT(4096, "Oracle HotSpot"),
        JVM_OPENJDK(8192, "OpenJDK"),
        JVM_JROCKIT(12288, "Oracle JRockit");

        final int value;
        final String name;

        private JVMVendor(int value, String name) {
            this.value = value;
            this.name = name;
        }

        static @NonNull JVMVendor getCurrentJVMVendor() {
            String vendor = System.getProperty("java.vm.name").toLowerCase();
            if (vendor.contains("hotspot")) {
                return JVM_HOTSPOT;
            }
            if (vendor.contains("openjdk")) {
                return JVM_OPENJDK;
            }
            if (vendor.contains("jrockit")) {
                return JVM_JROCKIT;
            }
            return UNDEFINED;
        }
    }

    private static enum Arch {
        UNDEFINED(0, null),
        X86(256, "(?:x86)|i[0-9]86"),
        X86_64(512, "x86_64|amd64"),
        PPC(768, "ppc");

        final int value;
        final Pattern ptn;

        private Arch(int value, String ptn) {
            this.value = value;
            this.ptn = ptn != null ? Pattern.compile(ptn) : null;
        }

        static @NonNull Arch getCurrentArch() {
            String osArch = System.getProperty("os.arch");
            for (Arch arch : Arch.values()) {
                if (arch == UNDEFINED || !arch.ptn.matcher(osArch).matches()) continue;
                return arch;
            }
            return UNDEFINED;
        }
    }

    private static enum JVMSpec {
        UNDEFINED(0, "UNDEFINED"),
        JVM_1_6(1, "1.6"),
        JVM_1_7(2, "1.7"),
        JVM_1_8(3, "1.8");

        final int value;
        final String majorVersion;

        private JVMSpec(int value, String majorVersion) {
            this.value = value;
            this.majorVersion = majorVersion;
        }

        static JVMSpec getCurrentVersion() {
            String jvmSpecVersion = System.getProperty("java.specification.version");
            for (JVMSpec spec : JVMSpec.values()) {
                if (spec == UNDEFINED || !spec.majorVersion.equals(jvmSpecVersion)) continue;
                return spec;
            }
            return UNDEFINED;
        }

        int getValue() {
            return this.value;
        }
    }

    private static enum LinuxVersion implements Version
    {
        UNDEFINED(0, "Linux (undefined version)"),
        UBUNTU(1, "Ubuntu"),
        FEDORA(2, "Fedora"),
        SUSE(3, "Suse");

        final int value;
        final String identifier;

        private LinuxVersion(int value, String identifier) {
            this.value = value;
            this.identifier = identifier;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public String getName() {
            return this.identifier;
        }
    }

    private static enum MacVersion implements Version
    {
        UNDEFINED(0, "(undefined version)"),
        MAC_OS_10_5(1, "10.5"),
        MAC_OS_10_6(2, "10.6"),
        MAC_OS_10_7(3, "10.7"),
        MAC_OS_10_8(4, "10.8"),
        MAC_OS_10_9(5, "10.9"),
        MAC_OS_10_10(6, "10.10");

        final String majorVersion;
        final int value;

        private MacVersion(int value, String majorVersion) {
            this.value = value;
            this.majorVersion = majorVersion;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public String getName() {
            return "Mac OS " + this.majorVersion;
        }
    }

    private static enum WindowsVersion implements Version
    {
        UNDEFINED(0, "Windows (undefined version)", null),
        WINDOWS_XP(1, "Windows XP", "5.1"),
        WINDOWS_XP_64(2, "Windows XP", "5.2"),
        WINDOWS_VISTA(3, "Windows Vista", "6.0"),
        WINDOWS_7(4, "Windows 7", "6.1"),
        WINDOWS_8(5, "Windows 8", "6.2"),
        WINDOWS_8_1(6, "Windows 8.1", "6.3");

        final int value;
        final String name;
        final String versionNumber;

        private WindowsVersion(int value, String name, String versionNumber) {
            this.value = value;
            this.name = name;
            this.versionNumber = versionNumber;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

