/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.widgets;

import ch.dvbern.tax.common.presentation.cd.util.BrowserUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeComposite;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelStyledText
extends StyledText {
    private static final Logger LOG = LoggerFactory.getLogger(LabelStyledText.class);
    private static final Pattern TOKEN_DELIMITER = Pattern.compile("(?=<)|(?<=>)");
    private static final Pattern TAG_PTN = Pattern.compile("<.*>");
    private static final Pattern START_TAG_PTN = Pattern.compile("<(\\w+)\\s*((?:\\w+=\".*?\"\\s*)*)>");
    private static final Pattern END_TAG_PTN = Pattern.compile("</(\\w+)\\s*>");
    private static final Pattern ATTRIBUTE_PTN = Pattern.compile("(\\w+)=\"(.*)\"");
    private volatile boolean linkSupportActivated = false;

    public LabelStyledText(TaxmeComposite parent, int style) {
        super((Composite)parent, style);
        this.setEnabled(false);
        GridData gd = new GridData(1808);
        super.setLayoutData((Object)gd);
    }

    public void setText(String text) {
        if (text == null) {
            super.setText("");
            return;
        }
        String input = text.trim();
        if (input.isEmpty()) {
            super.setText("");
            return;
        }
        LinkedList<Integer> ranges = new LinkedList<Integer>();
        LinkedList<StyleRange> styles = new LinkedList<StyleRange>();
        LinkedList<TagEntry> activeTags = new LinkedList<TagEntry>();
        StringBuilder expandedText = new StringBuilder();
        Scanner scanner = new Scanner(input);
        scanner.useDelimiter(TOKEN_DELIMITER);
        StyleRange baseRange = new StyleRange();
        baseRange.start = 0;
        ranges.add(0);
        styles.add(baseRange);
        while (scanner.hasNext()) {
            String token;
            if (scanner.hasNext(TAG_PTN)) {
                String tagName;
                MatchResult m;
                if (scanner.hasNext(START_TAG_PTN)) {
                    Tag tag;
                    m = scanner.match();
                    token = scanner.next();
                    tagName = m.group(1).toUpperCase();
                    Map<String, String> attributes = Tag.parseAttributes(m.group(2));
                    try {
                        tag = Tag.valueOf(tagName);
                    }
                    catch (IllegalArgumentException e) {
                        LOG.trace("Ignoring unknown tag: " + tagName);
                        continue;
                    }
                    StyleRange crtRange = (StyleRange)styles.getLast();
                    StyleRange newRange = (StyleRange)crtRange.clone();
                    try {
                        tag.apply(attributes, this, newRange, expandedText);
                    }
                    catch (IllegalStateException e) {
                        LOG.trace("Ignoring illegal syntax for tag " + tagName + ": " + token);
                        continue;
                    }
                    if (tag.rangedTag) {
                        activeTags.add(new TagEntry(this, tag, crtRange));
                    }
                    int nextPos = expandedText.length();
                    ranges.add(nextPos - (Integer)ranges.getLast());
                    styles.add(newRange);
                    ranges.add(nextPos);
                    continue;
                }
                if (scanner.hasNext(END_TAG_PTN)) {
                    Tag tag;
                    m = scanner.match();
                    token = scanner.next();
                    if (activeTags.isEmpty()) continue;
                    tagName = m.group(1).toUpperCase();
                    try {
                        tag = Tag.valueOf(tagName);
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Ignoring unknown tag: " + tagName);
                        continue;
                    }
                    TagEntry lastTagOccurence = null;
                    int lastTagOccurenceIndex = -1;
                    ListIterator itr = activeTags.listIterator(activeTags.size());
                    while (itr.hasPrevious()) {
                        TagEntry entry = (TagEntry)itr.previous();
                        if (entry.tag != tag) continue;
                        lastTagOccurence = entry;
                        lastTagOccurenceIndex = itr.nextIndex();
                        break;
                    }
                    if (lastTagOccurence == null) continue;
                    if (lastTagOccurenceIndex == activeTags.size() - 1) {
                        activeTags.removeLast();
                    } else {
                        activeTags.subList(lastTagOccurenceIndex, activeTags.size()).clear();
                    }
                    int nextPos = expandedText.length();
                    ranges.add(nextPos - (Integer)ranges.getLast());
                    styles.add(lastTagOccurence.style);
                    ranges.add(nextPos);
                    continue;
                }
                scanner.next();
                continue;
            }
            token = scanner.next();
            expandedText.append(StringEscapeUtils.unescapeHtml4((String)token));
        }
        if (ranges.size() % 2 != 0) {
            ranges.add(expandedText.length() - (Integer)ranges.getLast());
        }
        if (!activeTags.isEmpty()) {
            LOG.trace("Ignoring unclosed tags: " + String.valueOf(activeTags));
        }
        super.setText(expandedText.toString());
        int[] intRanges = new int[ranges.size()];
        for (int i = 0; i < ranges.size(); ++i) {
            intRanges[i] = (Integer)ranges.get(i);
        }
        this.setStyleRanges(intRanges, styles.toArray(new StyleRange[styles.size()]));
    }

    private synchronized void activateLinkSupport() {
        if (this.linkSupportActivated) {
            return;
        }
        this.setEnabled(true);
        LabelStyledTextListener listener = new LabelStyledTextListener();
        this.addListener(3, listener);
        this.addSelectionListener(listener);
        this.setCaret(null);
        this.setCursor(new Cursor((Device)Display.getDefault(), 0));
        this.linkSupportActivated = true;
    }

    public static enum Tag {
        BR(false){

            @Override
            void apply(Map<String, String> attributes, LabelStyledText target, StyleRange range, StringBuilder sb) {
                sb.append("\n");
            }
        }
        ,
        LI(false){

            @Override
            void apply(Map<String, String> attributes, LabelStyledText target, StyleRange style, StringBuilder sb) {
                sb.append("- ");
            }
        }
        ,
        B{

            @Override
            void apply(Map<String, String> attributes, LabelStyledText target, StyleRange style, StringBuilder sb) {
                style.fontStyle |= 1;
            }
        }
        ,
        I{

            @Override
            void apply(Map<String, String> attributes, LabelStyledText target, StyleRange style, StringBuilder sb) {
                style.fontStyle |= 2;
            }
        }
        ,
        U{

            @Override
            void apply(Map<String, String> attributes, LabelStyledText target, StyleRange style, StringBuilder sb) {
                style.underline = true;
                style.underlineColor = style.foreground;
            }
        }
        ,
        RED{

            @Override
            void apply(Map<String, String> attributes, LabelStyledText target, StyleRange style, StringBuilder sb) {
                style.foreground = Display.getDefault().getSystemColor(3);
            }
        }
        ,
        GREEN{

            @Override
            void apply(Map<String, String> attributes, LabelStyledText target, StyleRange style, StringBuilder sb) {
                style.foreground = Display.getDefault().getSystemColor(5);
            }
        }
        ,
        BLUE{

            @Override
            void apply(Map<String, String> attributes, LabelStyledText target, StyleRange style, StringBuilder sb) {
                style.foreground = Display.getDefault().getSystemColor(9);
            }
        }
        ,
        A{

            @Override
            void apply(Map<String, String> attributes, LabelStyledText target, StyleRange style, StringBuilder sb) {
                String href = attributes.get("HREF");
                if (href == null) {
                    throw new IllegalStateException("Missing attribute HREF.");
                }
                style.underline = true;
                style.underlineStyle = 4;
                style.data = href;
                if (!target.linkSupportActivated) {
                    target.activateLinkSupport();
                }
            }
        };

        final boolean rangedTag;

        private Tag() {
            this(true);
        }

        private Tag(boolean rangedTag) {
            this.rangedTag = rangedTag;
        }

        abstract void apply(Map<String, String> var1, LabelStyledText var2, StyleRange var3, StringBuilder var4);

        public static Map<String, String> parseAttributes(String attributesString) {
            if (attributesString == null) {
                return Collections.emptyMap();
            }
            if ((attributesString = attributesString.trim()).isEmpty()) {
                return Collections.emptyMap();
            }
            String[] tokens = attributesString.split("\\s+");
            HashMap<String, String> attributes = new HashMap<String, String>(tokens.length);
            for (String token : tokens) {
                Matcher m = ATTRIBUTE_PTN.matcher(token);
                if (m.matches()) {
                    attributes.put(m.group(1).toUpperCase(), m.group(2));
                    continue;
                }
                LOG.trace("Ignoring misformatted attribute: " + token);
            }
            return attributes;
        }
    }

    private class TagEntry {
        final Tag tag;
        final StyleRange style;

        public TagEntry(LabelStyledText labelStyledText, Tag tag, StyleRange style) {
            this.tag = tag;
            this.style = style;
        }
    }

    private class LabelStyledTextListener
    implements Listener,
    SelectionListener {
        public void handleEvent(Event evt) {
            if (evt.type == 3) {
                int offset;
                try {
                    offset = LabelStyledText.this.getOffsetAtLocation(new Point(evt.x, evt.y));
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                StyleRange style = LabelStyledText.this.getStyleRangeAtOffset(offset);
                if (style != null && style.underline && style.underlineStyle == 4 && style.data != null) {
                    BrowserUtil.launchURI(style.data.toString());
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent evt) {
        }

        public void widgetSelected(SelectionEvent evt) {
            LabelStyledText.this.setSelection(0, 0);
        }
    }
}

