/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.widgets;

import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.presentation.cd.GuiEditorEntry;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertFormDataPart;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.ELabelItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.EValueItem;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.BorderedLabel;
import ch.dvbern.tax.common.presentation.cd.widgets.WidgetsUtil;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.awt.geom.Point2D;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TaxmeComposite
extends Composite {
    private static final int NO_INPUT_TYPE = 999;
    private static final String NO_POSITION = "";
    private boolean backgroundSet = false;

    public TaxmeComposite(Composite parent, int style) {
        super(parent, style);
    }

    protected void checkSubclass() {
    }

    public void setToolTipText(String newText) {
        if (!WidgetsUtil.equals(this.getToolTipText(), newText)) {
            super.setToolTipText(newText);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
        }
    }

    public void setFont(Font font) {
        if (!WidgetsUtil.equals(this.getFont(), font)) {
            super.setFont(font);
        }
    }

    public void setBackground(Color col) {
        if (!this.backgroundSet || !WidgetsUtil.equals(this.getBackground(), col)) {
            super.setBackground(col);
            this.backgroundSet = true;
        }
    }

    public void setForeground(Color col) {
        if (!WidgetsUtil.equals(this.getForeground(), col)) {
            super.setForeground(col);
        }
    }

    public void makeGuiEditable(ELabelItem item, Control label) {
        ExpertDisplayInfoDTO.LabelDTO itemDto = item.getItem();
        String key = itemDto.getKey();
        DisplayItemUniqueID uid = item.getUID() != null ? item.getUID() : itemDto.getUniqueItemIdentifier();
        this.makeGuiEditable((ExpertDisplayInfoDTO.TextItemDTO)itemDto, label, null, key, uid, itemDto.getOriginalSize(), 999, NO_POSITION);
    }

    public void makeGuiEditable(IValueItem item, Control input, BorderedLabel output) {
        if (item instanceof EValueItem) {
            ExpertDisplayInfoDTO.ValueItemDTO itemDto = ((EValueItem)item).getItem();
            String key = itemDto.getDataModelKey();
            DisplayItemUniqueID uid = item.getUID() != null ? item.getUID() : itemDto.getUniqueItemIdentifier();
            int inputType = itemDto.getType();
            Point2D.Float originalSize = itemDto.getOriginalSize();
            String optionPosition = NO_POSITION;
            if (itemDto.getValuePositions() != null) {
                Map valuePositions = itemDto.getValuePositions();
                for (Map.Entry entry : valuePositions.entrySet()) {
                    String currentOption = (String)entry.getKey();
                    if (item.getOptionValue() == null || !currentOption.equals(item.getOptionValue().toString())) continue;
                    optionPosition = currentOption;
                    originalSize = ((ExpertDisplayInfoDTO.ValuePositionDTO)entry.getValue()).getOriginalSize();
                }
            }
            this.makeGuiEditable((ExpertDisplayInfoDTO.TextItemDTO)itemDto, input, output, key, uid, originalSize, inputType, optionPosition);
        }
    }

    private void makeGuiEditable(final ExpertDisplayInfoDTO.TextItemDTO itemDto, Control simpleControl, BorderedLabel nestedControl, final String key, final DisplayItemUniqueID uid, final Point2D.Float originalSize, final int inputType, final String optionPosition) {
        Listener mouseListener = new Listener(){
            Point origin = null;
            Point offsetResize = null;
            Point endpointMove = null;
            final ExpertFormDataPart form = (ExpertFormDataPart)TaxmeComposite.this.getParent();
            final float zoom = this.form.getZoom();
            boolean isResize = false;

            public void handleEvent(Event event) {
                Rectangle rect = TaxmeComposite.this.getParent().getBounds();
                int borderDistanceConstant = 5;
                boolean isBorder = inputType != 3 && inputType != 1 && (Math.abs(rect.x + TaxmeComposite.this.getSize().x - event.x) < 5 || Math.abs(rect.y + TaxmeComposite.this.getSize().y - event.y) < 5);
                switch (event.type) {
                    case 5: {
                        int cursor = isBorder ? 2 : 21;
                        TaxmeComposite.this.setCursor(new Cursor((Device)TaxmeComposite.this.getDisplay(), cursor));
                        String beschrieb = "\n\nGr\u00f6sse \u00e4ndern: unten und rechts, der Crosshair-Cursor wird angezeigt.\nVerschieben: auf dem ganzen Control, der Hand-Cursor wird angezeigt.";
                        TaxmeController.getInstance().getDebugPart().setFieldInfo(key + beschrieb);
                        if (this.origin == null) break;
                        if (this.isResize) {
                            this.offsetResize = new Point(event.x - this.origin.x, event.y - this.origin.y);
                            TaxmeComposite.this.setSize(Math.round((float)itemDto.getWidth() * this.zoom + (float)this.offsetResize.x), Math.round((float)itemDto.getHeight() * this.zoom + (float)this.offsetResize.y));
                            break;
                        }
                        this.endpointMove = new Point(TaxmeComposite.this.getLocation().x + event.x - this.origin.x, TaxmeComposite.this.getLocation().y + event.y - this.origin.y);
                        TaxmeComposite.this.setLocation(this.endpointMove);
                        break;
                    }
                    case 3: {
                        if (isBorder) {
                            this.isResize = true;
                        }
                        if (!rect.contains(event.x, event.y)) break;
                        this.origin = new Point(event.x, event.y);
                        break;
                    }
                    case 4: {
                        GuiEditorEntry.Type entryType;
                        GuiEditorEntry.Type type = !optionPosition.equals(TaxmeComposite.NO_POSITION) ? GuiEditorEntry.Type.E_VALUE_POS : (entryType = inputType == 999 ? GuiEditorEntry.Type.E_LABEL : GuiEditorEntry.Type.E_VALUE);
                        if (this.offsetResize != null) {
                            float width = ((float)itemDto.getWidth() * this.zoom + (float)this.offsetResize.x) / this.zoom;
                            float height = ((float)itemDto.getHeight() * this.zoom + (float)this.offsetResize.y) / this.zoom;
                            TaxmeController.getInstance().updateGuiWidthHeight(uid, this.form.getFormName(), entryType, key, optionPosition, itemDto.getOriginalPosition(), width, height);
                            this.isResize = false;
                            this.offsetResize = null;
                        } else if (this.endpointMove != null) {
                            if (optionPosition.equals(TaxmeComposite.NO_POSITION)) {
                                TaxmeController.getInstance().updateGuiXY(uid, this.form.getFormName(), entryType, key, optionPosition, (float)this.endpointMove.x / this.zoom, (float)this.endpointMove.y / this.zoom, originalSize);
                            } else {
                                float x = (float)this.endpointMove.x / this.zoom - (float)itemDto.getX();
                                float y = (float)this.endpointMove.y / this.zoom - (float)itemDto.getY();
                                TaxmeController.getInstance().updateGuiXY(uid, this.form.getFormName(), entryType, key, optionPosition, x, y, originalSize);
                            }
                            this.endpointMove = null;
                        }
                        this.origin = null;
                    }
                }
            }
        };
        if (simpleControl != null) {
            simpleControl.setEnabled(false);
            if (inputType == 999) {
                simpleControl.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_EDITABLE));
            }
            this.addListener(3, mouseListener);
            this.addListener(5, mouseListener);
            this.addListener(4, mouseListener);
        } else if (nestedControl != null) {
            nestedControl.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_EDITABLE));
            nestedControl.getNestedLabel().addListener(3, mouseListener);
            nestedControl.getNestedLabel().addListener(5, mouseListener);
            nestedControl.getNestedLabel().addListener(4, mouseListener);
        }
    }
}

