/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.wizard;

import ch.dvbern.tax.common.presentation.cd.builders.ControlPanelHolder;
import ch.dvbern.tax.common.presentation.cd.builders.Director;
import ch.dvbern.tax.common.presentation.cd.builders.IControlBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WButtonBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WEmptyLineBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WFormHeaderBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WFormLabelBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WSectionBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WTableBuilder;
import ch.dvbern.tax.common.presentation.cd.util.ControlReuseUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeComposite;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.List;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardFormDataPart
extends TaxmeComposite {
    private static final Logger LOG = LoggerFactory.getLogger(WizardFormDataPart.class);
    private static final Director director = new Director();
    private static final WFormHeaderBuilder formHeaderBuilder = new WFormHeaderBuilder();
    private static final WButtonBuilder buttonBuilder = new WButtonBuilder();
    private static final WTableBuilder tableBuilder = new WTableBuilder();
    private static final WSectionBuilder sectionBuilder = new WSectionBuilder();
    private static final WFormLabelBuilder formLabelBuilder = new WFormLabelBuilder();
    private static final WEmptyLineBuilder emptyLineBuilder = new WEmptyLineBuilder();
    private ControlPanelHolder controlPanelHolder;

    public WizardFormDataPart(Composite parent) {
        super(parent, 0);
        this.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 2;
        gridLayout.marginWidth = 5;
        this.setLayout((Layout)gridLayout);
    }

    public void setContent(WizardDisplayInfoDTO wizardDisplayInfoDTO, boolean reuse, ControlReuseUtil controlReuseUtil) {
        WizardDisplayInfoDTO.FormItemDTO formItemDTO = wizardDisplayInfoDTO.getFormItemDTO();
        this.controlPanelHolder = new ControlPanelHolder(this, controlReuseUtil);
        WFormHeaderBuilder builder = formHeaderBuilder;
        formHeaderBuilder.init(formItemDTO);
        this.buildControl(builder);
        List formChildren = formItemDTO.getChildren();
        for (Object aFormChildren : formChildren) {
            WizardDisplayInfoDTO.AbstractItemDTO child = (WizardDisplayInfoDTO.AbstractItemDTO)aFormChildren;
            this.generateItem(child, reuse);
        }
    }

    private void generateItem(WizardDisplayInfoDTO.AbstractItemDTO item, boolean reuse) {
        if (item instanceof WizardDisplayInfoDTO.LabelItemDTO) {
            formLabelBuilder.init((WizardDisplayInfoDTO.LabelItemDTO)item);
            this.buildControl(formLabelBuilder);
        } else if (item instanceof WizardDisplayInfoDTO.BRItemDTO && !reuse) {
            emptyLineBuilder.init();
            this.buildControl(emptyLineBuilder);
        } else if (item instanceof WizardDisplayInfoDTO.TableItemDTO) {
            tableBuilder.init((WizardDisplayInfoDTO.TableItemDTO)item, null);
            this.buildControl(tableBuilder);
        } else if (item instanceof WizardDisplayInfoDTO.ButtonDTO) {
            buttonBuilder.init((WizardDisplayInfoDTO.ButtonDTO)item);
            this.buildControl(buttonBuilder);
        } else if (item instanceof WizardDisplayInfoDTO.SectionItemDTO) {
            sectionBuilder.init((WizardDisplayInfoDTO.SectionItemDTO)item);
            this.buildControl(sectionBuilder);
        } else {
            LOG.warn("undefined formChild: " + String.valueOf(item.getClass()));
        }
    }

    private void buildControl(IControlBuilder builder) {
        director.init(builder, this.controlPanelHolder);
        director.createControl();
    }
}

