/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.wizard;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ValidateAction;
import ch.dvbern.tax.common.presentation.cd.resourcetools.TranslationManager;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeComposite;
import ch.dvbern.tax.common.presentation.cd.wizard.RootElement;
import ch.dvbern.tax.common.presentation.cd.wizard.TreeContentProvider;
import ch.dvbern.tax.common.presentation.cd.wizard.TreeLabelProvider;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.Collections;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class WizardNavigationPart
extends TaxmeComposite {
    protected TreeViewer treeViewer = null;
    private RootElement rootElement = null;

    public WizardNavigationPart(Composite parent) {
        super(parent, 2048);
        this.setLayout((Layout)new FillLayout());
        this.rootElement = this.getInitalInput();
        this.treeViewer = new TreeViewer((Composite)this, 4);
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.treeViewer.setInput((Object)this.rootElement);
        this.treeViewer.getTree().setFont(GuiUtil.getFontRegistry().get("font.navigation"));
        if (TaxmeConfig.getBoolean("ToolsEnabled")) {
            this.treeViewer.getTree().addMouseListener(TranslationManager.getInstance().getMouseListener());
        }
        this.treeViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection;
                TaxmeController ctrl = TaxmeController.getInstance();
                if (TaxmeConfig.getFormStateDMK() != null) {
                    int dataModelState = TaxmeController.getInstance().getTmoCdSession().getDataModelState();
                    ModelItemDTO itemToUpdate = new ModelItemDTO((Object)dataModelState);
                    itemToUpdate.setTouched();
                    TaxmeController.getInstance().getTmoCdSession().updateSilent(Collections.singletonMap(TaxmeConfig.getFormStateDMK(), itemToUpdate));
                }
                if ((selection = (StructuredSelection)event.getSelection()) == null || selection.getFirstElement() == null) {
                    return;
                }
                WizardDisplayInfoDTO.NavigationsItemDTO navItem = (WizardDisplayInfoDTO.NavigationsItemDTO)selection.getFirstElement();
                if (navItem.getState() == 11 || ctrl.getWizardDisplayInfoDTO().getFormItemDTO().getIsTableEntry() || ctrl.isInWizardLink()) {
                    ISelection sel = null;
                    WizardNavigationPart.this.treeViewer.setSelection(sel);
                    return;
                }
                if (ctrl.getDataModelKey() != null && ctrl.getDataModelKey().equals(navItem.getKey())) {
                    return;
                }
                if (!EngineUtil.endsWithTableIndex((String)ctrl.getDataModelKey()) && ctrl.getDataModelKey() != null) {
                    ValidateAction validateAction = new ValidateAction();
                    validateAction.execute(ctrl.getWizardDisplayInfoDTO().getFormItemDTO());
                    if (ctrl.hasCurrentWizardFormNewMessages()) {
                        return;
                    }
                }
                ctrl.setDataModelKey(navItem.getKey());
                ctrl.getApp().getCallBackShell().forceFocus();
            }
        });
    }

    private RootElement getInitalInput() {
        return new RootElement(null);
    }

    public void dispose() {
        this.treeViewer.getTree().dispose();
        super.dispose();
    }

    public void setContent(WizardDisplayInfoDTO.NavigationDTO navDTO) {
        if (this.rootElement.getCurrent() != null && this.rootElement.getCurrent().equals((Object)navDTO)) {
            return;
        }
        this.rootElement.update(navDTO);
        this.treeViewer.getControl().setRedraw(false);
        this.treeViewer.refresh();
        if (navDTO != null) {
            this.treeViewer.setSelection((ISelection)this.getSelection(navDTO.getThisKey()));
        }
        this.treeViewer.expandToLevel(10);
        this.treeViewer.getControl().setRedraw(true);
    }

    private StructuredSelection getSelection(String key) {
        Object o = this.treeViewer.getInput();
        if (!(o instanceof RootElement)) {
            return new StructuredSelection();
        }
        RootElement root = (RootElement)o;
        for (WizardDisplayInfoDTO.NavigationsItemDTO element : root.getChildren()) {
            WizardDisplayInfoDTO.NavigationsItemDTO selektiertesElement = this.getSelection(key, element);
            if (selektiertesElement == null || selektiertesElement.getState() == 12) continue;
            return new StructuredSelection((Object)selektiertesElement);
        }
        return new StructuredSelection();
    }

    private WizardDisplayInfoDTO.NavigationsItemDTO getSelection(String key, WizardDisplayInfoDTO.NavigationsItemDTO navigationsItemDTO) {
        if (navigationsItemDTO == null) {
            return null;
        }
        if (navigationsItemDTO.getKey().equals(key)) {
            return navigationsItemDTO;
        }
        if (navigationsItemDTO.getChildren() == null) {
            return null;
        }
        for (WizardDisplayInfoDTO.NavigationsItemDTO element : navigationsItemDTO.getChildren()) {
            if (element.getKey().equals(key)) {
                return element;
            }
            WizardDisplayInfoDTO.NavigationsItemDTO subElement = this.getSelection(key, element);
            if (subElement == null) continue;
            return subElement;
        }
        return null;
    }
}

