/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.datatypes;

import ch.dvbern.oss.datatypes.ranges.MinMaxRangeCheck;
import ch.dvbern.oss.datatypes.ranges.RangeCheck;
import java.io.Serializable;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractPruefzifferNummer
implements Serializable {
    private static final long serialVersionUID = 2480682944154690382L;
    protected static final Pattern NON_DIGIT = Pattern.compile("\\D");
    private final long nummer;
    private final int pruefziffer;

    private static void checkRange(long nummerToCheck, @Nullable RangeCheck rangeCheck) {
        if (rangeCheck == null) {
            return;
        }
        if (!rangeCheck.checkRange(nummerToCheck)) {
            throw new IllegalArgumentException("Argument " + nummerToCheck + " not in range: " + rangeCheck);
        }
    }

    protected AbstractPruefzifferNummer() {
        this.nummer = 0L;
        this.pruefziffer = 0;
    }

    protected AbstractPruefzifferNummer(long nummer, long minValue, long maxValue) {
        AbstractPruefzifferNummer.checkRange(nummer, new MinMaxRangeCheck(minValue, maxValue));
        this.nummer = nummer;
        this.pruefziffer = this.berechnePruefziffer(nummer);
    }

    protected AbstractPruefzifferNummer(long nummer, @Nullable RangeCheck rangeCheck) {
        AbstractPruefzifferNummer.checkRange(nummer, rangeCheck);
        this.nummer = nummer;
        this.pruefziffer = this.berechnePruefziffer(nummer);
    }

    protected AbstractPruefzifferNummer(@Nonnull String nummer, long minValue, long maxValue) {
        this(Long.parseLong(NON_DIGIT.matcher(nummer).replaceAll("")), minValue, maxValue);
    }

    protected AbstractPruefzifferNummer(@Nonnull String nummer, @Nullable RangeCheck rangeCheck) {
        this(Long.parseLong(NON_DIGIT.matcher(nummer).replaceAll("")), rangeCheck);
    }

    protected abstract int berechnePruefziffer(long var1);

    @Deprecated
    public long getNummer() {
        return this.nummer;
    }

    public long getNummerAsLong() {
        return this.nummer;
    }

    public int getPruefziffer() {
        return this.pruefziffer;
    }

    public boolean isValid() {
        return this.nummer % 10L == (long)this.pruefziffer;
    }

    @Deprecated
    @Nonnull
    public String getNumberString() {
        return Long.toString(this.nummer);
    }

    @Nonnull
    public String getNummerAsString() {
        return Long.toString(this.nummer);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPruefzifferNummer that = (AbstractPruefzifferNummer)o;
        if (this.nummer != that.nummer) {
            return false;
        }
        return this.pruefziffer == that.pruefziffer;
    }

    public int hashCode() {
        int result = (int)(this.nummer ^ this.nummer >>> 32);
        result = 31 * result + this.pruefziffer;
        return result;
    }
}

