/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.datatypes;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IBAN
implements Serializable,
Comparable<IBAN> {
    private static final long serialVersionUID = 1L;
    private static final Pattern NON_WORD = Pattern.compile("\\W");
    @Nonnull
    private final String ibannummer;
    private static final Map<String, IbanInfo> IBAN_INFOS = new HashMap<String, IbanInfo>();

    public IBAN() {
        this.ibannummer = "";
    }

    public IBAN(@Nonnull String iban) {
        this.ibannummer = NON_WORD.matcher(iban).replaceAll("");
    }

    @Nonnull
    public String getIbannummer() {
        return this.ibannummer;
    }

    public boolean isValid() {
        return this.isCheckDigitValid();
    }

    private boolean isCheckDigitValid() {
        if (this.ibannummer.length() < 2) {
            return false;
        }
        if (this.ibannummer.length() != this.getValidIBANLength()) {
            return false;
        }
        BigInteger numericIBAN = this.getNumericIBAN(false);
        int checkDigit = numericIBAN.mod(new BigInteger("97")).intValue();
        return checkDigit == 1;
    }

    private int getValidIBANLength() {
        String code = this.ibannummer.substring(0, 2).toUpperCase(Locale.ENGLISH);
        IbanInfo info = IBAN_INFOS.get(code);
        return info == null ? 0 : info.getAllowedLength();
    }

    private int getClearingNrLength() {
        String code = this.ibannummer.substring(0, 2).toUpperCase(Locale.ENGLISH);
        IbanInfo info = IBAN_INFOS.get(code);
        return info == null ? 0 : info.getClearingNrLength();
    }

    @Nonnull
    private BigInteger getNumericIBAN(boolean isCheckDigitAtEnd) {
        String endCheckDigitIBAN = this.ibannummer;
        if (!isCheckDigitAtEnd) {
            endCheckDigitIBAN = this.ibannummer.substring(4) + this.ibannummer.substring(0, 4);
        }
        StringBuilder numericIBAN = new StringBuilder();
        for (int i = 0; i < endCheckDigitIBAN.length(); ++i) {
            if (Character.isDigit(endCheckDigitIBAN.charAt(i))) {
                numericIBAN.append(endCheckDigitIBAN.charAt(i));
                continue;
            }
            numericIBAN.append(10 + IBAN.getAlphabetPosition(endCheckDigitIBAN.charAt(i)));
        }
        return new BigInteger(numericIBAN.toString());
    }

    private static int getAlphabetPosition(char letter) {
        return Character.valueOf(Character.toUpperCase(letter)).compareTo(Character.valueOf('A'));
    }

    @Nullable
    public String extractClearingNr() {
        if (!this.isValid()) {
            throw new IllegalArgumentException("Methode darf nur mit g\u00fcltiger IBAN Nr aufgerufen werden " + this.getIbannummer());
        }
        int clearingNrLength = this.getClearingNrLength();
        if (clearingNrLength == 0) {
            return null;
        }
        return this.ibannummer.substring(4, clearingNrLength + 4);
    }

    @Override
    public int compareTo(@Nonnull IBAN other) {
        return this.getIbannummer().compareTo(other.getIbannummer());
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getIbannummer());
        int numberOfSpaces = sb.length() / 4;
        for (int i = 0; i < numberOfSpaces; ++i) {
            this.saveInsert((i + 1) * 4 + i, sb);
        }
        return sb.toString().trim();
    }

    private void saveInsert(int offset, @Nonnull StringBuilder sb) {
        if (sb.length() >= offset) {
            sb.insert(offset, ' ');
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IBAN that = (IBAN)o;
        return this.getIbannummer().equals(that.getIbannummer());
    }

    public int hashCode() {
        return 31 * this.getIbannummer().hashCode();
    }

    static {
        IBAN_INFOS.put("AD", new IbanInfo(24, 4));
        IBAN_INFOS.put("AT", new IbanInfo(20, 5));
        IBAN_INFOS.put("BE", new IbanInfo(16, 3));
        IBAN_INFOS.put("BA", new IbanInfo(20, 3));
        IBAN_INFOS.put("BG", new IbanInfo(22, 4));
        IBAN_INFOS.put("CH", new IbanInfo(21, 5));
        IBAN_INFOS.put("CY", new IbanInfo(28, 3));
        IBAN_INFOS.put("CZ", new IbanInfo(24, 4));
        IBAN_INFOS.put("DE", new IbanInfo(22, 8));
        IBAN_INFOS.put("DK", new IbanInfo(18, 4));
        IBAN_INFOS.put("EE", new IbanInfo(20, 2));
        IBAN_INFOS.put("ES", new IbanInfo(24, 4));
        IBAN_INFOS.put("FO", new IbanInfo(18));
        IBAN_INFOS.put("FI", new IbanInfo(18, 6));
        IBAN_INFOS.put("FR", new IbanInfo(27, 5));
        IBAN_INFOS.put("GB", new IbanInfo(22, 4));
        IBAN_INFOS.put("GI", new IbanInfo(23, 4));
        IBAN_INFOS.put("GL", new IbanInfo(18));
        IBAN_INFOS.put("GR", new IbanInfo(27, 8));
        IBAN_INFOS.put("HU", new IbanInfo(28, 7));
        IBAN_INFOS.put("HR", new IbanInfo(21, 7));
        IBAN_INFOS.put("IE", new IbanInfo(22, 4));
        IBAN_INFOS.put("IS", new IbanInfo(26, 4));
        IBAN_INFOS.put("IT", new IbanInfo(27));
        IBAN_INFOS.put("LI", new IbanInfo(21, 5));
        IBAN_INFOS.put("LT", new IbanInfo(20, 5));
        IBAN_INFOS.put("LU", new IbanInfo(20, 3));
        IBAN_INFOS.put("LV", new IbanInfo(21, 4));
        IBAN_INFOS.put("MA", new IbanInfo(24, 3));
        IBAN_INFOS.put("MC", new IbanInfo(27, 5));
        IBAN_INFOS.put("MK", new IbanInfo(19, 3));
        IBAN_INFOS.put("MT", new IbanInfo(31, 4));
        IBAN_INFOS.put("NL", new IbanInfo(18, 4));
        IBAN_INFOS.put("NO", new IbanInfo(15, 4));
        IBAN_INFOS.put("PL", new IbanInfo(28, 7));
        IBAN_INFOS.put("PT", new IbanInfo(25, 8));
        IBAN_INFOS.put("RO", new IbanInfo(24, 4));
        IBAN_INFOS.put("RS", new IbanInfo(22, 3));
        IBAN_INFOS.put("SE", new IbanInfo(24, 3));
        IBAN_INFOS.put("SI", new IbanInfo(19, 5));
        IBAN_INFOS.put("SK", new IbanInfo(24, 4));
        IBAN_INFOS.put("SM", new IbanInfo(27));
        IBAN_INFOS.put("TN", new IbanInfo(24, 5));
        IBAN_INFOS.put("TR", new IbanInfo(26, 5));
    }

    private static class IbanInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int allowedLength;
        private final int clearingNrLength;

        IbanInfo(int allowedLength, int clearingNrLength) {
            this.allowedLength = allowedLength;
            this.clearingNrLength = clearingNrLength;
        }

        IbanInfo(int allowedLength) {
            this.allowedLength = allowedLength;
            this.clearingNrLength = 0;
        }

        protected IbanInfo() {
            this.allowedLength = 0;
            this.clearingNrLength = 0;
        }

        public int getClearingNrLength() {
            return this.clearingNrLength;
        }

        public int getAllowedLength() {
            return this.allowedLength;
        }
    }
}

