/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.datatypes;

import ch.dvbern.oss.datatypes.AbstractPruefzifferNummer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PostkontoNummer
extends AbstractPruefzifferNummer
implements Comparable<PostkontoNummer> {
    private static final long serialVersionUID = 1L;
    private static final long MAX_VALUE = 999999999L;
    private static final long MIN_VALUE = 100000000L;
    private static final int[] TABELLE = new int[]{0, 9, 4, 6, 8, 2, 7, 1, 3, 5};

    private static String checkDigits(String nummer) {
        String group1 = nummer.substring(0, 2);
        String group3 = nummer.substring(nummer.length() - 1);
        String group2 = nummer.substring(2, nummer.length() - 1);
        group2 = NON_DIGIT.matcher(group2).replaceAll("");
        return group1 + String.format("%06d", Integer.parseInt(group2)) + group3;
    }

    public PostkontoNummer() {
    }

    public PostkontoNummer(long nummer) {
        super(PostkontoNummer.checkDigits(String.valueOf(nummer)), 100000000L, 999999999L);
    }

    public PostkontoNummer(@Nonnull String nummer) {
        super(PostkontoNummer.checkDigits(nummer), 100000000L, 999999999L);
    }

    @Override
    protected int berechnePruefziffer(long nummerToCalculate) {
        String numberAsString = String.valueOf(nummerToCalculate / 10L);
        int uebertrag = 0;
        for (int i = 0; i < numberAsString.length(); ++i) {
            Integer currentDigit = Integer.valueOf(numberAsString.substring(i, i + 1));
            uebertrag = TABELLE[(uebertrag + currentDigit) % 10];
        }
        return (10 - uebertrag) % 10;
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder(Long.toString(this.getNummerAsLong()));
        sb.insert(2, '-');
        sb.insert(9, '-');
        return sb.toString();
    }

    @Override
    public int compareTo(@Nonnull PostkontoNummer o) {
        return Long.valueOf(o.getNummerAsLong()).compareTo(this.getNummerAsLong());
    }

    protected PostkontoNummer(long nummer, long minValue, long maxValue) {
        super(nummer, minValue, maxValue);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

