/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.datatypes;

import ch.dvbern.oss.datatypes.AbstractPruefzifferNummer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SozialversicherungsNummer
extends AbstractPruefzifferNummer
implements Comparable<SozialversicherungsNummer> {
    private static final long serialVersionUID = 923267806499518804L;
    private static final long MAX_VALUE = 9999999999999L;
    private static final long MIN_VALUE = 1000000000000L;

    public SozialversicherungsNummer() {
    }

    public SozialversicherungsNummer(long nummer) {
        super(nummer, 1000000000000L, 9999999999999L);
    }

    public SozialversicherungsNummer(@Nonnull String nummer) {
        super(nummer, 1000000000000L, 9999999999999L);
    }

    @Override
    protected int berechnePruefziffer(long nummerToCalculate) {
        int pruefziffer = 0;
        int z = 1;
        for (long n = nummerToCalculate / 10L; n > 0L; n /= 10L) {
            long ziffer = n % 10L;
            pruefziffer = this.incrementPruefziffer(pruefziffer, (int)ziffer, z);
            ++z;
        }
        int returnValue = 0;
        if (pruefziffer % 10 != 0) {
            returnValue = 10 - pruefziffer % 10;
        }
        return returnValue;
    }

    private int incrementPruefziffer(int pruefziffer, int ziffer, int z) {
        int increment = ziffer;
        if (z % 2 != 0) {
            increment *= 3;
        }
        return pruefziffer + increment;
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder(Long.toString(this.getNummerAsLong()));
        sb.insert(3, '.');
        sb.insert(8, '.');
        sb.insert(13, '.');
        return sb.toString();
    }

    @Override
    public int compareTo(@Nonnull SozialversicherungsNummer o) {
        return Long.valueOf(o.getNummerAsLong()).compareTo(this.getNummerAsLong());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

