/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.datatypes;

import ch.dvbern.oss.datatypes.AbstractPruefzifferNummer;
import ch.dvbern.oss.datatypes.ranges.CompoundRangeCheck;
import ch.dvbern.oss.datatypes.ranges.MinMaxRangeCheck;
import ch.dvbern.oss.datatypes.ranges.RangeCheck;
import java.text.NumberFormat;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ZpvNummer
extends AbstractPruefzifferNummer
implements Comparable<ZpvNummer> {
    private static final long serialVersionUID = -7862409348622892480L;
    public static final long MIN_VALUE = 10000000L;
    public static final long MAX_VALUE = 999999999L;
    public static final long LASTTEST_MIN_VALUE = 1L;
    public static final long LASTTEST_MAX_VALUE = 9999L;
    private static final RangeCheck CHECK_STRICT = new MinMaxRangeCheck(10000000L, 999999999L);
    private static final RangeCheck CHECK_LASTTESTONLY = new MinMaxRangeCheck(1L, 9999L);
    private static final RangeCheck CHECK_LASTTEST_ALLOWED = new CompoundRangeCheck(CHECK_STRICT, CHECK_LASTTESTONLY);
    private static final Locale PRETTYPRINT_LOCALE = new Locale("de", "CH");

    public ZpvNummer() {
    }

    public ZpvNummer(long nummer) {
        this(nummer, true);
    }

    public ZpvNummer(@Nonnull String nummer) {
        this(nummer, true);
    }

    public ZpvNummer(long nummer, boolean strict) {
        super(nummer, strict ? CHECK_STRICT : CHECK_LASTTEST_ALLOWED);
    }

    public ZpvNummer(@Nonnull String nummer, boolean strict) {
        super(nummer, strict ? CHECK_STRICT : CHECK_LASTTEST_ALLOWED);
    }

    @Override
    protected int berechnePruefziffer(long nummerToCalculate) {
        int pruefziffer = 0;
        boolean ungeradePosition = true;
        for (int restlicheNummer = (int)nummerToCalculate / 10; restlicheNummer > 0; restlicheNummer /= 10) {
            int ziffer;
            int zifferTmp = ziffer = restlicheNummer % 10;
            if (ungeradePosition) {
                zifferTmp = ziffer * 2;
            }
            boolean bl = ungeradePosition = !ungeradePosition;
            if (zifferTmp >= 10) {
                zifferTmp = zifferTmp % 10 + 1;
            }
            pruefziffer += zifferTmp;
        }
        return (10 - pruefziffer % 10) % 10;
    }

    @Override
    public int compareTo(@Nonnull ZpvNummer o) {
        return Long.valueOf(o.getNummerAsLong()).compareTo(this.getNummerAsLong());
    }

    public String toString() {
        return NumberFormat.getInstance(PRETTYPRINT_LOCALE).format(this.getNummerAsLong());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

