/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.datatypes.ranges;

import ch.dvbern.oss.datatypes.ranges.RangeCheck;
import javax.annotation.Nonnull;

public class CompoundRangeCheck
implements RangeCheck {
    private static final long serialVersionUID = 1L;
    private static final RangeCheck[] RANGE_CHECKS = new RangeCheck[0];
    @Nonnull
    private final RangeCheck[] checks;

    public CompoundRangeCheck(RangeCheck ... checks) {
        this.checks = checks == null ? RANGE_CHECKS : (RangeCheck[])checks.clone();
    }

    public CompoundRangeCheck() {
        this.checks = RANGE_CHECKS;
    }

    @Override
    public boolean checkRange(long nummerToCheck) {
        for (RangeCheck check : this.checks) {
            if (!check.checkRange(nummerToCheck)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompoundRangeCheck[L(");
        for (int i = 0; i < this.checks.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.checks[i]);
        }
        sb.append(")]");
        return sb.toString();
    }
}

