/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.oss.datatypes.ranges;

import ch.dvbern.oss.datatypes.ranges.RangeCheck;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MinMaxRangeCheck
implements RangeCheck {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final Long minValue;
    @Nullable
    private final Long maxValue;

    public MinMaxRangeCheck() {
        this.minValue = null;
        this.maxValue = null;
    }

    public MinMaxRangeCheck(@Nullable Long minValue, @Nullable Long maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public boolean checkRange(long nummerToCheck) {
        Long value = nummerToCheck;
        if (this.minValue != null && value.compareTo(this.minValue) < 0) {
            return false;
        }
        return this.maxValue == null || value.compareTo(this.maxValue) <= 0;
    }

    @Override
    @Nonnull
    public String toString() {
        return "MinMaxRangeCheck[minValue=" + this.minValue + ",maxValue=" + this.maxValue + ']';
    }

    @Nullable
    public Long getMinValue() {
        return this.minValue;
    }

    @Nullable
    public Long getMaxValue() {
        return this.maxValue;
    }
}

