/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bootstrap.api.helpers.AbstractBootstrapService;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.collections.WeldCollections;

public class SlimAnnotatedTypeStoreImpl
extends AbstractBootstrapService
implements SlimAnnotatedTypeStore {
    private final ComputingCache<Class<?>, Set<SlimAnnotatedType<?>>> typesByClass = ComputingCacheBuilder.newBuilder().build(x -> new CopyOnWriteArraySet());

    @Override
    public <X> SlimAnnotatedType<X> get(Class<X> type, String suffix) {
        for (SlimAnnotatedType annotatedType : this.get((Class)type)) {
            if (!Objects.equals(((AnnotatedTypeIdentifier)annotatedType.getIdentifier()).getSuffix(), suffix)) continue;
            return annotatedType;
        }
        return null;
    }

    public <X> Set<SlimAnnotatedType<X>> get(Class<X> type) {
        return WeldCollections.immutableSetView((Set)this.typesByClass.getCastValue(type));
    }

    @Override
    public <X> void put(SlimAnnotatedType<X> type) {
        this.typesByClass.getValue(type.getJavaClass()).add(type);
    }

    public void cleanupAfterBoot() {
        this.typesByClass.clear();
    }
}

