/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.cryptutil.fileformats;

import ch.dvbern.lib.cryptutil.annotations.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public final class PKCS8PEM {
    private static final Pattern PEM_KEY_PATTERN = Pattern.compile("^-----(BEGIN|END) (ENCRYPTED )?(PRIVATE|PUBLIC) KEY-----\\s*$");
    private static final String ALGO_RSA = "RSA";

    private byte[] parseKeyFromPKCS8PEM(InputStream pkcs8pem) {
        Objects.requireNonNull(pkcs8pem);
        BufferedReader br = new BufferedReader(new InputStreamReader(pkcs8pem, StandardCharsets.UTF_8));
        String content = br.lines().filter(line -> !line.isEmpty()).filter(line -> !PEM_KEY_PATTERN.matcher((CharSequence)line).matches()).collect(Collectors.joining("\r\n"));
        byte[] keyBytes = Base64.getMimeDecoder().decode(content);
        return keyBytes;
    }

    public RSAPrivateKey readKeyFromPKCS8EncodedPEM(InputStream privateKey, @Nullable char[] password) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Objects.requireNonNull(privateKey);
        byte[] keyData = this.parseKeyFromPKCS8PEM(privateKey);
        RSAPrivateKey rsaPrivateKey = password != null ? this.createFromPKCS8EndocdedRSAKey(keyData, password) : this.createFromPKCS8EndocdedRSAKey(keyData);
        return rsaPrivateKey;
    }

    public RSAPublicKey readCertFromPKCS8EncodedPEM(InputStream pkcs8pem) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyData = this.parseKeyFromPKCS8PEM(pkcs8pem);
        return this.createFromX509EncodedRSACert(keyData);
    }

    private RSAPublicKey createFromX509EncodedRSACert(byte[] publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory kf = KeyFactory.getInstance(ALGO_RSA);
        RSAPublicKey pubKey = (RSAPublicKey)kf.generatePublic(new X509EncodedKeySpec(publicKey));
        return pubKey;
    }

    private RSAPrivateKey createFromPKCS8EndocdedRSAKey(byte[] privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory kf = KeyFactory.getInstance(ALGO_RSA);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
        RSAPrivateKey privKey = (RSAPrivateKey)kf.generatePrivate(keySpec);
        return privKey;
    }

    private RSAPrivateKey createFromPKCS8EndocdedRSAKey(byte[] privateKey, char[] password) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        Objects.requireNonNull(privateKey);
        Objects.requireNonNull(password);
        EncryptedPrivateKeyInfo ePKInfo = new EncryptedPrivateKeyInfo(privateKey);
        Cipher cipher = Cipher.getInstance(ePKInfo.getAlgName());
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        SecretKeyFactory skFac = SecretKeyFactory.getInstance(ePKInfo.getAlgName());
        SecretKey pbeKey = skFac.generateSecret(pbeKeySpec);
        AlgorithmParameters algParams = ePKInfo.getAlgParameters();
        cipher.init(2, (Key)pbeKey, algParams);
        PKCS8EncodedKeySpec pkcs8KeySpec = ePKInfo.getKeySpec(cipher);
        KeyFactory rsaKeyFac = KeyFactory.getInstance(ALGO_RSA);
        RSAPrivateCrtKey rsaPriv = (RSAPrivateCrtKey)rsaKeyFac.generatePrivate(pkcs8KeySpec);
        return rsaPriv;
    }
}

