/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.vision.recognition;

import com.java4less.vision.RImage;
import com.java4less.vision.recognition.Point;
import java.util.Vector;

public class AreaWalker {
    Point startPoint = null;
    RImage image = null;
    Vector pendingPoints = new Vector();
    public long added = 0L;
    public long removed = 0L;

    public AreaWalker(RImage im, Point p, boolean initVisited) {
        this.startPoint = p;
        this.image = im;
        if (initVisited) {
            this.image.initializeVisited();
        }
        this.pendingPoints.add(p);
    }

    public Point getNextPoint() {
        if (this.pendingPoints.size() == 0) {
            return null;
        }
        Point p = (Point)this.pendingPoints.elementAt(0);
        this.pendingPoints.removeElementAt(0);
        ++this.removed;
        for (int i = 1; i <= 8; ++i) {
            Point p2 = this.image.getNeightbour(p, i);
            if (p2 == null || this.image.getVisited(p2)) continue;
            this.image.setVisited(p2);
            if (this.image.getPixel(p2) != RImage.FOREGROUND) continue;
            ++this.added;
            this.pendingPoints.add(p2);
        }
        return p;
    }
}

