/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.vision.recognition;

import com.java4less.vision.RImage;
import com.java4less.vision.recognition.ImageObject;
import com.java4less.vision.recognition.Point;
import com.java4less.vision.recognition.VectorizedImage;
import java.util.Vector;

public class PAVectorizer {
    Vector points = new Vector();
    public int minArea = Integer.parseInt(System.getProperty("com.java4less.vision.minarea", "30"));
    public int maxArea = Integer.parseInt(System.getProperty("com.java4less.vision.maxarea", "9000"));
    private boolean[][] visited = null;
    Point pointer = new Point(0.0, 0.0);
    private int currentI = 0;
    private int currentJ = 0;
    public long findObjectStats = 0L;
    protected static boolean showStats = System.getProperty("com.java4less.vision.stats", "0").equals("1");

    public VectorizedImage vectorize(RImage image) {
        VectorizedImage result = new VectorizedImage();
        Vector<ImageObject> objects = new Vector<ImageObject>();
        long prv = System.currentTimeMillis();
        image.initializeVisited();
        prv = System.currentTimeMillis();
        this.currentI = 0;
        this.currentJ = 0;
        ImageObject object = this.findObject(image);
        while (object != null) {
            if (object.getArea() > this.minArea && object.getArea() < this.maxArea) {
                objects.add(object);
            }
            object = this.findObject(image);
        }
        image.initializeVisited();
        if (showStats) {
            System.out.println("Time required to create objects " + this.findObjectStats);
        }
        prv = System.currentTimeMillis();
        for (int i = 0; i < objects.size(); ++i) {
            object = (ImageObject)objects.elementAt(i);
            object.calculatePA(image);
            result.addObject(object);
        }
        if (showStats) {
            System.out.println("Time required to calculate PAs " + (System.currentTimeMillis() - prv));
        }
        return result;
    }

    private ImageObject findObject(RImage image) {
        long prv = System.currentTimeMillis();
        int h = image.getHeight();
        int w = image.getWidth();
        while (this.currentJ < h) {
            this.currentI = 0;
            while (this.currentI < w) {
                if (!image.getVisited(this.currentI, this.currentJ)) {
                    image.setVisited(this.currentI, this.currentJ);
                    if (image.getPixel(this.currentJ, this.currentI) == RImage.FOREGROUND) {
                        ImageObject obj = new ImageObject(image, new Point(this.currentI, this.currentJ));
                        this.findObjectStats += System.currentTimeMillis() - prv;
                        return obj;
                    }
                }
                ++this.currentI;
            }
            ++this.currentJ;
        }
        this.findObjectStats += System.currentTimeMillis() - prv;
        return null;
    }
}

