/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.vision.recognition;

import com.java4less.vision.RImage;
import com.java4less.vision.recognition.Line;
import com.java4less.vision.recognition.Point;
import com.java4less.vision.recognition.VectorizedImage;
import java.util.Vector;

public class Vectorizer {
    Vector points = new Vector();

    public VectorizedImage vectorize(RImage image) {
        VectorizedImage result = new VectorizedImage();
        Line line = this.findLine(image);
        while (line != null) {
            result.addLine(line);
            line = this.findLine(image);
        }
        return result;
    }

    private Line findLine(RImage image) {
        Point start = null;
        Point end = null;
        Point lastValidEnd = null;
        Vector<Point> points = new Vector<Point>();
        int foreground = 0;
        int background = 1;
        for (int j = 0; j < image.getHeight() && start == null; ++j) {
            for (int i = 0; i < image.getWidth() && start == null; ++i) {
                if (image.getPixel(j, i) != foreground) continue;
                start = new Point(i, j);
            }
        }
        if (start == null) {
            return null;
        }
        points.add(start);
        lastValidEnd = start;
        image.setPixel(start, background);
        end = this.getNeighbour(image, start, foreground);
        while (end != null) {
            if (!this.checkChord((int)end.x, (int)end.y, points)) {
                Line l = new Line(start.x, start.y, lastValidEnd.x, lastValidEnd.y);
                break;
            }
            points.add(end);
            lastValidEnd = end;
            image.setPixel(end, background);
            if ((end = this.getNeighbour(image, end, foreground)) != null) continue;
            System.out.println("end point " + lastValidEnd);
        }
        return new Line(start.x, start.y, lastValidEnd.x, lastValidEnd.y);
    }

    private Point getNeighbour(RImage image, Point p, int foreground) {
        int[][] n = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
        for (int i = 0; i < n.length; ++i) {
            Point p2 = new Point(p.x + (double)n[i][0], p.y + (double)n[i][1]);
            if (!(p2.x < (double)image.getWidth()) || !(p.y < (double)image.getHeight()) || !(p2.x >= 0.0) || !(p.y >= 0.0) || image.getPixel(p2.y, p2.x) != foreground) continue;
            return p2;
        }
        return null;
    }

    private boolean checkChord(int x, int y, Vector pts) {
        float distancex = 0.0f;
        float distancey = 0.0f;
        float slope = 0.0f;
        float b = 0.0f;
        double xp = 0.0;
        double yp = 0.0;
        double distance = 0.0;
        Point p = (Point)pts.elementAt(0);
        distancex = (float)(p.x - (double)x);
        distancey = (float)(p.y - (double)y);
        if (distancex != 0.0f && distancey != 0.0f) {
            slope = distancey / distancex;
            b = (float)y - slope * (float)x;
        }
        for (int i = 1; i < pts.size(); ++i) {
            p = (Point)pts.elementAt(i);
            if (distancex == 0.0f) {
                distance = (float)Math.abs(p.x - (double)x);
            } else if (distancey == 0.0f) {
                distance = (float)Math.abs(p.y - (double)y);
            } else {
                xp = (p.y - (double)b) / (double)slope;
                yp = (double)slope * p.x + (double)b;
                distance = Math.min(Math.abs(p.x - xp), Math.abs(p.y - yp));
            }
            if (!(distance > 1.0)) continue;
            System.out.println("fail " + distance);
            return false;
        }
        return true;
    }
}

