/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rbarcode;

import com.java4less.rbarcode.BarCode;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;

public class BCApplet
extends Applet {
    public BarCode BC = null;
    public boolean isStandalone = false;

    public BCApplet() {
        this.setLayout(new BorderLayout());
    }

    public void start() {
        this.BC.paint(this.getGraphics());
    }

    public void refresh() {
        this.BC.paint(this.BC.getGraphics());
        this.paintAll(this.getGraphics());
    }

    public void init() {
        if (this.BC == null) {
            this.BC = new BarCode();
        }
        if (!this.isStandalone) {
            this.add("Center", this.BC);
        }
        this.initParam("RESOLUTION");
        this.initParam("CODE_TYPE");
        this.initParam("N");
        this.initParam("X");
        this.initParam("I");
        this.initParam("H");
        this.initParam("BAR_HEIGHT");
        this.initParam("CODABAR_START");
        this.initParam("CODABAR_STOP");
        this.initParam("BAR_COLOR");
        this.initParam("FONT_COLOR");
        this.initParam("TEXT_FONT");
        this.initParam("UPCE_SYSTEM");
        this.initParam("BACK_COLOR");
        this.initParam("CODE128_SET");
        this.initParam("LEFT_MARGIN");
        this.initParam("TOP_MARGIN");
        this.initParam("CHECK_CHAR");
        this.initParam("BARCODE");
        this.initParam("PROCESS_TILDE");
        this.initParam("GUARDBARS");
        this.initParam("ROTATE");
        this.initParam("SUPPLEMENT");
        this.initParam("SUPPLEMENT_CODE");
        this.initParam("SUPPLEMENT_HEIGHT");
        this.initParam("SUPPLEMENT_SEPARATION");
        this.initParam("POSTNET_TALL");
        this.initParam("POSTNET_SHORT");
        this.initParam("MSICHECKSUM");
        this.initParam("PDF_COMPACTION");
        this.initParam("PDF_ROWS");
        this.initParam("PDF_COLUMNS");
        this.initParam("PDF_ECLEVEL");
        this.initParam("PDFMacroFileId".toUpperCase());
        this.initParam("PDFMacroSegment".toUpperCase());
        this.initParam("PDFMacroSegmentCount".toUpperCase());
        this.initParam("PDFMacroLastSegment".toUpperCase());
        this.initParam("DM_FORMAT");
        this.initParam("DM_DOT_PIXELS");
        this.initParam("DM_TILDE");
        this.initParam("DM_MARGIN_PIXELS");
        this.initParam("DM_ENCODING");
    }

    private void initParam(String p) {
        String v = this.getStringParam(p, "");
        if (v.length() == 0) {
            return;
        }
        this.setParameter(p, v);
    }

    public void setParameter(String p, String v) {
        if (v == null) {
            return;
        }
        if (p.compareTo("CODE_TYPE") == 0) {
            if (v.compareTo("BAR39") == 0) {
                this.BC.barType = 0;
            }
            if (v.compareTo("BAR39EXT") == 0) {
                this.BC.barType = 1;
            }
            if (v.compareTo("CODE93") == 0) {
                this.BC.barType = 9;
            }
            if (v.compareTo("CODE11") == 0) {
                this.BC.barType = 3;
            }
            if (v.compareTo("CODABAR") == 0) {
                this.BC.barType = 4;
            }
            if (v.compareTo("CODE93EXT") == 0) {
                this.BC.barType = 14;
            }
            if (v.compareTo("CODE128") == 0) {
                this.BC.barType = 13;
            }
            if (v.compareTo("EAN128") == 0) {
                this.BC.barType = 16;
            }
            if (v.compareTo("MSI") == 0) {
                this.BC.barType = 5;
            }
            if (v.compareTo("IND25") == 0) {
                this.BC.barType = 7;
            }
            if (v.compareTo("MAT25") == 0) {
                this.BC.barType = 8;
            }
            if (v.compareTo("INTERLEAVED25") == 0) {
                this.BC.barType = 2;
            }
            if (v.compareTo("EAN13") == 0) {
                this.BC.barType = 10;
            }
            if (v.compareTo("EAN8") == 0) {
                this.BC.barType = 11;
            }
            if (v.compareTo("UPCA") == 0) {
                this.BC.barType = 6;
            }
            if (v.compareTo("UPCE") == 0) {
                this.BC.barType = 12;
            }
            if (v.compareTo("POSTNET") == 0) {
                this.BC.barType = 15;
            }
            if (v.compareTo("PDF417") == 0) {
                this.BC.barType = 30;
            }
            if (v.compareTo("DATAMATRIX") == 0) {
                this.BC.barType = 31;
            }
        }
        if (p.compareTo("N") == 0) {
            this.BC.N = new Double(v);
        }
        if (p.compareTo("SUPPLEMENT_CODE") == 0) {
            this.BC.supplement = v;
        }
        if (p.compareTo("SUPPLEMENT_SEPARATION") == 0) {
            this.BC.supSeparationCM = new Double(v);
        }
        if (p.compareTo("SUPPLEMENT_HEIGHT") == 0) {
            this.BC.supHeight = new Double(v);
        }
        if (p.compareTo("SUPPLEMENT") == 0) {
            this.BC.UPCEANSupplement2 = false;
            this.BC.UPCEANSupplement5 = false;
            if (v.compareTo("2") == 0) {
                this.BC.UPCEANSupplement2 = true;
            }
            if (v.compareTo("5") == 0) {
                this.BC.UPCEANSupplement5 = true;
            }
        }
        if (p.compareTo("MSICHECKSUM") == 0) {
            if (v.compareTo("10") == 0) {
                this.BC.MSIChecksum = 0;
            }
            if (v.compareTo("11") == 0) {
                this.BC.MSIChecksum = 1;
            }
            if (v.compareTo("10_10") == 0) {
                this.BC.MSIChecksum = 3;
            }
            if (v.compareTo("11_10") == 0) {
                this.BC.MSIChecksum = 2;
            }
        }
        if (p.compareTo("ROTATE") == 0) {
            this.BC.rotate = (int)new Double(v).doubleValue();
        }
        if (p.compareTo("POSTNET_TALL") == 0) {
            this.BC.postnetHeightTallBar = (int)new Double(v).doubleValue();
        }
        if (p.compareTo("POSTNET_SHORT") == 0) {
            this.BC.postnetHeightShortBar = (int)new Double(v).doubleValue();
        }
        if (p.compareTo("X") == 0) {
            this.BC.X = new Double(v);
        }
        if (p.compareTo("I") == 0) {
            this.BC.I = new Double(v);
        }
        if (p.compareTo("LEFT_MARGIN") == 0) {
            this.BC.leftMarginCM = new Double(v);
        }
        if (p.compareTo("TOP_MARGIN") == 0) {
            this.BC.topMarginCM = new Double(v);
        }
        if (p.compareTo("BAR_COLOR") == 0) {
            this.BC.barColor = this.convertColor(v);
        }
        if (p.compareTo("PROCESS_TILDE") == 0) {
            boolean bl = this.BC.processTilde = v.compareTo("Y") == 0;
        }
        if (p.compareTo("FONT_COLOR") == 0) {
            this.BC.fontColor = this.convertColor(v);
        }
        if (p.compareTo("BACK_COLOR") == 0) {
            this.BC.backColor = this.convertColor(v);
        }
        if (p.compareTo("RESOLUTION") == 0) {
            this.BC.resolution = new Integer(v);
        }
        if (p.compareTo("TEXT_ON_TOP") == 0) {
            boolean bl = this.BC.textOnTop = v.compareTo("Y") == 0;
        }
        if (p.compareTo("GUARDBARS") == 0) {
            boolean bl = this.BC.guardBars = v.compareTo("Y") == 0;
        }
        if (p.compareTo("UPCE_SYSTEM") == 0) {
            this.BC.UPCESytem = new String(v + "1").charAt(0);
        }
        if (p.compareTo("CODABAR_START") == 0) {
            this.BC.CODABARStartChar = new String(v + "A").charAt(0);
        }
        if (p.compareTo("CODABAR_STOP") == 0) {
            this.BC.CODABARStopChar = new String(v + "A").charAt(0);
        }
        if (p.compareTo("TEXT_FONT") == 0) {
            this.BC.textFont = this.convertFont(v);
        }
        if (p.compareTo("H") == 0) {
            this.BC.H = new Double(v);
        }
        if (p.compareTo("BARCODE") == 0) {
            this.BC.code = v;
        }
        if (p.compareTo("CHECK_CHAR") == 0) {
            boolean bl = this.BC.checkCharacter = v.compareTo("Y") == 0;
        }
        if (p.compareTo("CODE128_SET") == 0) {
            this.BC.Code128Set = new String(v + "B").charAt(0);
        }
        if (p.compareTo("BAR_HEIGHT") == 0) {
            this.BC.barHeightCM = new Double(v);
        }
    }

    public Color convertColor(String c) {
        if (c.compareTo("NULL") == 0) {
            return null;
        }
        if (c.compareTo("RED") == 0) {
            return Color.red;
        }
        if (c.compareTo("BLACK") == 0) {
            return Color.black;
        }
        if (c.compareTo("BLUE") == 0) {
            return Color.blue;
        }
        if (c.compareTo("CYAN") == 0) {
            return Color.cyan;
        }
        if (c.compareTo("DARKGRAY") == 0) {
            return Color.darkGray;
        }
        if (c.compareTo("GRAY") == 0) {
            return Color.gray;
        }
        if (c.compareTo("GREEN") == 0) {
            return Color.green;
        }
        if (c.compareTo("LIGHTGRAY") == 0) {
            return Color.lightGray;
        }
        if (c.compareTo("MAGENTA") == 0) {
            return Color.magenta;
        }
        if (c.compareTo("ORANGE") == 0) {
            return Color.orange;
        }
        if (c.compareTo("PINK") == 0) {
            return Color.pink;
        }
        if (c.compareTo("WHITE") == 0) {
            return Color.white;
        }
        if (c.compareTo("YELLOW") == 0) {
            return Color.yellow;
        }
        try {
            return Color.decode(c);
        }
        catch (Exception e) {
            return Color.black;
        }
    }

    public Font convertFont(String f) {
        String[] items = this.convertList(f);
        if (items == null) {
            return null;
        }
        if (items.length < 3) {
            return null;
        }
        int s = 0;
        if (items[1].compareTo("BOLD") == 0) {
            s = 1;
        }
        if (items[1].compareTo("ITALIC") == 0) {
            s = 2;
        }
        try {
            return new Font(items[0], s, new Integer(items[2]));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getStringParam(String Param, String def) {
        return this.getParameter(Param, def);
    }

    private String getParameter(String key, String def) {
        if (this.isStandalone) {
            return def;
        }
        if (this.getParameter(key) != null) {
            return this.getParameter(key);
        }
        return def;
    }

    private String[] convertList(String items) {
        String[] itema = new String[500];
        int itemCount = 0;
        int p = items.indexOf("|");
        while (p >= 0) {
            itema[itemCount++] = items.substring(0, p);
            items = items.substring(p + 1, items.length());
            p = items.indexOf("|");
        }
        if (items.compareTo("") != 0) {
            itema[itemCount++] = items;
        }
        if (itemCount == 0) {
            return null;
        }
        String[] result = new String[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            result[i] = itema[i];
        }
        return result;
    }

    private Integer getIntParam(String Param, Integer def) {
        try {
            String s = this.getParameter(Param, "");
            if (s.compareTo("") == 0) {
                return def;
            }
            return new Integer(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private Double getDoubleParam(String Param, Double def) {
        try {
            String s = this.getParameter(Param, "");
            if (s.compareTo("") == 0) {
                return def;
            }
            return new Double(s);
        }
        catch (Exception e) {
            return def;
        }
    }
}

