/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement;

import ch.ewv.taxstatement.TaxStatement;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.zip.Deflater;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import uk.org.okapibarcode.backend.Code128;
import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.Pdf417;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.graphics.Color;
import uk.org.okapibarcode.graphics.TextAlignment;
import uk.org.okapibarcode.graphics.TextBox;
import uk.org.okapibarcode.output.Java2DRenderer;

public class TaxStatementOKAPI {
    public static BufferedImage barCode1D(String id, Boolean text) {
        Code128 bc = new Code128();
        if (System.getProperty("pageBarCodeType", "CODE128").equals("EAN128")) {
            bc.setDataType(Symbol.DataType.GS1);
        }
        bc.setBarHeight(26);
        bc.setHumanReadableLocation(HumanReadableLocation.NONE);
        bc.setContent(id);
        if (text != null && text.booleanValue()) {
            bc.setQuietZoneVertical(3);
            bc.setFontSize(Integer.parseInt(System.getProperty("pageBarCodeFontSize", "12")));
            bc.setFontName(System.getProperty("pageBarCodeFont", "Helvetica"));
            bc.getTexts().add(new TextBox(0.0, (double)(bc.getHeight() + bc.getFontSize()), (double)bc.getWidth(), id, TextAlignment.CENTER));
        }
        BufferedImage bi = new BufferedImage(bc.getWidth(), bc.getHeight(), 12);
        Java2DRenderer renderer = new Java2DRenderer(bi.createGraphics(), 1.0, Color.WHITE, Color.BLACK);
        renderer.render((Symbol)bc);
        if (System.getProperty("debug", "false").equals("true")) {
            TaxStatement.write(bi);
        }
        return bi;
    }

    public static BufferedImage[] barCode2D(byte[] xml) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setXIncludeAware(false);
        dbf.setNamespaceAware(false);
        Document doc = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xml));
        Deflater deflater = new Deflater(9);
        byte[] deflated = new byte[xml.length + 100];
        deflater.setInput(xml);
        deflater.finish();
        int length = deflater.deflate(deflated);
        byte[] code = new byte[length];
        for (int i = 0; i < length; ++i) {
            code[i] = deflated[i];
        }
        deflater.end();
        Pdf417 pdf417 = new Pdf417();
        pdf417.setForceByteCompaction(true);
        pdf417.setPreferredEccLevel(4);
        pdf417.setBarHeight(1);
        pdf417.setRows(35);
        pdf417.setDataColumns(13);
        pdf417.setStructuredAppendIncludeSegmentCount(true);
        pdf417.setStructuredAppendFileName(TaxStatement.getAttributeXPath(doc, "/taxStatement/@id"));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            sb.append(String.format("%03d", Double.valueOf(Math.random() * 255.0).intValue()));
        }
        pdf417.setStructuredAppendFileId(sb.toString());
        List bc = Pdf417.createStructuredAppendSymbols((byte[])code, (Pdf417)pdf417);
        BufferedImage[] bi = new BufferedImage[bc.size()];
        for (int i = 0; i < bc.size(); ++i) {
            Pdf417 symbol = (Pdf417)bc.get(i);
            BufferedImage img = new BufferedImage(symbol.getWidth(), symbol.getHeight(), 12);
            Java2DRenderer renderer = new Java2DRenderer(img.createGraphics(), 1.0, Color.WHITE, Color.BLACK);
            renderer.render((Symbol)symbol);
            if (System.getProperty("debug", "false").equals("true")) {
                TaxStatement.write(img);
            }
            bi[i] = img;
        }
        return bi;
    }
}

