/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TaxStatementSignature {
    public static byte[] signXML(byte[] xml, KeyStore ks, String password) throws CertificateException, InvalidAlgorithmParameterException, IOException, KeyStoreException, MarshalException, NoSuchAlgorithmException, NoSuchProviderException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException, UnrecoverableKeyException, XMLSignatureException {
        XMLSignatureFactory sf = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
        Reference ref = sf.newReference("", sf.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(sf.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null);
        SignedInfo si = sf.newSignedInfo(sf.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), sf.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
        Enumeration<String> aliases = ks.aliases();
        String alias = aliases.nextElement();
        X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
        PrivateKey key = (PrivateKey)ks.getKey(alias, password.toCharArray());
        if (System.getProperty("print", "false").equals("true")) {
            System.out.println(cert.toString());
            System.out.println(key.getAlgorithm());
            System.out.println(key.getEncoded());
            System.out.println(key.getFormat());
        }
        KeyInfoFactory kif = sf.getKeyInfoFactory();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(cert.getSubjectX500Principal().getName());
        list.add(cert);
        X509Data xd = kif.newX509Data(list);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setXIncludeAware(false);
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xml));
        DOMSignContext sc = new DOMSignContext(key, (Node)doc.getDocumentElement());
        XMLSignature signature = sf.newXMLSignature(si, ki);
        signature.sign(sc);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.setOutputProperty("method", "xml");
        trans.setOutputProperty("encoding", "UTF-8");
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "no");
        baos.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes("UTF-8"));
        trans.transform(new DOMSource(doc), new StreamResult(baos));
        return baos.toByteArray();
    }

    public static byte[] signXML(byte[] xml, String pkcs12, String password) throws CertificateException, InvalidAlgorithmParameterException, IOException, KeyStoreException, MarshalException, NoSuchAlgorithmException, NoSuchProviderException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException, UnrecoverableKeyException, XMLSignatureException {
        KeyStore ks = KeyStore.getInstance("pkcs12", "SunJSSE");
        FileInputStream fis = new FileInputStream(pkcs12);
        ks.load(fis, password.toCharArray());
        return TaxStatementSignature.signXML(xml, ks, password);
    }

    public static boolean verifyXML(byte[] xml) throws IOException, MarshalException, ParserConfigurationException, SAXException, XMLSignatureException {
        XMLSignatureFactory sf = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setXIncludeAware(false);
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xml));
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl == null || nl.item(0) == null) {
            throw new XMLSignatureException("No signature exists!");
        }
        DOMValidateContext vc = new DOMValidateContext(new KeyValueKeySelector(), nl.item(0));
        XMLSignature signature = sf.unmarshalXMLSignature(vc);
        boolean verified = signature.validate(vc);
        if (System.getProperty("print", "false").equals("true") && !verified) {
            boolean sv = signature.getSignatureValue().validate(vc);
            System.out.println("Signature validation status: " + sv);
            Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
            int j = 0;
            while (i.hasNext()) {
                boolean ref = i.next().validate(vc);
                System.out.println("ref[" + j + "] validity status: " + ref);
                ++j;
            }
        }
        return verified;
    }

    public static String verifyXMLMessage(byte[] xml) {
        String msg = "";
        try {
            XMLSignatureFactory sf = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setXIncludeAware(false);
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xml));
            NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl == null || nl.item(0) == null) {
                msg = "No signature exists!";
            } else {
                DOMValidateContext vc = new DOMValidateContext(new KeyValueKeySelector(), nl.item(0));
                XMLSignature signature = sf.unmarshalXMLSignature(vc);
                boolean verified = signature.validate(vc);
                if (!verified) {
                    boolean sv = signature.getSignatureValue().validate(vc);
                    msg = "Signature validation status: " + sv;
                    Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
                    int j = 0;
                    while (i.hasNext()) {
                        boolean ref = i.next().validate(vc);
                        msg = msg + "\nref[" + j + "] validity status: " + ref;
                        ++j;
                    }
                }
            }
        }
        catch (Exception e) {
            msg = e.getMessage();
        }
        return msg;
    }

    private static class KeyValueKeySelector
    extends KeySelector {
        private KeyValueKeySelector() {
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            for (XMLStructure structure : keyInfo.getContent()) {
                if (!(structure instanceof X509Data)) continue;
                X509Data data = (X509Data)structure;
                for (Object o : data.getContent()) {
                    if (!(o instanceof X509Certificate)) continue;
                    X509Certificate cert = (X509Certificate)o;
                    PublicKey key = cert.getPublicKey();
                    if (System.getProperty("print", "false").equals("true")) {
                        System.out.println(cert.toString());
                        System.out.println(key.getAlgorithm());
                        System.out.println(key.getEncoded());
                        System.out.println(key.getFormat());
                    }
                    if ((!key.getAlgorithm().equalsIgnoreCase("DSA") || !method.getAlgorithm().equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) && (!key.getAlgorithm().equalsIgnoreCase("RSA") || !method.getAlgorithm().equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1"))) continue;
                    return new SimpleKeySelectorResult(key);
                }
            }
            throw new KeySelectorException("No key found!");
        }

        private static class SimpleKeySelectorResult
        implements KeySelectorResult {
            private PublicKey key;

            SimpleKeySelectorResult(PublicKey key) {
                this.key = key;
            }

            @Override
            public Key getKey() {
                return this.key;
            }
        }
    }
}

