/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.examples;

import ch.ewv.taxstatement.TaxStatement;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TaxStatementPDFToXML {
    protected static String getAttributeValue(Document doc, String expression) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        return (String)xpath.compile(expression).evaluate(doc, XPathConstants.STRING);
    }

    public static void displayXML(byte[] xml) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setXIncludeAware(false);
        dbf.setNamespaceAware(false);
        Document doc = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xml));
        System.out.println("version:                                 " + TaxStatement.getVersion(xml));
        System.out.println("periodFrom:                              " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/@periodFrom"));
        System.out.println("periodTo:                                " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/@periodTo"));
        System.out.println("totalTaxValue:                           " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/@totalTaxValue"));
        System.out.println("totalGrossRevenueA:                      " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/@totalGrossRevenueA"));
        System.out.println("totalGrossRevenueB:                      " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/@totalGrossRevenueB"));
        System.out.println("totalWithHoldingTaxClaim:                " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/@totalWithHoldingTaxClaim"));
        System.out.println("[BankAccounts]totalTaxValue:             " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfBankAccounts/@totalTaxValue"));
        System.out.println("[BankAccounts]totalGrossRevenueA:        " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfBankAccounts/@totalGrossRevenueA"));
        System.out.println("[BankAccounts]totalGrossRevenueB:        " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfBankAccounts/@totalGrossRevenueB"));
        System.out.println("[BankAccounts]totalWithHoldingTaxClaim:  " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfBankAccounts/@totalWithHoldingTaxClaim"));
        System.out.println("[Liabilities]totalTaxValue:              " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfLiabilities/@totalTaxValue"));
        System.out.println("[Liabilities]totalGrossRevenueB:         " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfLiabilities/@totalGrossRevenueB"));
        System.out.println("[Expenses]totalExpenses:                 " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfExpenses/@totalExpenses"));
        System.out.println("[Securities]totalTaxValue:               " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfSecurities/@totalTaxValue"));
        System.out.println("[Securities]totalGrossRevenueA:          " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueA"));
        System.out.println("[Securities]totalGrossRevenueB:          " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueB"));
        System.out.println("[Securities]totalWithHoldingTaxClaim:    " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfSecurities/@totalWithHoldingTaxClaim"));
        System.out.println("[Securities]totalGrossRevenueIUP:        " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueIUP"));
        System.out.println("[Securities]totalGrossRevenueConversion: " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueConversion"));
        System.out.println("[DA1]totalTaxValue:                      " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfLumpSumTaxCredit/@totalTaxValue"));
        System.out.println("[DA1]totalGrossRevenueB:                 " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfLumpSumTaxCredit/@totalGrossRevenueB"));
        System.out.println("[DA1]totalLumpSumTaxCredit:              " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfLumpSumTaxCredit/@totalLumpSumTaxCredit"));
        System.out.println("[DA1]totalAdditionalWithHoldingTaxUSA:   " + TaxStatementPDFToXML.getAttributeValue(doc, "/taxStatement/listOfLumpSumTaxCredit/@totalAdditionalWithHoldingTaxUSA"));
    }

    public static void main(String[] args) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            Date start = new Date();
            File file = new File(args[0]);
            if (!file.exists() || file.isDirectory()) {
                System.out.println("File " + args[0] + " not found!");
            }
            PDDocument pdd = PDDocument.load((File)file);
            Date load = new Date();
            System.out.println("[LOAD]    " + sdf.format(load) + ", " + (load.getTime() - start.getTime()) + " ms");
            byte[] xml = null;
            try {
                xml = TaxStatement.extractXML(pdd);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.setProperty("EXIT", "1");
            }
            Date extract = new Date();
            System.out.println("[EXTRACT] " + sdf.format(extract) + ", " + (extract.getTime() - load.getTime()) + " ms");
            try {
                FileOutputStream fos = new FileOutputStream(new File(new String(args.length > 1 ? (!args[1].endsWith(System.getProperty("file.separator")) ? args[1] : (!args[0].contains(System.getProperty("file.separator")) ? args[1] + args[0] : args[1] + args[0].substring(args[0].lastIndexOf(System.getProperty("file.separator")) + 1))) : args[0]).replace(".PDF", ".pdf").replace(".pdf", ".xml")));
                fos.write(xml);
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Date write = new Date();
            System.out.println("[WRITE]   " + sdf.format(write) + ", " + (write.getTime() - extract.getTime()) + " ms");
            String version = TaxStatement.getVersion(xml);
            System.out.println("[VERSION] " + version);
            if (TaxStatement.validateXML(xml)) {
                System.out.println("[XML]     Valid");
            } else {
                System.out.println("[XML]     Not valid!");
                System.out.println(TaxStatement.validateXMLMessage(xml));
                System.setProperty("EXIT", "1");
            }
            Date validate = new Date();
            System.out.println("[VALIDATE]" + sdf.format(validate) + ", " + (validate.getTime() - write.getTime()) + " ms");
            if (System.getProperty("verify", "false").equals("true")) {
                try {
                    System.out.println("[VERIFY]");
                    if (TaxStatement.verifyXML(xml)) {
                        System.out.println("XML: Signature passed core validation");
                    } else {
                        System.out.println("XML: Signature failed core validation");
                        System.setProperty("EXIT", "1");
                    }
                }
                catch (XMLSignatureException e) {
                    System.err.println(e.getMessage());
                    System.setProperty("EXIT", "1");
                }
            }
            if (System.getProperty("display", "false").equals("true")) {
                try {
                    System.out.println("[DISPLAY]");
                    TaxStatementPDFToXML.displayXML(xml);
                }
                catch (SAXParseException e) {
                    System.err.println(e.getMessage() + "\nline:   " + e.getLineNumber() + "\ncolumn: " + e.getColumnNumber());
                }
                catch (SAXException e) {
                    System.err.println(e.getMessage());
                }
            }
            if (System.getProperty("list", "false").equals("true")) {
                List<String> uniqueKeyList = TaxStatement.extractXMLUniqueKeyList(xml);
                String sep = "";
                System.out.println("[UNIQUE-KEY-LIST][" + sdf.format(TaxStatement.extractXMLReferenceDate(xml)) + "]");
                for (String uniqueKey : uniqueKeyList) {
                    System.out.print(sep + uniqueKey);
                    sep = ", ";
                }
                System.out.println(".");
                System.setProperty("EXIT", "1");
            }
            if (System.getProperty("id", "true").equals("true")) {
                String id;
                PDPageTree tree;
                Logger.getLogger("org.apache.pdfbox").setLevel(Level.SEVERE);
                boolean ech0196 = false;
                boolean ech0197 = false;
                if (pdd != null) {
                    tree = pdd.getPages();
                    for (int p = 0; !(p >= tree.getCount() || ech0196 && ech0197); ++p) {
                        id = TaxStatement.extractId(pdd, p);
                        if (id != null && id.length() == 16 && id.startsWith("196")) {
                            if (!ech0196) {
                                System.out.println("[BARCODE] " + id);
                            }
                            ech0196 = true;
                        }
                        if (id == null || id.length() != 16 || !id.startsWith("197")) continue;
                        if (!ech0197) {
                            System.out.println("[BARCODE] " + id);
                        }
                        ech0197 = true;
                    }
                }
                if (pdd != null && !ech0196) {
                    System.out.println("[BARCODE] 1D (196xxxxxxxxxxxxx) not found!");
                    tree = pdd.getPages();
                    for (int p = 0; p < tree.getCount(); ++p) {
                        id = TaxStatement.extractId(pdd, p);
                        System.out.println("[" + p + "]=" + id);
                    }
                    System.setProperty("EXIT", "1");
                }
                if (pdd != null && !ech0197 && version != null && version.compareTo(TaxStatement.VERSION_22) < 0) {
                    System.out.println("[BARCODE] 1D (197xxxxxxxxxxxxx) not found!");
                    tree = pdd.getPages();
                    for (int p = 0; p < tree.getCount(); ++p) {
                        id = TaxStatement.extractId(pdd, p);
                        System.out.println("[" + p + "]=" + id);
                    }
                    System.setProperty("EXIT", "1");
                }
            }
            pdd.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

