/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class TaxStatementPDFFont {
    public static final String ARIAL = "ArialMT";
    public static final String ARIAL_BOLD = "ArialMTBlack";
    public static final String CALIBRI = "Calibri";
    public static final String CALIBRI_BOLD = "Calibri-Bold";
    public static final String COURIER = "Courier";
    public static final String COURIER_BOLD = "Courier-Bold";
    public static final String COURIER_BOLD_OBLIQUE = "Courier-BoldOblique";
    public static final String COURIER_OBLIQUE = "Courier-Oblique";
    public static final String FRUTIGER = "Frutiger-Light";
    public static final String FRUTIGER_BOLD = "Frutiger-Bold";
    public static final String FRUTIGER45 = "Frutiger45Light";
    public static final String FRUTIGER45_BOLD = "Frutiger45LightBold";
    public static final String HELVETICA = "Helvetica";
    public static final String HELVETICA_BOLD = "Helvetica-Bold";
    public static final String HELVETICA_BOLD_OBLIQUE = "Helvetica-BoldOblique";
    public static final String HELVETICA_OBLIQUE = "Helvetica-Oblique";
    public static final String TIMES = "Times-Roman";
    public static final String TIMES_BOLD = "Times-Bold";
    public static final String TIMES_BOLD_ITALIC = "Times-BoldItalic";
    public static final String TIMES_ITALIC = "Times-Italic";

    public static PDFont get(PDDocument pdd, PDFont font, PDFont bold, PDFont search) throws IOException {
        String name = TaxStatementPDFFont.map(search);
        PDFont ft = null;
        if (name != null && name.length() > 0) {
            if (font != null && font.getName() != null && font.getName().equals(name)) {
                ft = font;
            } else if (bold != null && bold.getName() != null && bold.getName().equals(name)) {
                ft = bold;
            }
        }
        if (name != null && name.length() > 0 && pdd != null && ft == null) {
            for (PDPage page : pdd.getPages()) {
                PDResources resource;
                if (page == null || (resource = page.getResources()) == null) continue;
                for (COSName fontName : resource.getFontNames()) {
                    PDFont f = resource.getFont(fontName);
                    if (f == null || f.getName() == null || !f.getName().equals(name)) continue;
                    ft = f;
                }
            }
        }
        if (name != null && name.length() > 0 && pdd != null && ft == null) {
            if (name.equals(ARIAL)) {
                ft = TaxStatementPDFFont.load(pdd, "arial.ttf");
            } else if (name.equals(ARIAL_BOLD)) {
                ft = TaxStatementPDFFont.load(pdd, "arialb.ttf");
            } else if (name.equals(CALIBRI)) {
                ft = TaxStatementPDFFont.load(pdd, "calibri.ttf");
            } else if (name.equals(CALIBRI_BOLD)) {
                ft = TaxStatementPDFFont.load(pdd, "calibrib.ttf");
            } else if (name.equals(COURIER)) {
                ft = PDType1Font.COURIER;
            } else if (name.equals(COURIER_BOLD)) {
                ft = PDType1Font.COURIER_BOLD;
            } else if (name.equals(COURIER_BOLD_OBLIQUE)) {
                ft = PDType1Font.COURIER_BOLD_OBLIQUE;
            } else if (name.equals(COURIER_OBLIQUE)) {
                ft = PDType1Font.COURIER_OBLIQUE;
            } else if (name.equals(FRUTIGER)) {
                ft = TaxStatementPDFFont.load(pdd, "frutiger45light.ttf");
            } else if (name.equals(FRUTIGER_BOLD)) {
                ft = TaxStatementPDFFont.load(pdd, "frutiger45lightb.ttf");
            } else if (name.equals(FRUTIGER45)) {
                ft = TaxStatementPDFFont.load(pdd, "frutiger45light.ttf");
            } else if (name.equals(FRUTIGER45_BOLD)) {
                ft = TaxStatementPDFFont.load(pdd, "frutiger45lightb.ttf");
            } else if (name.equals(HELVETICA)) {
                ft = PDType1Font.HELVETICA;
            } else if (name.equals(HELVETICA_BOLD)) {
                ft = PDType1Font.HELVETICA_BOLD;
            } else if (name.equals(HELVETICA_BOLD_OBLIQUE)) {
                ft = PDType1Font.HELVETICA_BOLD_OBLIQUE;
            } else if (name.equals(HELVETICA_OBLIQUE)) {
                ft = PDType1Font.HELVETICA_OBLIQUE;
            } else if (name.equals(TIMES)) {
                ft = PDType1Font.TIMES_ROMAN;
            } else if (name.equals(TIMES_BOLD)) {
                ft = PDType1Font.TIMES_BOLD;
            } else if (name.equals(TIMES_BOLD_ITALIC)) {
                ft = PDType1Font.TIMES_BOLD_ITALIC;
            } else if (name.equals(TIMES_ITALIC)) {
                ft = PDType1Font.TIMES_ITALIC;
            }
        }
        return ft;
    }

    public static PDFont load(PDDocument pdd, String name) throws IOException {
        PDType0Font ft = null;
        if (name != null && name.length() > 0) {
            try {
                ft = PDType0Font.load((PDDocument)pdd, (InputStream)new FileInputStream(name), (boolean)false);
            }
            catch (Exception e) {
                try {
                    ft = PDType0Font.load((PDDocument)pdd, (InputStream)TaxStatementPDFFont.class.getResourceAsStream("/resources/fonts/" + name), (boolean)false);
                }
                catch (Exception e1) {
                    OTFParser parser = new OTFParser();
                    try {
                        ft = PDType0Font.load((PDDocument)pdd, (TrueTypeFont)parser.parse(new File(name)), (boolean)false);
                    }
                    catch (Exception e2) {
                        ft = PDType0Font.load((PDDocument)pdd, (TrueTypeFont)parser.parse(TaxStatementPDFFont.class.getResourceAsStream("/resources/fonts/" + name)), (boolean)false);
                    }
                }
            }
        }
        return ft;
    }

    public static String map(String search) {
        String name = null;
        if (search != null && search.length() > 0) {
            if (search.contains("Arial") && !search.contains("Black")) {
                name = ARIAL;
            } else if (search.contains("Arial") && search.contains("Black")) {
                name = ARIAL_BOLD;
            } else if (search.contains(CALIBRI) && !search.contains("Bold")) {
                name = CALIBRI;
            } else if (search.contains(CALIBRI) && search.contains("Bold")) {
                name = CALIBRI_BOLD;
            } else if (search.contains(COURIER) && !search.contains("Bold") && !search.contains("Oblique")) {
                name = COURIER;
            } else if (search.contains(COURIER) && search.contains("Bold") && !search.contains("Oblique")) {
                name = COURIER_BOLD;
            } else if (search.contains(COURIER) && search.contains("Bold") && search.contains("Oblique")) {
                name = COURIER_BOLD_OBLIQUE;
            } else if (search.contains(COURIER) && !search.contains("Bold") && search.contains("Oblique")) {
                name = COURIER_OBLIQUE;
            } else if (search.contains("Frutiger45") && !search.contains("Bold")) {
                name = FRUTIGER45;
            } else if (search.contains("Frutiger45") && search.contains("Bold")) {
                name = FRUTIGER45_BOLD;
            } else if (search.contains("Frutiger") && !search.contains("Bold")) {
                name = FRUTIGER;
            } else if (search.contains("Frutiger") && search.contains("Bold")) {
                name = FRUTIGER_BOLD;
            } else if (search.contains(HELVETICA) && !search.contains("Bold") && !search.contains("Oblique")) {
                name = HELVETICA;
            } else if (search.contains(HELVETICA) && search.contains("Bold") && !search.contains("Oblique")) {
                name = HELVETICA_BOLD;
            } else if (search.contains(HELVETICA) && search.contains("Bold") && search.contains("Oblique")) {
                name = HELVETICA_BOLD_OBLIQUE;
            } else if (search.contains(HELVETICA) && !search.contains("Bold") && search.contains("Oblique")) {
                name = HELVETICA_OBLIQUE;
            } else if (search.contains("Times") && !search.contains("Bold") && !search.contains("Italic")) {
                name = TIMES;
            } else if (search.contains("Times") && search.contains("Bold") && !search.contains("Italic")) {
                name = TIMES_BOLD;
            } else if (search.contains("Times") && search.contains("Bold") && search.contains("Italic")) {
                name = TIMES_BOLD_ITALIC;
            } else if (search.contains("Times") && !search.contains("Bold") && search.contains("Italic")) {
                name = TIMES_ITALIC;
            }
        }
        return name;
    }

    public static String map(PDFont search) {
        return TaxStatementPDFFont.map(search != null ? search.getName() : (String)null);
    }
}

