/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf;

import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import java.text.ParseException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class TaxStatementPDFFormula {
    private static String[] bs = new String[]{"AR", "SZ", "ZH"};
    private Document doc;
    private Double totalTaxValue = Double.NaN;
    private Double totalTaxValueBankAccount = Double.NaN;
    private Double totalTaxValueSecurity = Double.NaN;
    private Double totalTaxValueA = Double.NaN;
    private Double totalTaxValueABankAccount = Double.NaN;
    private Double totalTaxValueASecurity = Double.NaN;
    private Double totalTaxValueB = Double.NaN;
    private Double totalTaxValueBBankAccount = Double.NaN;
    private Double totalTaxValueBSecurity = Double.NaN;
    private Double totalTaxValueDA1 = Double.NaN;
    private Double totalTaxValueUSA = Double.NaN;
    private Double totalTaxValueOther = Double.NaN;
    private Double totalTaxValueCrypto = Double.NaN;
    private Double totalTaxValueLiability = Double.NaN;
    private Double totalGrossRevenueA = Double.NaN;
    private Double totalGrossRevenueABankAccount = Double.NaN;
    private Double totalGrossRevenueASecurity = Double.NaN;
    private Double totalGrossRevenueB = Double.NaN;
    private Double totalGrossRevenueBBonus = Double.NaN;
    private Double totalGrossRevenueBBankAccount = Double.NaN;
    private Double totalGrossRevenueBSecurity = Double.NaN;
    private Double totalGrossRevenueDA1 = Double.NaN;
    private Double totalGrossRevenueDA1Bonus = Double.NaN;
    private Double totalGrossRevenueUSA = Double.NaN;
    private Double totalGrossRevenueUSABonus = Double.NaN;
    private Double totalGrossRevenueACrypto = Double.NaN;
    private Double totalGrossRevenueBCrypto = Double.NaN;
    private Double totalGrossRevenueAIUP = Double.NaN;
    private Double totalGrossRevenueAIUPPositive = Double.NaN;
    private Double totalGrossRevenueAIUPNegative = Double.NaN;
    private Double totalGrossRevenueBIUP = Double.NaN;
    private Double totalGrossRevenueBIUPPositive = Double.NaN;
    private Double totalGrossRevenueBIUPNegative = Double.NaN;
    private Double totalLumpSumTaxCreditAmount = Double.NaN;
    private Double totalNonRecoverableTaxAmount = Double.NaN;
    private Double totalAdditionalWithHoldingTaxUSA = Double.NaN;
    private Double totalWithHoldingTaxClaim = Double.NaN;
    private Double totalWithHoldingTaxClaimBankAccount = Double.NaN;
    private Double totalWithHoldingTaxClaimSecurity = Double.NaN;
    private Double totalWithHoldingTaxClaimIUP = Double.NaN;
    private Double totalWithHoldingTaxClaimIUPPositive = Double.NaN;
    private Double totalWithHoldingTaxClaimIUPNegative = Double.NaN;
    private Double totalLendingFee = Double.NaN;
    private Double totalRetrocession = Double.NaN;
    private Double totalGrossRevenueBLiability = Double.NaN;
    private Double totalExpense = Double.NaN;
    private Double totalExpenseDeductible = Double.NaN;
    private Double totalExpenseDeductibleCanton = Double.NaN;

    public Double getTotalTaxValueBankAccount() throws XPathExpressionException {
        if (this.totalTaxValueBankAccount != null && this.totalTaxValueBankAccount.isNaN()) {
            this.totalTaxValueBankAccount = null;
            this.totalTaxValueABankAccount = null;
            this.totalTaxValueBBankAccount = null;
            for (int account = 1; account <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount)"); ++account) {
                Double totalTaxValue;
                boolean isTaxValueA = false;
                boolean isTaxValueB = false;
                String country = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@bankAccountCountry");
                Double totalGrossRevenueA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalGrossRevenueA");
                Double totalGrossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalGrossRevenueB");
                Double totalWithHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalWithHoldingTaxClaim");
                boolean isA = this.isGrossRevenueA(totalGrossRevenueA, totalGrossRevenueB, totalWithHoldingTaxClaim);
                boolean isB = this.isGrossRevenueB(totalGrossRevenueA, totalGrossRevenueB, totalWithHoldingTaxClaim);
                if (!isA && !isB) {
                    if (country != null && country.equals("CH")) {
                        isA = true;
                    }
                    if (country != null && !country.equals("CH")) {
                        isB = true;
                    }
                }
                if (!isA && !isB) {
                    isB = true;
                }
                if (isA) {
                    isTaxValueA = isA;
                }
                if (isB) {
                    isTaxValueB = isB;
                }
                if ((totalTaxValue = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalTaxValue")) == null) continue;
                this.totalTaxValueBankAccount = TaxStatementPDFUtil.nvl(this.totalTaxValueBankAccount, 0.0) + totalTaxValue;
                if (isTaxValueA) {
                    this.totalTaxValueABankAccount = TaxStatementPDFUtil.nvl(this.totalTaxValueABankAccount, 0.0) + totalTaxValue;
                }
                if (isTaxValueA || !isTaxValueB) continue;
                this.totalTaxValueBBankAccount = TaxStatementPDFUtil.nvl(this.totalTaxValueBBankAccount, 0.0) + totalTaxValue;
            }
            this.totalTaxValueBankAccount = TaxStatementPDFUtil.round(this.totalTaxValueBankAccount);
            this.totalTaxValueABankAccount = TaxStatementPDFUtil.round(this.totalTaxValueABankAccount);
            this.totalTaxValueBBankAccount = TaxStatementPDFUtil.round(this.totalTaxValueBBankAccount);
        }
        return this.totalTaxValueBankAccount;
    }

    public Double getTotalTaxValueABankAccount() throws ParseException, XPathExpressionException {
        if (this.totalTaxValueABankAccount != null && this.totalTaxValueABankAccount.isNaN()) {
            this.totalTaxValueABankAccount = null;
            for (int account = 1; account <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount)"); ++account) {
                Double totalTaxValue;
                boolean isTaxValueA = false;
                boolean isTaxValueB = false;
                String country = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@bankAccountCountry");
                Double totalGrossRevenueA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalGrossRevenueA");
                Double totalGrossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalGrossRevenueB");
                Double totalWithHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalWithHoldingTaxClaim");
                boolean isA = this.isGrossRevenueA(totalGrossRevenueA, totalGrossRevenueB, totalWithHoldingTaxClaim);
                boolean isB = this.isGrossRevenueB(totalGrossRevenueA, totalGrossRevenueB, totalWithHoldingTaxClaim);
                if (!isA && !isB) {
                    if (country != null && country.equals("CH")) {
                        isA = true;
                    }
                    if (country != null && !country.equals("CH")) {
                        isB = true;
                    }
                }
                if (!isA && !isB) {
                    isB = true;
                }
                if (isA) {
                    isTaxValueA = isA;
                }
                if (isB) {
                    isTaxValueB = isB;
                }
                if ((totalTaxValue = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalTaxValue")) == null || !isTaxValueA) continue;
                this.totalTaxValueABankAccount = TaxStatementPDFUtil.nvl(this.totalTaxValueABankAccount, 0.0) + totalTaxValue;
            }
            this.totalTaxValueABankAccount = TaxStatementPDFUtil.round(this.totalTaxValueABankAccount);
        }
        return this.totalTaxValueABankAccount;
    }

    public Double getTotalTaxValueBBankAccount() throws ParseException, XPathExpressionException {
        if (this.totalTaxValueBBankAccount != null && this.totalTaxValueBBankAccount.isNaN()) {
            this.totalTaxValueBBankAccount = null;
            for (int account = 1; account <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount)"); ++account) {
                Double totalTaxValue;
                boolean isTaxValueA = false;
                boolean isTaxValueB = false;
                String country = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@bankAccountCountry");
                Double totalGrossRevenueA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalGrossRevenueA");
                Double totalGrossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalGrossRevenueB");
                Double totalWithHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalWithHoldingTaxClaim");
                boolean isA = this.isGrossRevenueA(totalGrossRevenueA, totalGrossRevenueB, totalWithHoldingTaxClaim);
                boolean isB = this.isGrossRevenueB(totalGrossRevenueA, totalGrossRevenueB, totalWithHoldingTaxClaim);
                if (!isA && !isB) {
                    if (country != null && country.equals("CH")) {
                        isA = true;
                    }
                    if (country != null && !country.equals("CH")) {
                        isB = true;
                    }
                }
                if (!isA && !isB) {
                    isB = true;
                }
                if (isA) {
                    isTaxValueA = isA;
                }
                if (isB) {
                    isTaxValueB = isB;
                }
                if ((totalTaxValue = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalTaxValue")) == null || isTaxValueA || !isTaxValueB) continue;
                this.totalTaxValueBBankAccount = TaxStatementPDFUtil.nvl(this.totalTaxValueBBankAccount, 0.0) + totalTaxValue;
            }
            this.totalTaxValueBBankAccount = TaxStatementPDFUtil.round(this.totalTaxValueBBankAccount);
        }
        return this.totalTaxValueBBankAccount;
    }

    public Double getTotalGrossRevenueABankAccount() throws XPathExpressionException {
        if (this.totalGrossRevenueABankAccount != null && this.totalGrossRevenueABankAccount.isNaN()) {
            this.totalGrossRevenueABankAccount = null;
            if (TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount)") > 0) {
                this.totalGrossRevenueABankAccount = TaxStatementPDFUtil.round(TaxStatementPDFUtil.getValueNumber(this.doc, "sum(/taxStatement/listOfBankAccounts/bankAccount/payment/@grossRevenueA)"));
            }
        }
        return this.totalGrossRevenueABankAccount;
    }

    public Double getTotalGrossRevenueBBankAccount() throws XPathExpressionException {
        if (this.totalGrossRevenueBBankAccount != null && this.totalGrossRevenueBBankAccount.isNaN()) {
            this.totalGrossRevenueBBankAccount = null;
            if (TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount)") > 0) {
                this.totalGrossRevenueBBankAccount = TaxStatementPDFUtil.round(TaxStatementPDFUtil.getValueNumber(this.doc, "sum(/taxStatement/listOfBankAccounts/bankAccount/payment/@grossRevenueB)"));
            }
        }
        return this.totalGrossRevenueBBankAccount;
    }

    public Double getTotalWithHoldingTaxClaimBankAccount() throws XPathExpressionException {
        if (this.totalWithHoldingTaxClaimBankAccount != null && this.totalWithHoldingTaxClaimBankAccount.isNaN()) {
            this.totalWithHoldingTaxClaimBankAccount = null;
            if (TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfBankAccounts/bankAccount)") > 0) {
                this.totalWithHoldingTaxClaimBankAccount = TaxStatementPDFUtil.round(TaxStatementPDFUtil.getValueNumber(this.doc, "sum(/taxStatement/listOfBankAccounts/bankAccount/payment/@withHoldingTaxClaim)"));
            }
        }
        return this.totalWithHoldingTaxClaimBankAccount;
    }

    public Double getTotalWithHoldingTaxClaimBankAccount(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalWithHoldingTaxClaim");
    }

    public Double getTotalExpense() throws XPathExpressionException {
        if (this.totalExpense != null && this.totalExpense.isNaN()) {
            this.totalExpense = null;
            if (TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfExpenses/expense)") > 0) {
                this.totalExpense = TaxStatementPDFUtil.round(TaxStatementPDFUtil.getValueNumber(this.doc, "sum(/taxStatement/listOfExpenses/expense/@expenses)"));
            }
        }
        return this.totalExpense;
    }

    public Double getTotalExpense(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/@totalExpenses");
    }

    public Double getTotalExpenseDeductible() throws XPathExpressionException {
        if (this.totalExpenseDeductible != null && this.totalExpenseDeductible.isNaN()) {
            this.totalExpenseDeductible = null;
            if (TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfExpenses/expense)") > 0) {
                this.totalExpenseDeductible = TaxStatementPDFUtil.round(TaxStatementPDFUtil.getValueNumber(this.doc, "sum(/taxStatement/listOfExpenses/expense/@expensesDeductible)"));
            }
        }
        return this.totalExpenseDeductible;
    }

    public Double getTotalExpenseDeductible(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/@totalExpensesDeductible");
    }

    public Double getTotalExpenseDeductibleCanton() throws XPathExpressionException {
        if (this.totalExpenseDeductibleCanton != null && this.totalExpenseDeductibleCanton.isNaN()) {
            this.totalExpenseDeductibleCanton = null;
            int expenses = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfExpenses/expense)");
            for (int expense = 1; expense <= expenses; ++expense) {
                Double expenseDeductible = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@expensesDeductible");
                Double expenseDeductibleCanton = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfExpenses/expense[" + expense + "]/@expensesDeductibleCanton"), expenseDeductible);
                if (expenseDeductibleCanton == null) continue;
                this.totalExpenseDeductibleCanton = TaxStatementPDFUtil.nvl(this.totalExpenseDeductibleCanton, 0.0) + expenseDeductibleCanton;
            }
            this.totalExpenseDeductibleCanton = TaxStatementPDFUtil.round(this.totalExpenseDeductibleCanton);
        }
        return this.totalExpenseDeductibleCanton;
    }

    public Double getTotalExpenseDeductibleCanton(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfExpenses/@totalExpensesDeductibleCanton");
    }

    public Double getTotalTaxValueLiability() throws XPathExpressionException {
        if (this.totalTaxValueLiability != null && this.totalTaxValueLiability.isNaN()) {
            this.totalTaxValueLiability = null;
            if (TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfLiabilities/liabilityAccount)") > 0) {
                this.totalTaxValueLiability = TaxStatementPDFUtil.round(TaxStatementPDFUtil.getValueNumber(this.doc, "sum(/taxStatement/listOfLiabilities/liabilityAccount/taxValue/@value)"));
            }
        }
        return this.totalTaxValueLiability;
    }

    public Double getTotalTaxValueLiability(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/@totalTaxValue");
    }

    public Double getTotalGrossRevenueBLiability() throws XPathExpressionException {
        if (this.totalGrossRevenueBLiability != null && this.totalGrossRevenueBLiability.isNaN()) {
            this.totalGrossRevenueBLiability = null;
            if (TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfLiabilities/liabilityAccount)") > 0) {
                this.totalGrossRevenueBLiability = TaxStatementPDFUtil.round(TaxStatementPDFUtil.getValueNumber(this.doc, "sum(/taxStatement/listOfLiabilities/liabilityAccount/payment/@grossRevenueB)"));
            }
        }
        return this.totalGrossRevenueBLiability;
    }

    public Double getTotalGrossRevenueBLiability(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/@totalGrossRevenueB");
    }

    public Double getTotalTaxValueSecurity() throws ParseException, XPathExpressionException {
        if (this.totalTaxValueSecurity != null && this.totalTaxValueSecurity.isNaN()) {
            this.totalTaxValueSecurity = null;
            this.totalTaxValueASecurity = null;
            this.totalTaxValueBSecurity = null;
            this.totalTaxValueDA1 = null;
            this.totalTaxValueUSA = null;
            this.totalTaxValueOther = null;
            this.totalTaxValueCrypto = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    Double taxValue;
                    boolean isTaxValueA = false;
                    boolean isTaxValueB = false;
                    boolean isTaxValueDA1 = false;
                    boolean isTaxValueUSA = false;
                    String category = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                    String country = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@country");
                    for (int payment = 1; payment <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)"); ++payment) {
                        Double grossRevenueA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        Double withHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim");
                        Boolean lumpSumTaxCredit = TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCredit");
                        Double nonRecoverableTaxAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                        Double additionalWithHoldingTaxUSA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                        boolean isA = this.isGrossRevenueA(grossRevenueA, grossRevenueB, withHoldingTaxClaim);
                        boolean isB = this.isGrossRevenueB(grossRevenueA, grossRevenueB, withHoldingTaxClaim);
                        boolean isDA1 = this.isGrossRevenueDA1(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        boolean isUSA = this.isGrossRevenueUSA(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        if (!(isA || isB || isDA1 || isUSA)) {
                            if (country != null && country.equals("CH")) {
                                isA = true;
                            }
                            if (country != null && !country.equals("CH")) {
                                isB = true;
                            }
                        } else if (!isA && !isB && (isDA1 || isUSA)) {
                            isB = true;
                        }
                        if (!isA && !isB) {
                            isB = true;
                        }
                        if (isA) {
                            isTaxValueA = isA;
                        }
                        if (isB) {
                            isTaxValueB = isB;
                        }
                        if (isDA1) {
                            isTaxValueDA1 = isDA1;
                        }
                        if (!isUSA) continue;
                        isTaxValueUSA = isUSA;
                    }
                    if (!(isTaxValueA || isTaxValueB || isTaxValueDA1 || isTaxValueUSA)) {
                        if (country != null && country.equals("CH")) {
                            isTaxValueA = true;
                        }
                        if (country != null && !country.equals("CH")) {
                            isTaxValueB = true;
                        }
                    } else if (!isTaxValueA && !isTaxValueB && (isTaxValueDA1 || isTaxValueUSA)) {
                        isTaxValueB = true;
                    }
                    if (!isTaxValueA && !isTaxValueB) {
                        isTaxValueB = true;
                    }
                    if ((taxValue = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value")) != null && category != null && !category.equals("COINBULL")) {
                        this.totalTaxValueSecurity = TaxStatementPDFUtil.nvl(this.totalTaxValueSecurity, 0.0) + taxValue;
                        if (isTaxValueA) {
                            this.totalTaxValueASecurity = TaxStatementPDFUtil.nvl(this.totalTaxValueASecurity, 0.0) + taxValue;
                        }
                        if (!isTaxValueA && isTaxValueB && !isTaxValueDA1 && !isTaxValueUSA) {
                            this.totalTaxValueBSecurity = TaxStatementPDFUtil.nvl(this.totalTaxValueBSecurity, 0.0) + taxValue;
                        }
                        if (!isTaxValueA && isTaxValueB && isTaxValueDA1 && !isTaxValueUSA) {
                            this.totalTaxValueDA1 = TaxStatementPDFUtil.nvl(this.totalTaxValueDA1, 0.0) + taxValue;
                        }
                        if (!isTaxValueA && isTaxValueB && isTaxValueDA1 && isTaxValueUSA) {
                            this.totalTaxValueUSA = TaxStatementPDFUtil.nvl(this.totalTaxValueUSA, 0.0) + taxValue;
                        }
                    }
                    if (taxValue != null && category != null && category.equals("COINBULL")) {
                        this.totalTaxValueOther = TaxStatementPDFUtil.nvl(this.totalTaxValueOther, 0.0) + taxValue;
                    }
                    if (taxValue == null || category == null || !category.equals("CURRNOTE")) continue;
                    this.totalTaxValueCrypto = TaxStatementPDFUtil.nvl(this.totalTaxValueCrypto, 0.0) + taxValue;
                }
            }
            this.totalTaxValueSecurity = TaxStatementPDFUtil.round(this.totalTaxValueSecurity);
            this.totalTaxValueASecurity = TaxStatementPDFUtil.round(this.totalTaxValueASecurity);
            this.totalTaxValueBSecurity = TaxStatementPDFUtil.round(this.totalTaxValueBSecurity);
            this.totalTaxValueDA1 = TaxStatementPDFUtil.round(this.totalTaxValueDA1);
            this.totalTaxValueUSA = TaxStatementPDFUtil.round(this.totalTaxValueUSA);
            this.totalTaxValueOther = TaxStatementPDFUtil.round(this.totalTaxValueOther);
            this.totalTaxValueCrypto = TaxStatementPDFUtil.round(this.totalTaxValueCrypto);
        }
        return this.totalTaxValueSecurity;
    }

    public Double getTotalTaxValueASecurity() throws ParseException, XPathExpressionException {
        if (this.totalTaxValueASecurity != null && this.totalTaxValueASecurity.isNaN()) {
            this.totalTaxValueASecurity = null;
            for (int depot = 1; depot <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)"); ++depot) {
                for (int security = 1; security <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)"); ++security) {
                    Double taxValue;
                    boolean isTaxValueA = false;
                    boolean isTaxValueB = false;
                    boolean isTaxValueDA1 = false;
                    boolean isTaxValueUSA = false;
                    String category = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                    String country = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@country");
                    for (int payment = 1; payment <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)"); ++payment) {
                        Double grossRevenueA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        Double withHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim");
                        Boolean lumpSumTaxCredit = TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCredit");
                        Double nonRecoverableTaxAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                        Double additionalWithHoldingTaxUSA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                        boolean isA = this.isGrossRevenueA(grossRevenueA, grossRevenueB, withHoldingTaxClaim);
                        boolean isB = this.isGrossRevenueB(grossRevenueA, grossRevenueB, withHoldingTaxClaim);
                        boolean isDA1 = this.isGrossRevenueDA1(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        boolean isUSA = this.isGrossRevenueUSA(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        if (!(isA || isB || isDA1 || isUSA)) {
                            if (country != null && country.equals("CH")) {
                                isA = true;
                            }
                            if (country != null && !country.equals("CH")) {
                                isB = true;
                            }
                        } else if (!isA && !isB && (isDA1 || isUSA)) {
                            isB = true;
                        }
                        if (!isA && !isB) {
                            isB = true;
                        }
                        if (isA) {
                            isTaxValueA = isA;
                        }
                        if (isB) {
                            isTaxValueB = isB;
                        }
                        if (isDA1) {
                            isTaxValueDA1 = isDA1;
                        }
                        if (!isUSA) continue;
                        isTaxValueUSA = isUSA;
                    }
                    if (!(isTaxValueA || isTaxValueB || isTaxValueDA1 || isTaxValueUSA)) {
                        if (country != null && country.equals("CH")) {
                            isTaxValueA = true;
                        }
                        if (country != null && !country.equals("CH")) {
                            isTaxValueB = true;
                        }
                    } else if (!isTaxValueA && !isTaxValueB && (isTaxValueDA1 || isTaxValueUSA)) {
                        isTaxValueB = true;
                    }
                    if (!isTaxValueA && !isTaxValueB) {
                        isTaxValueB = true;
                    }
                    if ((taxValue = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value")) == null || category == null || category.equals("COINBULL") || !isTaxValueA) continue;
                    this.totalTaxValueASecurity = TaxStatementPDFUtil.nvl(this.totalTaxValueASecurity, 0.0) + taxValue;
                }
            }
            this.totalTaxValueASecurity = TaxStatementPDFUtil.round(this.totalTaxValueASecurity);
        }
        return this.totalTaxValueASecurity;
    }

    public Double getTotalTaxValueBSecurity() throws ParseException, XPathExpressionException {
        if (this.totalTaxValueBSecurity != null && this.totalTaxValueBSecurity.isNaN()) {
            this.totalTaxValueBSecurity = null;
            for (int depot = 1; depot <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)"); ++depot) {
                for (int security = 1; security <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)"); ++security) {
                    Double taxValue;
                    boolean isTaxValueA = false;
                    boolean isTaxValueB = false;
                    boolean isTaxValueDA1 = false;
                    boolean isTaxValueUSA = false;
                    String category = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                    String country = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@country");
                    for (int payment = 1; payment <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)"); ++payment) {
                        Double grossRevenueA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        Double withHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim");
                        Boolean lumpSumTaxCredit = TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCredit");
                        Double nonRecoverableTaxAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                        Double additionalWithHoldingTaxUSA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                        boolean isA = this.isGrossRevenueA(grossRevenueA, grossRevenueB, withHoldingTaxClaim);
                        boolean isB = this.isGrossRevenueB(grossRevenueA, grossRevenueB, withHoldingTaxClaim);
                        boolean isDA1 = this.isGrossRevenueDA1(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        boolean isUSA = this.isGrossRevenueUSA(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        if (!(isA || isB || isDA1 || isUSA)) {
                            if (country != null && country.equals("CH")) {
                                isA = true;
                            }
                            if (country != null && !country.equals("CH")) {
                                isB = true;
                            }
                        } else if (!isA && !isB && (isDA1 || isUSA)) {
                            isB = true;
                        }
                        if (!isA && !isB) {
                            isB = true;
                        }
                        if (isA) {
                            isTaxValueA = isA;
                        }
                        if (isB) {
                            isTaxValueB = isB;
                        }
                        if (isDA1) {
                            isTaxValueDA1 = isDA1;
                        }
                        if (!isUSA) continue;
                        isTaxValueUSA = isUSA;
                    }
                    if (!(isTaxValueA || isTaxValueB || isTaxValueDA1 || isTaxValueUSA)) {
                        if (country != null && country.equals("CH")) {
                            isTaxValueA = true;
                        }
                        if (country != null && !country.equals("CH")) {
                            isTaxValueB = true;
                        }
                    } else if (!isTaxValueA && !isTaxValueB && (isTaxValueDA1 || isTaxValueUSA)) {
                        isTaxValueB = true;
                    }
                    if (!isTaxValueA && !isTaxValueB) {
                        isTaxValueB = true;
                    }
                    if ((taxValue = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value")) == null || category == null || category.equals("COINBULL") || isTaxValueA || !isTaxValueB || isTaxValueDA1 || isTaxValueUSA) continue;
                    this.totalTaxValueBSecurity = TaxStatementPDFUtil.nvl(this.totalTaxValueBSecurity, 0.0) + taxValue;
                }
            }
            this.totalTaxValueBSecurity = TaxStatementPDFUtil.round(this.totalTaxValueBSecurity);
        }
        return this.totalTaxValueBSecurity;
    }

    public Double getTotalTaxValueDA1() throws ParseException, XPathExpressionException {
        if (this.totalTaxValueDA1 != null && this.totalTaxValueDA1.isNaN()) {
            this.totalTaxValueDA1 = null;
            for (int depot = 1; depot <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)"); ++depot) {
                for (int security = 1; security <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)"); ++security) {
                    Double taxValue;
                    boolean isTaxValueA = false;
                    boolean isTaxValueB = false;
                    boolean isTaxValueDA1 = false;
                    boolean isTaxValueUSA = false;
                    String category = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                    String country = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@country");
                    for (int payment = 1; payment <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)"); ++payment) {
                        Double grossRevenueA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        Double withHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim");
                        Boolean lumpSumTaxCredit = TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCredit");
                        Double nonRecoverableTaxAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                        Double additionalWithHoldingTaxUSA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                        boolean isA = this.isGrossRevenueA(grossRevenueA, grossRevenueB, withHoldingTaxClaim);
                        boolean isB = this.isGrossRevenueB(grossRevenueA, grossRevenueB, withHoldingTaxClaim);
                        boolean isDA1 = this.isGrossRevenueDA1(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        boolean isUSA = this.isGrossRevenueUSA(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        if (!(isA || isB || isDA1 || isUSA)) {
                            if (country != null && country.equals("CH")) {
                                isA = true;
                            }
                            if (country != null && !country.equals("CH")) {
                                isB = true;
                            }
                        } else if (!isA && !isB && (isDA1 || isUSA)) {
                            isB = true;
                        }
                        if (!isA && !isB) {
                            isB = true;
                        }
                        if (isA) {
                            isTaxValueA = isA;
                        }
                        if (isB) {
                            isTaxValueB = isB;
                        }
                        if (isDA1) {
                            isTaxValueDA1 = isDA1;
                        }
                        if (!isUSA) continue;
                        isTaxValueUSA = isUSA;
                    }
                    if (!(isTaxValueA || isTaxValueB || isTaxValueDA1 || isTaxValueUSA)) {
                        if (country != null && country.equals("CH")) {
                            isTaxValueA = true;
                        }
                        if (country != null && !country.equals("CH")) {
                            isTaxValueB = true;
                        }
                    } else if (!isTaxValueA && !isTaxValueB && (isTaxValueDA1 || isTaxValueUSA)) {
                        isTaxValueB = true;
                    }
                    if (!isTaxValueA && !isTaxValueB) {
                        isTaxValueB = true;
                    }
                    if ((taxValue = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value")) == null || category == null || category.equals("COINBULL") || isTaxValueA || !isTaxValueB || !isTaxValueDA1 || isTaxValueUSA) continue;
                    this.totalTaxValueDA1 = TaxStatementPDFUtil.nvl(this.totalTaxValueDA1, 0.0) + taxValue;
                }
            }
            this.totalTaxValueDA1 = TaxStatementPDFUtil.round(this.totalTaxValueDA1);
        }
        return this.totalTaxValueDA1;
    }

    public Double getTotalTaxValueUSA() throws ParseException, XPathExpressionException {
        if (this.totalTaxValueUSA != null && this.totalTaxValueUSA.isNaN()) {
            this.totalTaxValueUSA = null;
            for (int depot = 1; depot <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)"); ++depot) {
                for (int security = 1; security <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)"); ++security) {
                    Double taxValue;
                    boolean isTaxValueA = false;
                    boolean isTaxValueB = false;
                    boolean isTaxValueDA1 = false;
                    boolean isTaxValueUSA = false;
                    String category = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                    String country = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@country");
                    for (int payment = 1; payment <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)"); ++payment) {
                        Double grossRevenueA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        Double withHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim");
                        Boolean lumpSumTaxCredit = TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCredit");
                        Double nonRecoverableTaxAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                        Double additionalWithHoldingTaxUSA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                        boolean isA = this.isGrossRevenueA(grossRevenueA, grossRevenueB, withHoldingTaxClaim);
                        boolean isB = this.isGrossRevenueB(grossRevenueA, grossRevenueB, withHoldingTaxClaim);
                        boolean isDA1 = this.isGrossRevenueDA1(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        boolean isUSA = this.isGrossRevenueUSA(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        if (!(isA || isB || isDA1 || isUSA)) {
                            if (country != null && country.equals("CH")) {
                                isA = true;
                            }
                            if (country != null && !country.equals("CH")) {
                                isB = true;
                            }
                        } else if (!isA && !isB && (isDA1 || isUSA)) {
                            isB = true;
                        }
                        if (!isA && !isB) {
                            isB = true;
                        }
                        if (isA) {
                            isTaxValueA = isA;
                        }
                        if (isB) {
                            isTaxValueB = isB;
                        }
                        if (isDA1) {
                            isTaxValueDA1 = isDA1;
                        }
                        if (!isUSA) continue;
                        isTaxValueUSA = isUSA;
                    }
                    if (!(isTaxValueA || isTaxValueB || isTaxValueDA1 || isTaxValueUSA)) {
                        if (country != null && country.equals("CH")) {
                            isTaxValueA = true;
                        }
                        if (country != null && !country.equals("CH")) {
                            isTaxValueB = true;
                        }
                    } else if (!isTaxValueA && !isTaxValueB && (isTaxValueDA1 || isTaxValueUSA)) {
                        isTaxValueB = true;
                    }
                    if (!isTaxValueA && !isTaxValueB) {
                        isTaxValueB = true;
                    }
                    if ((taxValue = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value")) == null || category == null || category.equals("COINBULL") || isTaxValueA || !isTaxValueB || !isTaxValueDA1 || !isTaxValueUSA) continue;
                    this.totalTaxValueUSA = TaxStatementPDFUtil.nvl(this.totalTaxValueUSA, 0.0) + taxValue;
                }
            }
            this.totalTaxValueUSA = TaxStatementPDFUtil.round(this.totalTaxValueUSA);
        }
        return this.totalTaxValueUSA;
    }

    public Double getTotalTaxValueOther() throws ParseException, XPathExpressionException {
        if (this.totalTaxValueOther != null && this.totalTaxValueOther.isNaN()) {
            this.totalTaxValueOther = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    String category = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                    Double taxValue = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value");
                    if (taxValue == null || category == null || !category.equals("COINBULL")) continue;
                    this.totalTaxValueOther = TaxStatementPDFUtil.nvl(this.totalTaxValueOther, 0.0) + taxValue;
                }
            }
            this.totalTaxValueOther = TaxStatementPDFUtil.round(this.totalTaxValueOther);
        }
        return this.totalTaxValueOther;
    }

    public Double getTotalTaxValueCrypto() throws ParseException, XPathExpressionException {
        if (this.totalTaxValueCrypto != null && this.totalTaxValueCrypto.isNaN()) {
            this.totalTaxValueCrypto = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    String category = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                    Double taxValue = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue/@value");
                    if (taxValue == null || category == null || !category.equals("CURRNOTE")) continue;
                    boolean lending = false;
                    boolean retro = false;
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments && !lending && !retro; ++payment) {
                        lending = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lendingFee"), false);
                        retro = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@retrocession"), false);
                    }
                    if (lending || retro) continue;
                    this.totalTaxValueCrypto = TaxStatementPDFUtil.nvl(this.totalTaxValueCrypto, 0.0) + taxValue;
                }
            }
            this.totalTaxValueCrypto = TaxStatementPDFUtil.round(this.totalTaxValueCrypto);
        }
        return this.totalTaxValueCrypto;
    }

    public Double getTotalGrossRevenueASecurity() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueASecurity != null && this.totalGrossRevenueASecurity.isNaN()) {
            this.totalGrossRevenueASecurity = null;
            this.totalGrossRevenueAIUP = null;
            this.totalGrossRevenueAIUPPositive = null;
            this.totalGrossRevenueAIUPNegative = null;
            this.totalGrossRevenueACrypto = null;
            this.totalWithHoldingTaxClaimSecurity = null;
            this.totalWithHoldingTaxClaimIUP = null;
            this.totalWithHoldingTaxClaimIUPPositive = null;
            this.totalWithHoldingTaxClaimIUPNegative = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    String category = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Double withHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim");
                        Boolean iup = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (grossRevenueA != null && (grossRevenueA >= 0.0 || !iup.booleanValue())) {
                            this.totalGrossRevenueASecurity = TaxStatementPDFUtil.nvl(this.totalGrossRevenueASecurity, 0.0) + grossRevenueA;
                        }
                        if (grossRevenueA != null && iup.booleanValue()) {
                            this.totalGrossRevenueAIUP = TaxStatementPDFUtil.nvl(this.totalGrossRevenueAIUP, 0.0) + grossRevenueA;
                        }
                        if (grossRevenueA != null && grossRevenueA >= 0.0 && iup.booleanValue()) {
                            this.totalGrossRevenueAIUPPositive = TaxStatementPDFUtil.nvl(this.totalGrossRevenueAIUPPositive, 0.0) + grossRevenueA;
                        }
                        if (grossRevenueA != null && grossRevenueA < 0.0 && iup.booleanValue()) {
                            this.totalGrossRevenueAIUPNegative = TaxStatementPDFUtil.nvl(this.totalGrossRevenueAIUPNegative, 0.0) + grossRevenueA;
                        }
                        if (grossRevenueA != null && category != null && category.equals("CURRNOTE")) {
                            this.totalGrossRevenueACrypto = TaxStatementPDFUtil.nvl(this.totalGrossRevenueACrypto, 0.0) + grossRevenueA;
                        }
                        if (withHoldingTaxClaim != null && (withHoldingTaxClaim >= 0.0 || !iup.booleanValue())) {
                            this.totalWithHoldingTaxClaimSecurity = TaxStatementPDFUtil.nvl(this.totalWithHoldingTaxClaimSecurity, 0.0) + withHoldingTaxClaim;
                        }
                        if (withHoldingTaxClaim != null && iup.booleanValue()) {
                            this.totalWithHoldingTaxClaimIUP = TaxStatementPDFUtil.nvl(this.totalWithHoldingTaxClaimIUP, 0.0) + withHoldingTaxClaim;
                        }
                        if (withHoldingTaxClaim != null && withHoldingTaxClaim >= 0.0 && iup.booleanValue()) {
                            this.totalWithHoldingTaxClaimIUPPositive = TaxStatementPDFUtil.nvl(this.totalWithHoldingTaxClaimIUPPositive, 0.0) + withHoldingTaxClaim;
                        }
                        if (withHoldingTaxClaim == null || !(withHoldingTaxClaim < 0.0) || !iup.booleanValue()) continue;
                        this.totalWithHoldingTaxClaimIUPNegative = TaxStatementPDFUtil.nvl(this.totalWithHoldingTaxClaimIUPNegative, 0.0) + withHoldingTaxClaim;
                    }
                }
            }
            this.totalGrossRevenueASecurity = TaxStatementPDFUtil.round(this.totalGrossRevenueASecurity);
            this.totalGrossRevenueAIUP = TaxStatementPDFUtil.round(this.totalGrossRevenueAIUP);
            this.totalGrossRevenueAIUPPositive = TaxStatementPDFUtil.round(this.totalGrossRevenueAIUPPositive);
            this.totalGrossRevenueAIUPNegative = TaxStatementPDFUtil.round(this.totalGrossRevenueAIUPNegative);
            this.totalGrossRevenueACrypto = TaxStatementPDFUtil.round(this.totalGrossRevenueACrypto);
            this.totalWithHoldingTaxClaimSecurity = TaxStatementPDFUtil.round(this.totalWithHoldingTaxClaimSecurity);
            this.totalWithHoldingTaxClaimIUP = TaxStatementPDFUtil.round(this.totalWithHoldingTaxClaimIUP);
            this.totalWithHoldingTaxClaimIUPPositive = TaxStatementPDFUtil.round(this.totalWithHoldingTaxClaimIUPPositive);
            this.totalWithHoldingTaxClaimIUPNegative = TaxStatementPDFUtil.round(this.totalWithHoldingTaxClaimIUPNegative);
        }
        return this.totalGrossRevenueASecurity;
    }

    public Double getTotalGrossRevenueAIUP() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueAIUP != null && this.totalGrossRevenueAIUP.isNaN()) {
            this.totalGrossRevenueAIUP = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Boolean iup = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (grossRevenueA == null || !iup.booleanValue()) continue;
                        this.totalGrossRevenueAIUP = TaxStatementPDFUtil.nvl(this.totalGrossRevenueAIUP, 0.0) + grossRevenueA;
                    }
                }
            }
            this.totalGrossRevenueAIUP = TaxStatementPDFUtil.round(this.totalGrossRevenueAIUP);
        }
        return this.totalGrossRevenueAIUP;
    }

    public Double getTotalGrossRevenueAIUPPositive() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueAIUPPositive != null && this.totalGrossRevenueAIUPPositive.isNaN()) {
            this.totalGrossRevenueAIUPPositive = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Boolean iup = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (grossRevenueA == null || !(grossRevenueA >= 0.0) || !iup.booleanValue()) continue;
                        this.totalGrossRevenueAIUPPositive = TaxStatementPDFUtil.nvl(this.totalGrossRevenueAIUPPositive, 0.0) + grossRevenueA;
                    }
                }
            }
            this.totalGrossRevenueAIUPPositive = TaxStatementPDFUtil.round(this.totalGrossRevenueAIUPPositive);
        }
        return this.totalGrossRevenueAIUPPositive;
    }

    public Double getTotalGrossRevenueAIUPNegative() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueAIUPNegative != null && this.totalGrossRevenueAIUPNegative.isNaN()) {
            this.totalGrossRevenueAIUPNegative = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        Boolean iup = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (grossRevenueA == null || !(grossRevenueA < 0.0) || !iup.booleanValue()) continue;
                        this.totalGrossRevenueAIUPNegative = TaxStatementPDFUtil.nvl(this.totalGrossRevenueAIUPNegative, 0.0) + grossRevenueA;
                    }
                }
            }
            this.totalGrossRevenueAIUPNegative = TaxStatementPDFUtil.round(this.totalGrossRevenueAIUPNegative);
        }
        return this.totalGrossRevenueAIUPNegative;
    }

    public Double getTotalGrossRevenueACrypto() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueACrypto != null && this.totalGrossRevenueACrypto.isNaN()) {
            this.totalGrossRevenueACrypto = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    String category = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                    for (int payment = 1; payment <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)"); ++payment) {
                        Double grossRevenueA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
                        boolean lending = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lendingFee"), false);
                        boolean retro = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@retrocession"), false);
                        if (grossRevenueA == null || category == null || !category.equals("CURRNOTE") || lending || retro) continue;
                        this.totalGrossRevenueACrypto = TaxStatementPDFUtil.nvl(this.totalGrossRevenueACrypto, 0.0) + grossRevenueA;
                    }
                }
            }
            this.totalGrossRevenueACrypto = TaxStatementPDFUtil.round(this.totalGrossRevenueACrypto);
        }
        return this.totalGrossRevenueACrypto;
    }

    public Double getTotalGrossRevenueBSecurity() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueBSecurity != null && this.totalGrossRevenueBSecurity.isNaN()) {
            this.totalGrossRevenueBSecurity = null;
            this.totalGrossRevenueBBonus = null;
            this.totalGrossRevenueDA1 = null;
            this.totalGrossRevenueDA1Bonus = null;
            this.totalGrossRevenueUSA = null;
            this.totalGrossRevenueUSABonus = null;
            this.totalGrossRevenueBIUP = null;
            this.totalGrossRevenueBIUPPositive = null;
            this.totalGrossRevenueBIUPNegative = null;
            this.totalGrossRevenueBCrypto = null;
            this.totalLumpSumTaxCreditAmount = null;
            this.totalNonRecoverableTaxAmount = null;
            this.totalAdditionalWithHoldingTaxUSA = null;
            this.totalLendingFee = null;
            this.totalRetrocession = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    String category = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        Boolean lumpSumTaxCredit = TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCredit");
                        Double lumpSumTaxCreditAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCreditAmount");
                        Double nonRecoverableTaxAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                        Double additionalWithHoldingTaxUSA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                        boolean iup = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        boolean lending = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lendingFee"), false);
                        boolean retro = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@retrocession"), false);
                        Boolean bonus = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@gratis"), false);
                        boolean isDA1 = this.isGrossRevenueDA1(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        boolean isUSA = this.isGrossRevenueUSA(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        if (!(grossRevenueB == null || !(grossRevenueB >= 0.0) && iup || lending || retro || isDA1 || isUSA)) {
                            this.totalGrossRevenueBSecurity = TaxStatementPDFUtil.nvl(this.totalGrossRevenueBSecurity, 0.0) + grossRevenueB;
                        }
                        if (!(grossRevenueB == null || !(grossRevenueB >= 0.0) && iup || lending || retro || isDA1 || isUSA || !bonus.booleanValue())) {
                            this.totalGrossRevenueBBonus = TaxStatementPDFUtil.nvl(this.totalGrossRevenueBBonus, 0.0) + grossRevenueB;
                        }
                        if (grossRevenueB != null && isDA1 && !isUSA) {
                            this.totalGrossRevenueDA1 = TaxStatementPDFUtil.nvl(this.totalGrossRevenueDA1, 0.0) + grossRevenueB;
                        }
                        if (grossRevenueB != null && isDA1 && !isUSA && bonus.booleanValue()) {
                            this.totalGrossRevenueDA1Bonus = TaxStatementPDFUtil.nvl(this.totalGrossRevenueDA1Bonus, 0.0) + grossRevenueB;
                        }
                        if (grossRevenueB != null && isDA1 && isUSA) {
                            this.totalGrossRevenueUSA = TaxStatementPDFUtil.nvl(this.totalGrossRevenueUSA, 0.0) + grossRevenueB;
                        }
                        if (grossRevenueB != null && isDA1 && isUSA && bonus.booleanValue()) {
                            this.totalGrossRevenueUSABonus = TaxStatementPDFUtil.nvl(this.totalGrossRevenueUSABonus, 0.0) + grossRevenueB;
                        }
                        if (grossRevenueB != null && iup) {
                            this.totalGrossRevenueBIUP = TaxStatementPDFUtil.nvl(this.totalGrossRevenueBIUP, 0.0) + grossRevenueB;
                        }
                        if (grossRevenueB != null && grossRevenueB >= 0.0 && iup) {
                            this.totalGrossRevenueBIUPPositive = TaxStatementPDFUtil.nvl(this.totalGrossRevenueBIUPPositive, 0.0) + grossRevenueB;
                        }
                        if (grossRevenueB != null && grossRevenueB < 0.0 && iup) {
                            this.totalGrossRevenueBIUPNegative = TaxStatementPDFUtil.nvl(this.totalGrossRevenueBIUPNegative, 0.0) + grossRevenueB;
                        }
                        if (grossRevenueB != null && category != null && category.equals("CURRNOTE") && !lending && !retro) {
                            this.totalGrossRevenueBCrypto = TaxStatementPDFUtil.nvl(this.totalGrossRevenueBCrypto, 0.0) + grossRevenueB;
                        }
                        if (lumpSumTaxCreditAmount != null) {
                            this.totalLumpSumTaxCreditAmount = TaxStatementPDFUtil.nvl(this.totalLumpSumTaxCreditAmount, 0.0) + lumpSumTaxCreditAmount;
                        }
                        if (nonRecoverableTaxAmount != null) {
                            this.totalNonRecoverableTaxAmount = TaxStatementPDFUtil.nvl(this.totalNonRecoverableTaxAmount, 0.0) + nonRecoverableTaxAmount;
                        }
                        if (additionalWithHoldingTaxUSA != null) {
                            this.totalAdditionalWithHoldingTaxUSA = TaxStatementPDFUtil.nvl(this.totalAdditionalWithHoldingTaxUSA, 0.0) + additionalWithHoldingTaxUSA;
                        }
                        if (grossRevenueB != null && grossRevenueB >= 0.0 && lending) {
                            this.totalLendingFee = TaxStatementPDFUtil.nvl(this.totalLendingFee, 0.0) + grossRevenueB;
                        }
                        if (grossRevenueB == null || !(grossRevenueB >= 0.0) || !retro) continue;
                        this.totalRetrocession = TaxStatementPDFUtil.nvl(this.totalRetrocession, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalGrossRevenueBSecurity = TaxStatementPDFUtil.round(this.totalGrossRevenueBSecurity);
            this.totalGrossRevenueBBonus = TaxStatementPDFUtil.round(this.totalGrossRevenueBBonus);
            this.totalGrossRevenueDA1 = TaxStatementPDFUtil.round(this.totalGrossRevenueDA1);
            this.totalGrossRevenueDA1Bonus = TaxStatementPDFUtil.round(this.totalGrossRevenueDA1Bonus);
            this.totalGrossRevenueUSA = TaxStatementPDFUtil.round(this.totalGrossRevenueUSA);
            this.totalGrossRevenueUSABonus = TaxStatementPDFUtil.round(this.totalGrossRevenueUSABonus);
            this.totalGrossRevenueBIUP = TaxStatementPDFUtil.round(this.totalGrossRevenueBIUP);
            this.totalGrossRevenueBIUPPositive = TaxStatementPDFUtil.round(this.totalGrossRevenueBIUPPositive);
            this.totalGrossRevenueBIUPNegative = TaxStatementPDFUtil.round(this.totalGrossRevenueBIUPNegative);
            this.totalGrossRevenueBCrypto = TaxStatementPDFUtil.round(this.totalGrossRevenueBCrypto);
            this.totalLumpSumTaxCreditAmount = TaxStatementPDFUtil.round(this.totalLumpSumTaxCreditAmount);
            this.totalNonRecoverableTaxAmount = TaxStatementPDFUtil.round(this.totalNonRecoverableTaxAmount);
            this.totalAdditionalWithHoldingTaxUSA = TaxStatementPDFUtil.round(this.totalAdditionalWithHoldingTaxUSA);
            this.totalLendingFee = TaxStatementPDFUtil.round(this.totalLendingFee);
            this.totalRetrocession = TaxStatementPDFUtil.round(this.totalRetrocession);
        }
        return this.totalGrossRevenueBSecurity;
    }

    public Double getTotalGrossRevenueBBonus() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueBBonus != null && this.totalGrossRevenueBBonus.isNaN()) {
            this.totalGrossRevenueBBonus = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        Boolean lumpSumTaxCredit = TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCredit");
                        Double nonRecoverableTaxAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                        Double additionalWithHoldingTaxUSA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                        boolean iup = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        boolean lending = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lendingFee"), false);
                        boolean retro = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@retrocession"), false);
                        Boolean bonus = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@gratis"), false);
                        boolean isDA1 = this.isGrossRevenueDA1(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        boolean isUSA = this.isGrossRevenueUSA(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        if (grossRevenueB == null || !(grossRevenueB >= 0.0) && iup || lending || retro || isDA1 || isUSA || !bonus.booleanValue()) continue;
                        this.totalGrossRevenueBBonus = TaxStatementPDFUtil.nvl(this.totalGrossRevenueBBonus, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalGrossRevenueBBonus = TaxStatementPDFUtil.round(this.totalGrossRevenueBBonus);
        }
        return this.totalGrossRevenueBBonus;
    }

    public Double getTotalGrossRevenueDA1() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueDA1 != null && this.totalGrossRevenueDA1.isNaN()) {
            this.totalGrossRevenueDA1 = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        Boolean lumpSumTaxCredit = TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCredit");
                        Double nonRecoverableTaxAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                        Double additionalWithHoldingTaxUSA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                        Boolean bonus = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@gratis"), false);
                        boolean isDA1 = this.isGrossRevenueDA1(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        boolean isUSA = this.isGrossRevenueUSA(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        if (grossRevenueB == null || !isDA1 || isUSA) continue;
                        this.totalGrossRevenueDA1 = TaxStatementPDFUtil.nvl(this.totalGrossRevenueDA1, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalGrossRevenueDA1 = TaxStatementPDFUtil.round(this.totalGrossRevenueDA1);
        }
        return this.totalGrossRevenueDA1;
    }

    public Double getTotalGrossRevenueDA1Bonus() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueDA1Bonus != null && this.totalGrossRevenueDA1Bonus.isNaN()) {
            this.totalGrossRevenueDA1Bonus = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        Boolean lumpSumTaxCredit = TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCredit");
                        Double nonRecoverableTaxAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                        Double additionalWithHoldingTaxUSA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                        Boolean bonus = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@gratis"), false);
                        boolean isDA1 = this.isGrossRevenueDA1(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        boolean isUSA = this.isGrossRevenueUSA(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        if (grossRevenueB == null || !isDA1 || isUSA || !bonus.booleanValue()) continue;
                        this.totalGrossRevenueDA1Bonus = TaxStatementPDFUtil.nvl(this.totalGrossRevenueDA1Bonus, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalGrossRevenueDA1Bonus = TaxStatementPDFUtil.round(this.totalGrossRevenueDA1Bonus);
        }
        return this.totalGrossRevenueDA1Bonus;
    }

    public Double getTotalGrossRevenueUSA() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueUSA != null && this.totalGrossRevenueUSA.isNaN()) {
            this.totalGrossRevenueUSA = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        Boolean lumpSumTaxCredit = TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCredit");
                        Double nonRecoverableTaxAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                        Double additionalWithHoldingTaxUSA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                        Boolean bonus = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@gratis"), false);
                        boolean isDA1 = this.isGrossRevenueDA1(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        boolean isUSA = this.isGrossRevenueUSA(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        if (grossRevenueB == null || !isDA1 || !isUSA) continue;
                        this.totalGrossRevenueUSA = TaxStatementPDFUtil.nvl(this.totalGrossRevenueUSA, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalGrossRevenueUSA = TaxStatementPDFUtil.round(this.totalGrossRevenueUSA);
        }
        return this.totalGrossRevenueUSA;
    }

    public Double getTotalGrossRevenueUSABonus() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueUSABonus != null && this.totalGrossRevenueUSABonus.isNaN()) {
            this.totalGrossRevenueUSABonus = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        Boolean lumpSumTaxCredit = TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCredit");
                        Double nonRecoverableTaxAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                        Double additionalWithHoldingTaxUSA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                        Boolean bonus = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@gratis"), false);
                        boolean isDA1 = this.isGrossRevenueDA1(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        boolean isUSA = this.isGrossRevenueUSA(lumpSumTaxCredit, nonRecoverableTaxAmount, additionalWithHoldingTaxUSA);
                        if (grossRevenueB == null || !isDA1 || !isUSA || !bonus.booleanValue()) continue;
                        this.totalGrossRevenueUSABonus = TaxStatementPDFUtil.nvl(this.totalGrossRevenueUSABonus, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalGrossRevenueUSABonus = TaxStatementPDFUtil.round(this.totalGrossRevenueUSABonus);
        }
        return this.totalGrossRevenueUSABonus;
    }

    public Double getTotalGrossRevenueBIUP() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueBIUP != null && this.totalGrossRevenueBIUP.isNaN()) {
            this.totalGrossRevenueBIUP = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        boolean iup = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (grossRevenueB == null || !iup) continue;
                        this.totalGrossRevenueBIUP = TaxStatementPDFUtil.nvl(this.totalGrossRevenueBIUP, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalGrossRevenueBIUP = TaxStatementPDFUtil.round(this.totalGrossRevenueBIUP);
        }
        return this.totalGrossRevenueBIUP;
    }

    public Double getTotalGrossRevenueBIUPPositive() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueBIUPPositive != null && this.totalGrossRevenueBIUPPositive.isNaN()) {
            this.totalGrossRevenueBIUPPositive = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        boolean iup = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (grossRevenueB == null || !(grossRevenueB >= 0.0) || !iup) continue;
                        this.totalGrossRevenueBIUPPositive = TaxStatementPDFUtil.nvl(this.totalGrossRevenueBIUPPositive, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalGrossRevenueBIUPPositive = TaxStatementPDFUtil.round(this.totalGrossRevenueBIUPPositive);
        }
        return this.totalGrossRevenueBIUPPositive;
    }

    public Double getTotalGrossRevenueBIUPNegative() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueBIUPNegative != null && this.totalGrossRevenueBIUPNegative.isNaN()) {
            this.totalGrossRevenueBIUPNegative = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        boolean iup = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (grossRevenueB == null || !(grossRevenueB < 0.0) || !iup) continue;
                        this.totalGrossRevenueBIUPNegative = TaxStatementPDFUtil.nvl(this.totalGrossRevenueBIUPNegative, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalGrossRevenueBIUPNegative = TaxStatementPDFUtil.round(this.totalGrossRevenueBIUPNegative);
        }
        return this.totalGrossRevenueBIUPNegative;
    }

    public Double getTotalGrossRevenueBCrypto() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueBCrypto != null && this.totalGrossRevenueBCrypto.isNaN()) {
            this.totalGrossRevenueBCrypto = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    String category = TaxStatementPDFUtil.getValue(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
                    for (int payment = 1; payment <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)"); ++payment) {
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        boolean lending = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lendingFee"), false);
                        boolean retro = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@retrocession"), false);
                        if (grossRevenueB == null || category == null || !category.equals("CURRNOTE") || lending || retro) continue;
                        this.totalGrossRevenueBCrypto = TaxStatementPDFUtil.nvl(this.totalGrossRevenueBCrypto, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalGrossRevenueBCrypto = TaxStatementPDFUtil.round(this.totalGrossRevenueBCrypto);
        }
        return this.totalGrossRevenueBCrypto;
    }

    public Double getTotalLumpSumTaxCreditAmount() throws ParseException, XPathExpressionException {
        if (this.totalLumpSumTaxCreditAmount != null && this.totalLumpSumTaxCreditAmount.isNaN()) {
            this.totalLumpSumTaxCreditAmount = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    for (int payment = 1; payment <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)"); ++payment) {
                        Double lumpSumTaxCreditAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCreditAmount");
                        if (lumpSumTaxCreditAmount == null) continue;
                        this.totalLumpSumTaxCreditAmount = TaxStatementPDFUtil.nvl(this.totalLumpSumTaxCreditAmount, 0.0) + lumpSumTaxCreditAmount;
                    }
                }
            }
            this.totalLumpSumTaxCreditAmount = TaxStatementPDFUtil.round(this.totalLumpSumTaxCreditAmount);
        }
        return this.totalLumpSumTaxCreditAmount;
    }

    public Double getTotalLumpSumTaxCredit(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalLumpSumTaxCredit");
    }

    public Double getTotalNonRecoverableTaxAmount() throws ParseException, XPathExpressionException {
        if (this.totalNonRecoverableTaxAmount != null && this.totalNonRecoverableTaxAmount.isNaN()) {
            this.totalNonRecoverableTaxAmount = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    for (int payment = 1; payment <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)"); ++payment) {
                        Double nonRecoverableTaxAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                        if (nonRecoverableTaxAmount == null) continue;
                        this.totalNonRecoverableTaxAmount = TaxStatementPDFUtil.nvl(this.totalNonRecoverableTaxAmount, 0.0) + nonRecoverableTaxAmount;
                    }
                }
            }
            this.totalNonRecoverableTaxAmount = TaxStatementPDFUtil.round(this.totalNonRecoverableTaxAmount);
        }
        return this.totalNonRecoverableTaxAmount;
    }

    public Double getTotalNonRecoverableTax(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalNonRecoverableTax");
    }

    public Double getTotalRecoverableTaxAmount() throws ParseException, XPathExpressionException {
        Double totalLumpSumTaxCreditAmount = null;
        Double totalNonRecoverableTaxAmount = null;
        Double totalRecoverableTaxAmount = null;
        int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots; ++depot) {
            int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
            for (int security = 1; security <= securities; ++security) {
                for (int payment = 1; payment <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)"); ++payment) {
                    Double lumpSumTaxCreditAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCreditAmount");
                    Double nonRecoverableTaxAmount = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
                    if (lumpSumTaxCreditAmount != null) {
                        totalLumpSumTaxCreditAmount = TaxStatementPDFUtil.nvl(totalLumpSumTaxCreditAmount, 0.0) + lumpSumTaxCreditAmount;
                    }
                    if (nonRecoverableTaxAmount == null) continue;
                    totalNonRecoverableTaxAmount = TaxStatementPDFUtil.nvl(totalNonRecoverableTaxAmount, 0.0) + nonRecoverableTaxAmount;
                }
            }
        }
        if (totalLumpSumTaxCreditAmount != null && !totalLumpSumTaxCreditAmount.isNaN() || totalNonRecoverableTaxAmount != null && !totalNonRecoverableTaxAmount.isNaN()) {
            totalRecoverableTaxAmount = TaxStatementPDFUtil.nvl(totalLumpSumTaxCreditAmount, 0.0) - TaxStatementPDFUtil.nvl(totalNonRecoverableTaxAmount, 0.0);
        }
        return TaxStatementPDFUtil.round(totalRecoverableTaxAmount);
    }

    public Double getTotalRecoverableTax(Document doc) throws ParseException, XPathExpressionException {
        Double totalLumpSumTaxCredit = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalLumpSumTaxCredit");
        Double totalNonRecoverableTax = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalNonRecoverableTax");
        Double totalRecoverableTax = null;
        if (totalLumpSumTaxCredit != null && !totalLumpSumTaxCredit.isNaN() || totalNonRecoverableTax != null && !totalNonRecoverableTax.isNaN()) {
            totalRecoverableTax = TaxStatementPDFUtil.nvl(totalLumpSumTaxCredit, 0.0) - TaxStatementPDFUtil.nvl(totalNonRecoverableTax, 0.0);
        }
        return totalRecoverableTax;
    }

    public Double getTotalAdditionalWithHoldingTaxUSA() throws ParseException, XPathExpressionException {
        if (this.totalAdditionalWithHoldingTaxUSA != null && this.totalAdditionalWithHoldingTaxUSA.isNaN()) {
            this.totalAdditionalWithHoldingTaxUSA = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    for (int payment = 1; payment <= TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)"); ++payment) {
                        Double additionalWithHoldingTaxUSA = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
                        if (additionalWithHoldingTaxUSA == null) continue;
                        this.totalAdditionalWithHoldingTaxUSA = TaxStatementPDFUtil.nvl(this.totalAdditionalWithHoldingTaxUSA, 0.0) + additionalWithHoldingTaxUSA;
                    }
                }
            }
            this.totalAdditionalWithHoldingTaxUSA = TaxStatementPDFUtil.round(this.totalAdditionalWithHoldingTaxUSA);
        }
        return this.totalAdditionalWithHoldingTaxUSA;
    }

    public Double getTotalAdditionalWithHoldingTaxUSA(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalAdditionalWithHoldingTaxUSA");
    }

    public Double getTotalLendingFee() throws ParseException, XPathExpressionException {
        if (this.totalLendingFee != null && this.totalLendingFee.isNaN()) {
            this.totalLendingFee = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        boolean lending = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lendingFee"), false);
                        if (grossRevenueB == null || !(grossRevenueB >= 0.0) || !lending) continue;
                        this.totalLendingFee = TaxStatementPDFUtil.nvl(this.totalLendingFee, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalLendingFee = TaxStatementPDFUtil.round(this.totalLendingFee);
        }
        return this.totalLendingFee;
    }

    public Double getTotalRetrocession() throws ParseException, XPathExpressionException {
        if (this.totalRetrocession != null && this.totalRetrocession.isNaN()) {
            this.totalRetrocession = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double grossRevenueB = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
                        boolean retro = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@retrocession"), false);
                        boolean lumpSumTaxCredit = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCredit"), false);
                        if (grossRevenueB == null || !(grossRevenueB >= 0.0) || !retro || lumpSumTaxCredit) continue;
                        this.totalRetrocession = TaxStatementPDFUtil.nvl(this.totalRetrocession, 0.0) + grossRevenueB;
                    }
                }
            }
            this.totalRetrocession = TaxStatementPDFUtil.round(this.totalRetrocession);
        }
        return this.totalRetrocession;
    }

    public Double getTotalWithHoldingTaxClaimSecurity() throws ParseException, XPathExpressionException {
        if (this.totalWithHoldingTaxClaimSecurity != null && this.totalWithHoldingTaxClaimSecurity.isNaN()) {
            this.totalWithHoldingTaxClaimSecurity = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double withHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim");
                        Boolean iup = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (withHoldingTaxClaim == null || !(withHoldingTaxClaim >= 0.0) && iup.booleanValue()) continue;
                        this.totalWithHoldingTaxClaimSecurity = TaxStatementPDFUtil.nvl(this.totalWithHoldingTaxClaimSecurity, 0.0) + withHoldingTaxClaim;
                    }
                }
            }
            this.totalWithHoldingTaxClaimSecurity = TaxStatementPDFUtil.round(this.totalWithHoldingTaxClaimSecurity);
        }
        return this.totalWithHoldingTaxClaimSecurity;
    }

    public Double getTotalWithHoldingTaxClaimSecurity(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/@totalWithHoldingTaxClaim");
    }

    public Double getTotalWithHoldingTaxClaimIUP() throws ParseException, XPathExpressionException {
        if (this.totalWithHoldingTaxClaimIUP != null && this.totalWithHoldingTaxClaimIUP.isNaN()) {
            this.totalWithHoldingTaxClaimIUP = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double withHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim");
                        Boolean iup = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (withHoldingTaxClaim == null || !iup.booleanValue()) continue;
                        this.totalWithHoldingTaxClaimIUP = TaxStatementPDFUtil.nvl(this.totalWithHoldingTaxClaimIUP, 0.0) + withHoldingTaxClaim;
                    }
                }
            }
            this.totalWithHoldingTaxClaimIUP = TaxStatementPDFUtil.round(this.totalWithHoldingTaxClaimIUP);
        }
        return this.totalWithHoldingTaxClaimIUP;
    }

    public Double getTotalWithHoldingTaxClaimIUPPositive() throws ParseException, XPathExpressionException {
        if (this.totalWithHoldingTaxClaimIUPPositive != null && this.totalWithHoldingTaxClaimIUPPositive.isNaN()) {
            this.totalWithHoldingTaxClaimIUPPositive = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double withHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim");
                        Boolean iup = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (withHoldingTaxClaim == null || !(withHoldingTaxClaim >= 0.0) || !iup.booleanValue()) continue;
                        this.totalWithHoldingTaxClaimIUPPositive = TaxStatementPDFUtil.nvl(this.totalWithHoldingTaxClaimIUPPositive, 0.0) + withHoldingTaxClaim;
                    }
                }
            }
            this.totalWithHoldingTaxClaimIUPPositive = TaxStatementPDFUtil.round(this.totalWithHoldingTaxClaimIUPPositive);
        }
        return this.totalWithHoldingTaxClaimIUPPositive;
    }

    public Double getTotalWithHoldingTaxClaimIUPNegative() throws ParseException, XPathExpressionException {
        if (this.totalWithHoldingTaxClaimIUPNegative != null && this.totalWithHoldingTaxClaimIUPNegative.isNaN()) {
            this.totalWithHoldingTaxClaimIUPNegative = null;
            int depots = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot)");
            for (int depot = 1; depot <= depots; ++depot) {
                int securities = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
                for (int security = 1; security <= securities; ++security) {
                    int payments = TaxStatementPDFUtil.getCount(this.doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
                    for (int payment = 1; payment <= payments; ++payment) {
                        Double withHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim");
                        Boolean iup = TaxStatementPDFUtil.nvl(TaxStatementPDFUtil.getValueBoolean(this.doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup"), false);
                        if (withHoldingTaxClaim == null || !(withHoldingTaxClaim < 0.0) || !iup.booleanValue()) continue;
                        this.totalWithHoldingTaxClaimIUPNegative = TaxStatementPDFUtil.nvl(this.totalWithHoldingTaxClaimIUPNegative, 0.0) + withHoldingTaxClaim;
                    }
                }
            }
            this.totalWithHoldingTaxClaimIUPNegative = TaxStatementPDFUtil.round(this.totalWithHoldingTaxClaimIUPNegative);
        }
        return this.totalWithHoldingTaxClaimIUPNegative;
    }

    public Double getTotalTaxValue() throws ParseException, XPathExpressionException {
        if (this.totalTaxValue != null && this.totalTaxValue.isNaN()) {
            Double totalTaxValueBankAccount = this.getTotalTaxValueBankAccount();
            Double totalTaxValueSecurity = this.getTotalTaxValueSecurity();
            this.totalTaxValue = totalTaxValueBankAccount != null || totalTaxValueSecurity != null ? Double.valueOf(TaxStatementPDFUtil.nvl(totalTaxValueBankAccount, 0.0) + TaxStatementPDFUtil.nvl(totalTaxValueSecurity, 0.0)) : null;
        }
        return this.totalTaxValue;
    }

    public Double getTotalTaxValueA() throws ParseException, XPathExpressionException {
        if (this.totalTaxValueA != null && this.totalTaxValueA.isNaN()) {
            Double totalTaxValueABankAccount = this.getTotalTaxValueABankAccount();
            Double totalTaxValueASecurity = this.getTotalTaxValueASecurity();
            this.totalTaxValueA = totalTaxValueABankAccount != null || totalTaxValueASecurity != null ? Double.valueOf(TaxStatementPDFUtil.nvl(totalTaxValueABankAccount, 0.0) + TaxStatementPDFUtil.nvl(totalTaxValueASecurity, 0.0)) : null;
        }
        return this.totalTaxValueA;
    }

    public Double getTotalTaxValueB() throws ParseException, XPathExpressionException {
        if (this.totalTaxValueB != null && this.totalTaxValueB.isNaN()) {
            Double totalTaxValueBBankAccount = this.getTotalTaxValueBBankAccount();
            Double totalTaxValueBSecurity = this.getTotalTaxValueBSecurity();
            this.totalTaxValueB = totalTaxValueBBankAccount != null || totalTaxValueBSecurity != null ? Double.valueOf(TaxStatementPDFUtil.nvl(totalTaxValueBBankAccount, 0.0) + TaxStatementPDFUtil.nvl(totalTaxValueBSecurity, 0.0)) : null;
        }
        return this.totalTaxValueB;
    }

    public Double getTotalTaxValueAAndB(boolean decimal) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.add(decimal ? TaxStatementPDFUtil.round(this.getTotalTaxValueA()) : TaxStatementPDFUtil.round(this.getTotalTaxValueA(), 0), decimal ? TaxStatementPDFUtil.round(this.getTotalTaxValueB()) : TaxStatementPDFUtil.round(this.getTotalTaxValueB(), 0));
    }

    public Double getTotalTaxValueAAndBAndDA1AndUSA(boolean decimal) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.add(TaxStatementPDFUtil.add(TaxStatementPDFUtil.add(decimal ? TaxStatementPDFUtil.round(this.getTotalTaxValueA()) : TaxStatementPDFUtil.round(this.getTotalTaxValueA(), 0), decimal ? TaxStatementPDFUtil.round(this.getTotalTaxValueB()) : TaxStatementPDFUtil.round(this.getTotalTaxValueB(), 0)), decimal ? TaxStatementPDFUtil.round(this.getTotalTaxValueDA1()) : TaxStatementPDFUtil.round(this.getTotalTaxValueDA1(), 0)), decimal ? TaxStatementPDFUtil.round(this.getTotalTaxValueUSA()) : TaxStatementPDFUtil.round(this.getTotalTaxValueUSA(), 0));
    }

    public Double getTotalTaxValueAAndBAndDA1AndUSA(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/@totalTaxValue");
    }

    public Double getTotalTaxValueDA1AndUSA(boolean decimal) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.add(decimal ? TaxStatementPDFUtil.round(this.getTotalTaxValueDA1()) : TaxStatementPDFUtil.round(this.getTotalTaxValueDA1(), 0), decimal ? TaxStatementPDFUtil.round(this.getTotalTaxValueUSA()) : TaxStatementPDFUtil.round(this.getTotalTaxValueUSA(), 0));
    }

    public Double getTotalGrossRevenueA() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueA != null && this.totalGrossRevenueA.isNaN()) {
            Double totalGrossRevenueABankAccount = this.getTotalGrossRevenueABankAccount();
            Double totalGrossRevenueASecurity = this.getTotalGrossRevenueASecurity();
            this.totalGrossRevenueA = totalGrossRevenueABankAccount != null || totalGrossRevenueASecurity != null ? Double.valueOf(TaxStatementPDFUtil.nvl(totalGrossRevenueABankAccount, 0.0) + TaxStatementPDFUtil.nvl(totalGrossRevenueASecurity, 0.0)) : null;
        }
        return this.totalGrossRevenueA;
    }

    public Double getTotalGrossRevenueA(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/@totalGrossRevenueA");
    }

    public Double getTotalGrossRevenueB() throws ParseException, XPathExpressionException {
        if (this.totalGrossRevenueB != null && this.totalGrossRevenueB.isNaN()) {
            Double totalBankAccountGrossRevenueB = this.getTotalGrossRevenueBBankAccount();
            Double totalSecurityGrossRevenueB = this.getTotalGrossRevenueBSecurity();
            this.totalGrossRevenueB = this.totalGrossRevenueBBankAccount != null || this.totalGrossRevenueBSecurity != null ? Double.valueOf(TaxStatementPDFUtil.nvl(this.totalGrossRevenueBBankAccount, 0.0) + TaxStatementPDFUtil.nvl(this.totalGrossRevenueBSecurity, 0.0)) : null;
        }
        return this.totalGrossRevenueB;
    }

    public Double getTotalGrossRevenueBBonus(Document doc) throws ParseException, XPathExpressionException {
        return this.isBonus(doc) ? this.getTotalGrossRevenueBBonus() : null;
    }

    public Double getTotalGrossRevenueAAndB() throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.add(TaxStatementPDFUtil.round(this.getTotalGrossRevenueA()), TaxStatementPDFUtil.round(this.getTotalGrossRevenueB()));
    }

    public Double getTotalGrossRevenueAAndBAndDA1AndUSA() throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.add(TaxStatementPDFUtil.add(TaxStatementPDFUtil.add(TaxStatementPDFUtil.round(this.getTotalGrossRevenueA()), TaxStatementPDFUtil.round(this.getTotalGrossRevenueB())), TaxStatementPDFUtil.round(this.getTotalGrossRevenueDA1())), TaxStatementPDFUtil.round(this.getTotalGrossRevenueUSA()));
    }

    public Double getTotalGrossRevenueBAndDA1AndUSA() throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.add(TaxStatementPDFUtil.add(TaxStatementPDFUtil.round(this.getTotalGrossRevenueB()), TaxStatementPDFUtil.round(this.getTotalGrossRevenueDA1())), TaxStatementPDFUtil.round(this.getTotalGrossRevenueUSA()));
    }

    public Double getTotalGrossRevenueBAndDA1AndUSA(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/@totalGrossRevenueB");
    }

    public Double getTotalGrossRevenueDA1AndUSA() throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.add(TaxStatementPDFUtil.round(this.getTotalGrossRevenueDA1()), TaxStatementPDFUtil.round(this.getTotalGrossRevenueUSA()));
    }

    public Double getTotalGrossRevenueDA1Bonus(Document doc) throws ParseException, XPathExpressionException {
        return this.isBonus(doc) ? this.getTotalGrossRevenueDA1Bonus() : null;
    }

    public Double getTotalGrossRevenueUSABonus(Document doc) throws ParseException, XPathExpressionException {
        return this.isBonus(doc) ? this.getTotalGrossRevenueUSABonus() : null;
    }

    public Double getTotalGrossRevenueDA1AndUSABonus() throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.add(TaxStatementPDFUtil.round(this.getTotalGrossRevenueDA1Bonus()), TaxStatementPDFUtil.round(this.getTotalGrossRevenueUSABonus()));
    }

    public Double getTotalGrossRevenueDA1AndUSABonus(Document doc) throws ParseException, XPathExpressionException {
        return this.isBonus(doc) ? this.getTotalGrossRevenueDA1AndUSABonus() : null;
    }

    public Double getTotalWithHoldingTaxClaim() throws ParseException, XPathExpressionException {
        if (this.totalWithHoldingTaxClaim != null && this.totalWithHoldingTaxClaim.isNaN()) {
            Double totalWithHoldingTaxClaimBankAccount = this.getTotalWithHoldingTaxClaimBankAccount();
            Double totalWithHoldingTaxClaimSecurity = this.getTotalWithHoldingTaxClaimSecurity();
            this.totalWithHoldingTaxClaim = totalWithHoldingTaxClaimBankAccount != null || totalWithHoldingTaxClaimSecurity != null ? Double.valueOf(TaxStatementPDFUtil.nvl(totalWithHoldingTaxClaimBankAccount, 0.0) + TaxStatementPDFUtil.nvl(totalWithHoldingTaxClaimSecurity, 0.0)) : null;
        }
        return this.totalWithHoldingTaxClaim;
    }

    public Double getTotalWithHoldingTaxClaim(Document doc) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.add(this.getTotalWithHoldingTaxClaimBankAccount(doc), this.getTotalWithHoldingTaxClaimSecurity(doc));
    }

    protected boolean isBonus(Document doc) throws ParseException, XPathExpressionException {
        String canton = TaxStatementPDFUtil.getValue(doc, "/taxStatement/@canton");
        Boolean bonus = false;
        if (canton != null && bs != null) {
            for (int i = 0; i < bs.length && !bonus.booleanValue(); ++i) {
                bonus = canton.equals(bs[i]);
            }
        }
        return bonus;
    }

    protected boolean isGrossRevenueA(Double grossRevenueA, Double grossRevenueB, Double withHoldingTaxClaim) {
        boolean isA = false;
        if (withHoldingTaxClaim != null && withHoldingTaxClaim > 0.0) {
            isA = true;
        } else if (grossRevenueA != null && grossRevenueA > 0.0) {
            isA = true;
        }
        return isA;
    }

    protected boolean isGrossRevenueB(Double grossRevenueA, Double grossRevenueB, Double withHoldingTaxClaim) {
        boolean isB = false;
        if (grossRevenueB != null && grossRevenueB >= 0.0) {
            isB = true;
        }
        return isB;
    }

    protected boolean isGrossRevenueDA1(Boolean lumpSumTaxCredit, Double nonRecoverableTaxAmount, Double additionalWithHoldingTaxUSA) {
        boolean isDA1 = false;
        if (lumpSumTaxCredit != null && lumpSumTaxCredit.booleanValue()) {
            isDA1 = true;
        } else if (nonRecoverableTaxAmount != null && nonRecoverableTaxAmount > 0.0) {
            isDA1 = true;
        } else if (additionalWithHoldingTaxUSA != null && additionalWithHoldingTaxUSA > 0.0) {
            isDA1 = true;
        }
        return isDA1;
    }

    protected boolean isGrossRevenueUSA(Boolean lumpSumTaxCredit, Double nonRecoverableTaxAmount, Double additionalWithHoldingTaxUSA) {
        boolean isUSA = false;
        if (additionalWithHoldingTaxUSA != null && additionalWithHoldingTaxUSA > 0.0) {
            isUSA = true;
        }
        return isUSA;
    }

    public boolean isLumpSumTaxCredit(Document doc) throws ParseException, XPathExpressionException {
        boolean isLumpSumTaxCredit = false;
        int depots = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots && !isLumpSumTaxCredit; ++depot) {
            isLumpSumTaxCredit = this.isLumpSumTaxCredit(doc, depot);
        }
        return isLumpSumTaxCredit;
    }

    public boolean isLumpSumTaxCredit(Document doc, int depot) throws ParseException, XPathExpressionException {
        int securities = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
        return this.isLumpSumTaxCredit(doc, depot, 1, securities);
    }

    public boolean isLumpSumTaxCredit(Document doc, int depot, int securityFrom, int securityTo) throws ParseException, XPathExpressionException {
        boolean isLumpSumTaxCredit = false;
        for (int security = securityFrom; security <= securityTo && !isLumpSumTaxCredit; ++security) {
            isLumpSumTaxCredit = this.isLumpSumTaxCredit(doc, depot, security);
        }
        return isLumpSumTaxCredit;
    }

    public boolean isLumpSumTaxCredit(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        boolean isLumpSumTaxCredit = false;
        int payments = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
        for (int payment = 1; payment <= payments && !isLumpSumTaxCredit; ++payment) {
            Boolean lumpSumTaxCredit = TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCredit");
            isLumpSumTaxCredit = lumpSumTaxCredit != null && lumpSumTaxCredit != false;
        }
        return isLumpSumTaxCredit && !this.isOther(doc, depot, security) && !this.isCrypto(doc, depot, security);
    }

    public boolean isNotLumpSumTaxCredit(Document doc) throws ParseException, XPathExpressionException {
        boolean isNotLumpSumTaxCredit = false;
        int depots = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots && !isNotLumpSumTaxCredit; ++depot) {
            isNotLumpSumTaxCredit = this.isNotLumpSumTaxCredit(doc, depot);
        }
        return isNotLumpSumTaxCredit;
    }

    public boolean isNotLumpSumTaxCredit(Document doc, Boolean withHolding) throws ParseException, XPathExpressionException {
        boolean isNotLumpSumTaxCredit = false;
        int depots = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots && !isNotLumpSumTaxCredit; ++depot) {
            isNotLumpSumTaxCredit = this.isNotLumpSumTaxCredit(doc, depot, withHolding);
        }
        return isNotLumpSumTaxCredit;
    }

    public boolean isNotLumpSumTaxCredit(Document doc, int depot) throws ParseException, XPathExpressionException {
        int securities = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
        return this.isNotLumpSumTaxCredit(doc, depot, 1, securities);
    }

    public boolean isNotLumpSumTaxCredit(Document doc, int depot, Boolean withHolding) throws ParseException, XPathExpressionException {
        int securities = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
        return this.isNotLumpSumTaxCredit(doc, depot, 1, securities, withHolding);
    }

    public boolean isNotLumpSumTaxCredit(Document doc, int depot, int securityFrom, int securityTo) throws ParseException, XPathExpressionException {
        boolean isNotLumpSumTaxCredit = false;
        for (int security = securityFrom; security <= securityTo && !isNotLumpSumTaxCredit; ++security) {
            isNotLumpSumTaxCredit = this.isNotLumpSumTaxCredit(doc, depot, security);
        }
        return isNotLumpSumTaxCredit;
    }

    public boolean isNotLumpSumTaxCredit(Document doc, int depot, int securityFrom, int securityTo, Boolean withHolding) throws ParseException, XPathExpressionException {
        boolean isNotLumpSumTaxCredit = false;
        for (int security = securityFrom; security <= securityTo && !isNotLumpSumTaxCredit; ++security) {
            isNotLumpSumTaxCredit = this.isNotLumpSumTaxCredit(doc, depot, security, withHolding);
        }
        return isNotLumpSumTaxCredit;
    }

    public boolean isNotLumpSumTaxCredit(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return !this.isLendingFee(doc, depot, security) && !this.isRetrocession(doc, depot, security) && !this.isLumpSumTaxCredit(doc, depot, security) && !this.isOther(doc, depot, security) && !this.isCrypto(doc, depot, security);
    }

    public boolean isNotLumpSumTaxCredit(Document doc, int depot, int security, Boolean withHolding) throws ParseException, XPathExpressionException {
        String country = TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@country");
        boolean isA = false;
        boolean isB = false;
        if (country == null || country.length() == 0) {
            country = "CH";
        }
        for (int payment = 1; payment <= TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)"); ++payment) {
            Double withHoldingTaxClaim;
            Double grossRevenueB;
            Double grossRevenueA = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
            if (this.isGrossRevenueA(grossRevenueA, grossRevenueB = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB"), withHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim"))) {
                isA = true;
            }
            if (!this.isGrossRevenueB(grossRevenueA, grossRevenueB, withHoldingTaxClaim)) continue;
            isB = true;
        }
        return !this.isLendingFee(doc, depot, security) && !this.isRetrocession(doc, depot, security) && !this.isLumpSumTaxCredit(doc, depot, security) && !this.isOther(doc, depot, security) && !this.isCrypto(doc, depot, security) && (withHolding != false && country.equals("CH") && isA || withHolding != false && country.equals("CH") && !isB || withHolding == false && country.equals("CH") && isB || withHolding == false && !country.equals("CH"));
    }

    public boolean isCrypto(Document doc) throws ParseException, XPathExpressionException {
        boolean isCrypto = false;
        int depots = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots && !isCrypto; ++depot) {
            isCrypto = this.isCrypto(doc, depot);
        }
        return isCrypto;
    }

    public boolean isCrypto(Document doc, int depot) throws ParseException, XPathExpressionException {
        int securities = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
        return this.isCrypto(doc, depot, 1, securities);
    }

    public boolean isCrypto(Document doc, int depot, int securityFrom, int securityTo) throws ParseException, XPathExpressionException {
        boolean isCrypto = false;
        for (int security = securityFrom; security <= securityTo && !isCrypto; ++security) {
            isCrypto = this.isCrypto(doc, depot, security);
        }
        return isCrypto;
    }

    public boolean isCrypto(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        String category = TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
        String currency = TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@currency");
        return category != null && category.equals("CURRNOTE") && currency != null && !currency.equals("ADP") && !currency.equals("ADP") && !currency.equals("AED") && !currency.equals("AFA") && !currency.equals("AFN") && !currency.equals("ALK") && !currency.equals("ALL") && !currency.equals("AMD") && !currency.equals("ANG") && !currency.equals("AOA") && !currency.equals("AOK") && !currency.equals("AON") && !currency.equals("AOR") && !currency.equals("ARA") && !currency.equals("ARP") && !currency.equals("ARS") && !currency.equals("ARY") && !currency.equals("ATS") && !currency.equals("AUD") && !currency.equals("AWG") && !currency.equals("AZM") && !currency.equals("AZN") && !currency.equals("BAD") && !currency.equals("BAM") && !currency.equals("BBD") && !currency.equals("BDT") && !currency.equals("BEC") && !currency.equals("BEF") && !currency.equals("BEL") && !currency.equals("BGJ") && !currency.equals("BGK") && !currency.equals("BGL") && !currency.equals("BGN") && !currency.equals("BHD") && !currency.equals("BIF") && !currency.equals("BMD") && !currency.equals("BND") && !currency.equals("BOB") && !currency.equals("BOP") && !currency.equals("BOV") && !currency.equals("BRB") && !currency.equals("BRC") && !currency.equals("BRE") && !currency.equals("BRL") && !currency.equals("BRN") && !currency.equals("BRR") && !currency.equals("BSD") && !currency.equals("BTN") && !currency.equals("BUK") && !currency.equals("BWP") && !currency.equals("BYB") && !currency.equals("BYN") && !currency.equals("BYR") && !currency.equals("BZD") && !currency.equals("CAD") && !currency.equals("CDF") && !currency.equals("CHE") && !currency.equals("CHF") && !currency.equals("CHW") && !currency.equals("CLF") && !currency.equals("CLP") && !currency.equals("CNH") && !currency.equals("CNX") && !currency.equals("CNY") && !currency.equals("COP") && !currency.equals("COU") && !currency.equals("CRC") && !currency.equals("CSD") && !currency.equals("CSJ") && !currency.equals("CSK") && !currency.equals("CUC") && !currency.equals("CUP") && !currency.equals("CVE") && !currency.equals("CYP") && !currency.equals("CZK") && !currency.equals("DDM") && !currency.equals("DEM") && !currency.equals("DJF") && !currency.equals("DKK") && !currency.equals("DOP") && !currency.equals("DZD") && !currency.equals("ECS") && !currency.equals("EEK") && !currency.equals("EGP") && !currency.equals("ERN") && !currency.equals("ESA") && !currency.equals("ESB") && !currency.equals("ESP") && !currency.equals("ETB") && !currency.equals("EUR") && !currency.equals("FIM") && !currency.equals("FJD") && !currency.equals("FKP") && !currency.equals("FRF") && !currency.equals("GBP") && !currency.equals("GEK") && !currency.equals("GEL") && !currency.equals("GHC") && !currency.equals("GHS") && !currency.equals("GIP") && !currency.equals("GMD") && !currency.equals("GNF") && !currency.equals("GNS") && !currency.equals("GQE") && !currency.equals("GRD") && !currency.equals("GTQ") && !currency.equals("GWE") && !currency.equals("GWP") && !currency.equals("GYD") && !currency.equals("HKD") && !currency.equals("HNL") && !currency.equals("HRD") && !currency.equals("HRK") && !currency.equals("HTG") && !currency.equals("HUF") && !currency.equals("IDR") && !currency.equals("IEP") && !currency.equals("ILP") && !currency.equals("ILS") && !currency.equals("INR") && !currency.equals("IQD") && !currency.equals("IRR") && !currency.equals("ISJ") && !currency.equals("ISK") && !currency.equals("ITL") && !currency.equals("JMD") && !currency.equals("JOD") && !currency.equals("JPY") && !currency.equals("KES") && !currency.equals("KGS") && !currency.equals("KHR") && !currency.equals("KMF") && !currency.equals("KPW") && !currency.equals("KRW") && !currency.equals("KWD") && !currency.equals("KYD") && !currency.equals("KZT") && !currency.equals("LAJ") && !currency.equals("LAK") && !currency.equals("LBP") && !currency.equals("LKR") && !currency.equals("LRD") && !currency.equals("LSL") && !currency.equals("LSM") && !currency.equals("LTL") && !currency.equals("LTT") && !currency.equals("LUC") && !currency.equals("LUF") && !currency.equals("LVL") && !currency.equals("LVR") && !currency.equals("LYD") && !currency.equals("MAD") && !currency.equals("MAF") && !currency.equals("MDL") && !currency.equals("MGA") && !currency.equals("MGF") && !currency.equals("MKD") && !currency.equals("MMK") && !currency.equals("MNT") && !currency.equals("MOP") && !currency.equals("MRO") && !currency.equals("MRU") && !currency.equals("MTL") && !currency.equals("MTP") && !currency.equals("MUR") && !currency.equals("MVQ") && !currency.equals("MVR") && !currency.equals("MWK") && !currency.equals("MXN") && !currency.equals("MXP") && !currency.equals("MXV") && !currency.equals("MYR") && !currency.equals("MZE") && !currency.equals("MZM") && !currency.equals("MZN") && !currency.equals("NAD") && !currency.equals("NGN") && !currency.equals("NIC") && !currency.equals("NIO") && !currency.equals("NLG") && !currency.equals("NOK") && !currency.equals("NPR") && !currency.equals("NZD") && !currency.equals("OFL") && !currency.equals("OMR") && !currency.equals("PAB") && !currency.equals("PEI") && !currency.equals("PEN") && !currency.equals("PES") && !currency.equals("PGK") && !currency.equals("PHP") && !currency.equals("PKR") && !currency.equals("PLN") && !currency.equals("PLZ") && !currency.equals("PTE") && !currency.equals("PYG") && !currency.equals("QAR") && !currency.equals("QOF") && !currency.equals("RHD") && !currency.equals("ROK") && !currency.equals("ROL") && !currency.equals("RON") && !currency.equals("RSD") && !currency.equals("RUB") && !currency.equals("RUR") && !currency.equals("RWF") && !currency.equals("SAR") && !currency.equals("SBD") && !currency.equals("SCR") && !currency.equals("SDD") && !currency.equals("SDG") && !currency.equals("SDP") && !currency.equals("SEK") && !currency.equals("SGD") && !currency.equals("SHP") && !currency.equals("SIT") && !currency.equals("SKK") && !currency.equals("SLL") && !currency.equals("SOS") && !currency.equals("SRD") && !currency.equals("SRG") && !currency.equals("SSP") && !currency.equals("STD") && !currency.equals("STN") && !currency.equals("SUR") && !currency.equals("SVC") && !currency.equals("SYP") && !currency.equals("SZL") && !currency.equals("THB") && !currency.equals("THO") && !currency.equals("TJR") && !currency.equals("TJS") && !currency.equals("TMM") && !currency.equals("TMT") && !currency.equals("TND") && !currency.equals("TOP") && !currency.equals("TPE") && !currency.equals("TRL") && !currency.equals("TRY") && !currency.equals("TTD") && !currency.equals("TWD") && !currency.equals("TZS") && !currency.equals("UAH") && !currency.equals("UAK") && !currency.equals("UGS") && !currency.equals("UGW") && !currency.equals("UGX") && !currency.equals("USD") && !currency.equals("USN") && !currency.equals("UYI") && !currency.equals("UYN") && !currency.equals("UYP") && !currency.equals("UYU") && !currency.equals("UYW") && !currency.equals("UZS") && !currency.equals("VEB") && !currency.equals("VEF") && !currency.equals("VES") && !currency.equals("VNC") && !currency.equals("VND") && !currency.equals("VUV") && !currency.equals("WST") && !currency.equals("XAF") && !currency.equals("XAG") && !currency.equals("XAU") && !currency.equals("XBA") && !currency.equals("XCD") && !currency.equals("XDR") && !currency.equals("XEU") && !currency.equals("XOF") && !currency.equals("XPD") && !currency.equals("XPF") && !currency.equals("XPT") && !currency.equals("XUA") && !currency.equals("YDD") && !currency.equals("YER") && !currency.equals("YUD") && !currency.equals("YUM") && !currency.equals("YUN") && !currency.equals("ZAL") && !currency.equals("ZAR") && !currency.equals("ZMK") && !currency.equals("ZMW") && !currency.equals("ZRN") && !currency.equals("ZRZ") && !currency.equals("ZWC") && !currency.equals("ZWD") && !currency.equals("ZWL") && !currency.equals("ZWN") && !currency.equals("ZWR") && !this.isLendingFee(doc, depot, security) && !this.isRetrocession(doc, depot, security);
    }

    public boolean isDA1USA(Document doc) throws ParseException, XPathExpressionException {
        boolean isDA1USA = false;
        int depots = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots && !isDA1USA; ++depot) {
            isDA1USA = this.isDA1USA(doc, depot);
        }
        return isDA1USA;
    }

    public boolean isDA1USA(Document doc, int depot) throws ParseException, XPathExpressionException {
        int securities = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
        return this.isDA1USA(doc, depot, 1, securities);
    }

    public boolean isDA1USA(Document doc, int depot, int securityFrom, int securityTo) throws ParseException, XPathExpressionException {
        boolean isDA1USA = false;
        for (int security = securityFrom; security <= securityTo && !isDA1USA; ++security) {
            isDA1USA = this.isDA1USA(doc, depot, security);
        }
        return isDA1USA;
    }

    public boolean isDA1USA(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        boolean isDA1USA = false;
        int payments = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
        for (int payment = 1; payment <= payments && !isDA1USA; ++payment) {
            Double nonRecoverableTaxAmount = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
            Double additionalWithHoldingTaxUSA = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
            isDA1USA = nonRecoverableTaxAmount != null && nonRecoverableTaxAmount > 0.0 || additionalWithHoldingTaxUSA != null && additionalWithHoldingTaxUSA > 0.0;
        }
        return isDA1USA;
    }

    public boolean isLendingFee(Document doc) throws ParseException, XPathExpressionException {
        boolean isLendingFee = false;
        int depots = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots && !isLendingFee; ++depot) {
            isLendingFee = this.isLendingFee(doc, depot);
        }
        return isLendingFee;
    }

    public boolean isLendingFee(Document doc, int depot) throws ParseException, XPathExpressionException {
        int securities = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
        return this.isLendingFee(doc, depot, 1, securities);
    }

    public boolean isLendingFee(Document doc, int depot, int securityFrom, int securityTo) throws ParseException, XPathExpressionException {
        boolean isLendingFee = false;
        for (int security = securityFrom; security <= securityTo && !isLendingFee; ++security) {
            isLendingFee = this.isLendingFee(doc, depot, security);
        }
        return isLendingFee;
    }

    public boolean isLendingFee(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        boolean isLendingFee = false;
        int payments = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
        for (int payment = 1; payment <= payments && !isLendingFee; ++payment) {
            Boolean lendingFee = TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lendingFee");
            isLendingFee = lendingFee != null && lendingFee != false;
        }
        return isLendingFee;
    }

    public boolean isRetrocession(Document doc) throws ParseException, XPathExpressionException {
        boolean isRetrocession = false;
        int depots = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots && !isRetrocession; ++depot) {
            isRetrocession = this.isRetrocession(doc, depot);
        }
        return isRetrocession;
    }

    public boolean isRetrocession(Document doc, int depot) throws ParseException, XPathExpressionException {
        int securities = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
        return this.isRetrocession(doc, depot, 1, securities);
    }

    public boolean isRetrocession(Document doc, int depot, int securityFrom, int securityTo) throws ParseException, XPathExpressionException {
        boolean isRetrocession = false;
        for (int security = securityFrom; security <= securityTo && !isRetrocession; ++security) {
            isRetrocession = this.isRetrocession(doc, depot, security);
        }
        return isRetrocession;
    }

    public boolean isRetrocession(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        boolean isRetrocession = false;
        int payments = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
        for (int payment = 1; payment <= payments && !isRetrocession; ++payment) {
            Boolean retrocession = TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@retrocession");
            isRetrocession = retrocession != null && retrocession != false;
        }
        return isRetrocession;
    }

    public boolean isOther(Document doc) throws ParseException, XPathExpressionException {
        boolean isOther = false;
        int depots = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot)");
        for (int depot = 1; depot <= depots && !isOther; ++depot) {
            isOther = this.isOther(doc, depot);
        }
        return isOther;
    }

    public boolean isOther(Document doc, int depot) throws ParseException, XPathExpressionException {
        int securities = TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
        return this.isOther(doc, depot, 1, securities);
    }

    public boolean isOther(Document doc, int depot, int securityFrom, int securityTo) throws ParseException, XPathExpressionException {
        boolean isOther = false;
        for (int security = securityFrom; security <= securityTo && !isOther; ++security) {
            isOther = this.isOther(doc, depot, security);
        }
        return isOther;
    }

    public boolean isOther(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        String category = TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
        return category != null && category.equals("COINBULL");
    }

    public TaxStatementPDFFormula(Document doc) throws ParseException, XPathExpressionException {
        this.doc = doc;
        if (this.getTotalExpense() == null) {
            this.totalExpense = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfExpenses/@totalExpenses");
        }
        if (this.getTotalExpenseDeductible() == null) {
            this.totalExpenseDeductible = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfExpenses/@totalExpensesDeductible");
        }
        if (this.getTotalExpenseDeductibleCanton() == null) {
            this.totalExpenseDeductibleCanton = TaxStatementPDFUtil.getValueNumber(this.doc, "/taxStatement/listOfExpenses/@totalExpensesDeductibleCanton");
        }
        if (this.getTotalTaxValueLiability() == null && this.getTotalGrossRevenueBLiability() != null) {
            this.totalTaxValueLiability = 0.0;
        }
        if (this.getTotalTaxValueLiability() != null && this.getTotalGrossRevenueBLiability() == null) {
            this.totalGrossRevenueBLiability = 0.0;
        }
        this.getTotalTaxValue();
        this.getTotalGrossRevenueA();
        this.getTotalGrossRevenueB();
    }
}

