/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf;

import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class TaxStatementPDFSecurityData {
    public static Double getTotalTaxValue(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalTaxValue");
    }

    public static Double getTotalGrossRevenueA(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueA");
    }

    public static Double getTotalGrossRevenueACanton(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueACanton");
    }

    public static Double getTotalGrossRevenueB(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueB");
    }

    public static Double getTotalGrossRevenueBCanton(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueBCanton");
    }

    public static Double getTotalGrossRevenueConversion(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueConversion");
    }

    public static Double getTotalGrossRevenueIUP(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueIUP");
    }

    public static Double getTotalWithHoldingTaxClaim(Document doc) throws XPathExpressionException {
        Double totalGrossRevenueA = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueA");
        Double totalWithHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalWithHoldingTaxClaim");
        return totalWithHoldingTaxClaim != null ? totalWithHoldingTaxClaim : (totalGrossRevenueA != null ? Double.valueOf(totalGrossRevenueA * 0.35) : null);
    }

    public static Double getTotalLumpSumTaxCredit(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalLumpSumTaxCredit");
    }

    public static Double getTotalNonRecoverableTax(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalNonRecoverableTax");
    }

    public static Double getTotalAdditionalWithHoldingTaxUSA(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalAdditionalWithHoldingTaxUSA");
    }

    public static int getDepotCount(Document doc) throws XPathExpressionException {
        return TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot)");
    }

    public static String getDepotDepotNumber(Document doc, int depot) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/@depotNumber");
    }

    public static int getSecurityCount(Document doc) throws XPathExpressionException {
        int count = 0;
        int depots = TaxStatementPDFSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            count += TaxStatementPDFSecurityData.getSecurityCount(doc, i);
        }
        return count;
    }

    public static int getSecurityCount(Document doc, int depot) throws XPathExpressionException {
        return TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
    }

    public static Boolean getSecurityBFP(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@bfp", false);
    }

    public static String getSecurityCategory(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
    }

    public static String getSecurityCity(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@city");
    }

    public static String getSecurityCountry(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@country");
    }

    public static String getSecurityCurrency(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@currency");
    }

    public static Double getSecurityInterestRate(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@interestRate");
    }

    public static String getSecurityISIN(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@isin");
    }

    public static Date getSecurityIssueDate(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@issueDate");
    }

    public static String getSecurityIssueDate(Document doc, int depot, int security, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date issueDate = TaxStatementPDFSecurityData.getSecurityIssueDate(doc, depot, security);
        return issueDate != null ? sdf.format(issueDate) : null;
    }

    public static Double getSecurityIssuePrice(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@issuePrice");
    }

    public static Boolean getSecurityIUP(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@iup", false);
    }

    public static String getSecurityName(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityName");
    }

    public static Double getSecurityNominalValue(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@nominalValue");
    }

    public static String getSecurityPositionId(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@positionId");
    }

    public static String getSecurityQuotationType(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@quotationType");
    }

    public static Date getSecurityRedemptionDate(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@redemptionDate");
    }

    public static String getSecurityRedemptionDate(Document doc, int depot, int security, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date redemptionDate = TaxStatementPDFSecurityData.getSecurityRedemptionDate(doc, depot, security);
        return redemptionDate != null ? sdf.format(redemptionDate) : null;
    }

    public static Date getSecurityRedemptionDateEarly(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@redemptionDateEarly");
    }

    public static String getSecurityRedemptionDateEarly(Document doc, int depot, int security, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date redemptionDateEarly = TaxStatementPDFSecurityData.getSecurityRedemptionDateEarly(doc, depot, security);
        return redemptionDateEarly != null ? sdf.format(redemptionDateEarly) : null;
    }

    public static Double getSecurityRedemptionPrice(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@redemptionPrice");
    }

    public static Double getSecurityRedemptionPriceEarly(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@redemptionPriceEarly");
    }

    public static String getSecurityType(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityType");
    }

    public static String getSecurityUID(Document doc, int depot, int security) throws XPathExpressionException {
        String category = TaxStatementPDFSecurityData.getSecurityUIDOrganisationIdCategory(doc, depot, security);
        String id = TaxStatementPDFSecurityData.getSecurityUIDOrganisationId(doc, depot, security);
        if (category != null && category.length() > 0 && id != null && id.length() > 0) {
            return category + id;
        }
        if (category != null && category.length() > 0) {
            return category;
        }
        if (id != null && id.length() > 0) {
            return id;
        }
        return null;
    }

    public static String getSecurityUIDOrganisationIdCategory(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/uid/uidOrganisationIdCategorie");
    }

    public static String getSecurityUIDOrganisationId(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/uid/uidOrganisationId");
    }

    public static String getSecurityUIDOrganisationId(Document doc, int depot, int security, String format) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/uid/uidOrganisationId", format);
    }

    public static Double getSecurityValorNumber(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@valorNumber");
    }

    public static Boolean getSecurityVariableInterest(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@variableInterest", false);
    }

    public static int getTaxValueCount(Document doc) throws XPathExpressionException {
        int count = 0;
        int depots = TaxStatementPDFSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementPDFSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                count += TaxStatementPDFSecurityData.getTaxValueCount(doc, i, j);
            }
        }
        return count;
    }

    public static int getTaxValueCount(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue)");
    }

    public static Double getTaxValueBalance(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFSecurityData.getTaxValueBalance(doc, depot, security, 1);
    }

    public static Double getTaxValueBalance(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@balance");
    }

    public static String getTaxValueBalanceCurrency(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFSecurityData.getTaxValueBalanceCurrency(doc, depot, security, 1);
    }

    public static String getTaxValueBalanceCurrency(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@balanceCurrency");
    }

    public static Double getTaxValueExchangeRate(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFSecurityData.getTaxValueExchangeRate(doc, depot, security, 1);
    }

    public static Double getTaxValueExchangeRate(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@exchangeRate");
    }

    public static String getTaxValueName(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFSecurityData.getTaxValueName(doc, depot, security, 1);
    }

    public static String getTaxValueName(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@name");
    }

    public static Double getTaxValueQuantity(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFSecurityData.getTaxValueQuantity(doc, depot, security, 1);
    }

    public static Double getTaxValueQuantity(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@quantity");
    }

    public static String getTaxValueQuotationType(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFSecurityData.getTaxValueQuotationType(doc, depot, security, 1);
    }

    public static String getTaxValueQuotationType(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@quotationType");
    }

    public static Date getTaxValueReferenceDate(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementPDFSecurityData.getTaxValueReferenceDate(doc, depot, security, 1);
    }

    public static String getTaxValueReferenceDate(Document doc, int depot, int security, String format) throws ParseException, XPathExpressionException {
        return TaxStatementPDFSecurityData.getTaxValueReferenceDate(doc, depot, security, 1, format);
    }

    public static Date getTaxValueReferenceDate(Document doc, int depot, int security, int taxValue) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@referenceDate");
    }

    public static String getTaxValueReferenceDate(Document doc, int depot, int security, int taxValue, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date referenceDate = TaxStatementPDFSecurityData.getTaxValueReferenceDate(doc, depot, security, taxValue);
        return referenceDate != null ? sdf.format(referenceDate) : null;
    }

    public static Boolean getTaxValueUndefined(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementPDFSecurityData.getTaxValueUndefined(doc, depot, security, 1);
    }

    public static Boolean getTaxValueUndefined(Document doc, int depot, int security, int taxValue) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@undefined", false);
    }

    public static Double getTaxValueUnitPrice(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFSecurityData.getTaxValueUnitPrice(doc, depot, security, 1);
    }

    public static Double getTaxValueUnitPrice(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@unitPrice");
    }

    public static Double getTaxValueValue(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFSecurityData.getTaxValueValue(doc, depot, security, 1);
    }

    public static Double getTaxValueValue(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@value");
    }

    public static int getPaymentCount(Document doc) throws XPathExpressionException {
        int count = 0;
        int depots = TaxStatementPDFSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementPDFSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                count += TaxStatementPDFSecurityData.getPaymentCount(doc, i, j);
            }
        }
        return count;
    }

    public static int getPaymentCount(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
    }

    public static Double getPaymentAdditionalWithHoldingTaxUSA(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
    }

    public static Double getPaymentAmount(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@amount");
    }

    public static String getPaymentAmountCurrency(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@amountCurrency");
    }

    public static Double getPaymentAmountPerUnit(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@amountPerUnit");
    }

    public static Boolean getPaymentConversion(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@conversion", false);
    }

    public static Double getPaymentExchangeRate(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@exchangeRate");
    }

    public static Date getPaymentExDate(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@exDate");
    }

    public static String getPaymentExDate(Document doc, int depot, int security, int payment, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date exDate = TaxStatementPDFSecurityData.getPaymentExDate(doc, depot, security, payment);
        return exDate != null ? sdf.format(exDate) : null;
    }

    public static Double getPaymentGrossRevenueA(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
    }

    public static Double getPaymentGrossRevenueB(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
    }

    public static Boolean getPaymentIUP(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup", false);
    }

    public static Boolean getPaymentLendingFee(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        Boolean lendingFee = false;
        int payments = TaxStatementPDFSecurityData.getPaymentCount(doc, depot, security);
        for (int i = 1; i <= payments && !lendingFee.booleanValue(); ++i) {
            lendingFee = TaxStatementPDFSecurityData.getPaymentLendingFee(doc, depot, security, i);
        }
        return lendingFee;
    }

    public static Boolean getPaymentLendingFee(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lendingFee", false);
    }

    public static Boolean getPaymentLumpSumTaxCredit(Document doc, int depot, int security, Date date) throws ParseException, XPathExpressionException {
        boolean lumpSumTaxCredit = false;
        int payments = TaxStatementPDFSecurityData.getPaymentCount(doc, depot, security);
        for (int i = 1; i <= payments && !lumpSumTaxCredit; ++i) {
            Date exDate = TaxStatementPDFSecurityData.getPaymentExDate(doc, depot, security, i);
            Date paymentDate = TaxStatementPDFSecurityData.getPaymentPaymentDate(doc, depot, security, i);
            if (exDate != null) {
                if (date == null || !date.equals(exDate)) continue;
                lumpSumTaxCredit = TaxStatementPDFSecurityData.getPaymentLumpSumTaxCredit(doc, depot, security, i);
                continue;
            }
            if (paymentDate == null || date == null || !date.equals(paymentDate)) continue;
            lumpSumTaxCredit = TaxStatementPDFSecurityData.getPaymentLumpSumTaxCredit(doc, depot, security, i);
        }
        return lumpSumTaxCredit;
    }

    public static Boolean getPaymentLumpSumTaxCredit(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCredit", false);
    }

    public static Double getPaymentLumpSumTaxCreditAmount(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCreditAmount");
    }

    public static Double getPaymentLumpSumTaxCreditForeign(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        Double amount = TaxStatementPDFSecurityData.getPaymentAmount(doc, depot, security, payment);
        Double lumpSumTaxCreditPercent = TaxStatementPDFSecurityData.getPaymentLumpSumTaxCreditPercent(doc, depot, security, payment);
        Double lumpSumTaxCreditForeign = null;
        if (amount != null && lumpSumTaxCreditPercent != null) {
            lumpSumTaxCreditForeign = amount * lumpSumTaxCreditPercent / 100.0;
        }
        return lumpSumTaxCreditForeign;
    }

    public static Double getPaymentLumpSumTaxCreditPercent(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCreditPercent");
    }

    public static String getPaymentName(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@name");
    }

    public static Double getPaymentNonRecoverableTaxAmount(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
    }

    public static Double getPaymentNonRecoverableTaxForeign(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        Double amount = TaxStatementPDFSecurityData.getPaymentAmount(doc, depot, security, payment);
        Double nonRecoverableTaxPercent = TaxStatementPDFSecurityData.getPaymentNonRecoverableTaxPercent(doc, depot, security, payment);
        Double nonRecoverableTaxForeign = null;
        if (amount != null && nonRecoverableTaxPercent != null) {
            nonRecoverableTaxForeign = amount * nonRecoverableTaxPercent / 100.0;
        }
        return nonRecoverableTaxForeign;
    }

    public static Double getPaymentNonRecoverableTaxPercent(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxPercent");
    }

    public static Date getPaymentPaymentDate(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@paymentDate");
    }

    public static String getPaymentPaymentDate(Document doc, int depot, int security, int payment, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date paymentDate = TaxStatementPDFSecurityData.getPaymentPaymentDate(doc, depot, security, payment);
        return paymentDate != null ? sdf.format(paymentDate) : null;
    }

    public static Double getPaymentQuantity(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@quantity");
    }

    public static String getPaymentQuotationType(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@quotationType");
    }

    public static Double getPaymentReleaseTaxAmount(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        Double grossRevenueB = TaxStatementPDFSecurityData.getPaymentGrossRevenueB(doc, depot, security, payment);
        Double releaseTaxPercent = TaxStatementPDFSecurityData.getPaymentReleaseTaxPercent(doc, depot, security, payment);
        Double releaseTaxAmount = null;
        if (grossRevenueB != null && releaseTaxPercent != null) {
            releaseTaxAmount = grossRevenueB * releaseTaxPercent / 100.0;
        }
        return releaseTaxAmount;
    }

    public static Double getPaymentReleaseTaxForeign(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        Double amount = TaxStatementPDFSecurityData.getPaymentAmount(doc, depot, security, payment);
        Double releaseTaxPercent = TaxStatementPDFSecurityData.getPaymentReleaseTaxPercent(doc, depot, security, payment);
        Double releaseTaxForeign = null;
        if (amount != null && releaseTaxPercent != null) {
            releaseTaxForeign = amount * releaseTaxPercent / 100.0;
        }
        return releaseTaxForeign;
    }

    public static Double getPaymentReleaseTaxPercent(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        Double lumpSumTaxCreditPercent = TaxStatementPDFSecurityData.getPaymentLumpSumTaxCreditPercent(doc, depot, security, payment);
        Double nonRecoverableTaxPercent = TaxStatementPDFSecurityData.getPaymentNonRecoverableTaxPercent(doc, depot, security, payment);
        Double releaseTaxPercent = null;
        if (lumpSumTaxCreditPercent != null && nonRecoverableTaxPercent != null) {
            releaseTaxPercent = lumpSumTaxCreditPercent - nonRecoverableTaxPercent;
        }
        return releaseTaxPercent;
    }

    public static Boolean getPaymentRetrocession(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@retrocession", false);
    }

    public static Boolean getPaymentSecuritiesLending(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@securitiesLending", false);
    }

    public static String getPaymentSign(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@sign");
    }

    public static Boolean getPaymentUndefined(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@undefined", false);
    }

    public static Double getPaymentWithHoldingTaxClaim(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        Double grossRevenueA = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
        Double withHoldingTaxClaim = TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim");
        return withHoldingTaxClaim != null ? withHoldingTaxClaim : (grossRevenueA != null ? Double.valueOf(grossRevenueA * 0.35) : null);
    }

    public static int getStockCount(Document doc) throws ParseException, XPathExpressionException {
        int count = 0;
        int depots = TaxStatementPDFSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementPDFSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                count += TaxStatementPDFSecurityData.getStockCount(doc, i, j);
            }
        }
        return count;
    }

    public static int getStockCount(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock)");
    }

    public static Double getStockBalance(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@balance");
    }

    public static String getStockBalanceCurrency(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@balanceCurrency");
    }

    public static Boolean getStockBlocked(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@blocked", false);
    }

    public static Date getStockBlockingTo(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@blockingTo");
    }

    public static String getStockBlockingTo(Document doc, int depot, int security, int stock, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date blockingTo = TaxStatementPDFSecurityData.getStockBlockingTo(doc, depot, security, stock);
        return blockingTo != null ? sdf.format(blockingTo) : null;
    }

    public static Double getStockExchangeRate(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@exchangeRate");
    }

    public static Boolean getStockMutation(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@mutation");
    }

    public static String getStockName(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@name");
    }

    public static Double getStockQuantity(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@quantity");
    }

    public static String getStockQuotationType(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@quotationType");
    }

    public static Double getStockReductionCost(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@reductionCost");
    }

    public static Date getStockReferenceDate(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@referenceDate");
    }

    public static String getStockReferenceDate(Document doc, int depot, int security, int stock, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date referenceDate = TaxStatementPDFSecurityData.getStockReferenceDate(doc, depot, security, stock);
        return referenceDate != null ? sdf.format(referenceDate) : null;
    }

    public static Double getStockUnitPrice(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@unitPrice");
    }

    public static Double getStockValue(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementPDFUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@value");
    }
}

