/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.dl;

import ch.ewv.taxstatement.pdf.TaxStatementPDFClientData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFProperty;
import ch.ewv.taxstatement.pdf.TaxStatementPDFSchemaData;
import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import java.awt.Color;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.w3c.dom.Document;

public class TaxStatementDLLayout
extends TaxStatementSSKLayout {
    public static final boolean CATEGORY = false;
    public static final boolean CLIENT = true;
    public static final boolean CLIENT_NR_ONLY = true;
    public static final boolean CODE128 = true;
    public static final boolean DEBUG = false;
    public static final boolean EXTENDED = false;
    public static final boolean FOOTER = true;
    public static final boolean HEADER = true;
    public static final boolean LINES = false;
    public static final boolean SSK = false;
    public static final boolean VALIDATE = false;
    public static final int OFFSET_X = 0;
    public static final int OFFSET_Y = 0;
    public static final int PAGE_ADD = 1;
    public static final int PAGE_FROM = 1;
    public static final int ROWS = 33;
    public static final int UNIT_PRICE_DECIMAL = 2;
    public static final int UNIT_PRICE_DECIMAL_MAX = 5;
    public static final String IBAN = "false";
    public static final String TITLE = "true";
    public static final String TITLE_DATE_FORMAT = "yyyy";
    public static final String VNISIN = "strong";

    @Override
    protected int offsetX() {
        return System.getProperty("offsetX") != null ? TaxStatementPDFProperty.OFFSET_X : 0;
    }

    @Override
    protected int offsetY() {
        return System.getProperty("offsetY") != null ? TaxStatementPDFProperty.OFFSET_Y : 0;
    }

    @Override
    protected int rows() {
        return System.getProperty("rows") != null ? TaxStatementPDFProperty.ROWS : 33;
    }

    @Override
    protected boolean category() {
        return System.getProperty("category") != null ? TaxStatementPDFProperty.CATEGORY : false;
    }

    @Override
    protected boolean client() {
        return System.getProperty("client") != null ? TaxStatementPDFProperty.CLIENT : true;
    }

    protected boolean clientNrOnly() {
        return System.getProperty("clientNrOnly") != null ? System.getProperty("clientNrOnly", IBAN).equals(TITLE) : true;
    }

    @Override
    protected boolean code128() {
        return System.getProperty("code128") != null ? TaxStatementPDFProperty.CODE128 : true;
    }

    @Override
    protected boolean debug() {
        return System.getProperty("debug") != null ? TaxStatementPDFProperty.DEBUG : false;
    }

    @Override
    protected boolean extended() {
        return System.getProperty("extended") != null ? TaxStatementPDFProperty.EXTENDED : false;
    }

    @Override
    protected boolean footer() {
        return System.getProperty("footer") != null ? TaxStatementPDFProperty.FOOTER : true;
    }

    @Override
    protected boolean header() {
        return System.getProperty("header") != null ? TaxStatementPDFProperty.HEADER : true;
    }

    @Override
    protected boolean lines() {
        return System.getProperty("lines") != null ? TaxStatementPDFProperty.LINES : false;
    }

    @Override
    protected boolean ssk() {
        return false;
    }

    protected boolean validate() {
        return System.getProperty("validate") != null ? TaxStatementPDFProperty.VALIDATE : false;
    }

    @Override
    protected int pageAdd() {
        return System.getProperty("pageAdd") != null ? TaxStatementPDFProperty.PAGE_ADD : 1;
    }

    @Override
    protected int pageFrom() {
        return System.getProperty("pageFrom") != null ? TaxStatementPDFProperty.PAGE_FROM : 1;
    }

    @Override
    protected int unitPriceDecimal() {
        return System.getProperty("unitPriceDecimal") != null ? TaxStatementPDFProperty.UNIT_PRICE_DECIMAL : 2;
    }

    @Override
    protected int unitPriceDecimalMax() {
        return System.getProperty("unitPriceDecimalMax") != null ? TaxStatementPDFProperty.UNIT_PRICE_DECIMAL_MAX : 5;
    }

    @Override
    protected String iban() {
        return System.getProperty("iban") != null ? TaxStatementPDFProperty.IBAN : IBAN;
    }

    @Override
    protected String title() {
        return System.getProperty("title") != null ? TaxStatementPDFProperty.TITLE : TITLE;
    }

    @Override
    protected String titleDateFormat() {
        return System.getProperty("titleDateFormat") != null ? TaxStatementPDFProperty.TITLE_DATE_FORMAT : TITLE_DATE_FORMAT;
    }

    @Override
    protected String vnisin() {
        return System.getProperty("vnisin") != null ? TaxStatementPDFProperty.VNISIN : VNISIN;
    }

    @Override
    public void addClient(PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page, PDPageContentStream cs) throws IOException, ParseException, XPathExpressionException {
        if (this.header()) {
            int row = 0;
            int clients = TaxStatementPDFClientData.getClientCount(doc);
            if (clients > 2) {
                clients = 2;
            }
            int ya = this.ya();
            int xe = this.xe();
            int col2 = this.col2();
            int col3 = this.col3();
            if (this.client()) {
                if (!this.clientNrOnly()) {
                    TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya, TaxStatementPDFUtil.getText(lang, "CLIENT"));
                    int i = 1;
                    while (i <= clients) {
                        String salutation = TaxStatementPDFClientData.getClientSalutation(doc, i);
                        String firstName = TaxStatementPDFClientData.getClientFirstName(doc, i);
                        String lastName = TaxStatementPDFClientData.getClientLastName(doc, i);
                        String mrMrs = salutation != null ? (salutation.equals("1") ? TaxStatementPDFUtil.getText(lang, "SALUTATION_MRS") : (salutation.equals("2") ? TaxStatementPDFUtil.getText(lang, "SALUTATION_MR") : "")) : "";
                        String name = firstName != null && firstName.length() > 0 ? TaxStatementPDFUtil.concat(firstName, lastName) : TaxStatementPDFUtil.concat(mrMrs, lastName);
                        TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - 10 * row, name);
                        ++i;
                        ++row;
                    }
                }
                String clientNumber = "";
                for (int i = 1; i <= clients; ++i) {
                    String cn = TaxStatementPDFClientData.getClientNumber(doc, i);
                    if (clientNumber != null && clientNumber.length() > 0) {
                        if (clientNumber.contains(cn)) continue;
                        clientNumber = clientNumber + " / " + cn;
                        continue;
                    }
                    clientNumber = cn;
                }
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, "CLIENT_NR"));
                TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - 10 * row, clientNumber);
                ++row;
                ++row;
            } else {
                row = 4;
            }
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - 10 * row, TaxStatementPDFUtil.getText(lang, "PERIOD"));
            TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col3, ya - 10 * row, TaxStatementPDFSchemaData.getPeriodFrom(doc, "dd.MM.yyyy") + " - " + TaxStatementPDFSchemaData.getPeriodTo(doc, "dd.MM.yyyy"));
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - 10 * ++row, TaxStatementPDFUtil.getText(lang, "CREATED_AT"));
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - 10 * row, TaxStatementPDFSchemaData.getCreationDate(doc, "dd.MM.yyyy"));
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - 10 * ++row, TaxStatementPDFUtil.getText(lang, "CANTON"));
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col3, ya - 10 * row, TaxStatementPDFUtil.getText(lang, "CANTON_" + TaxStatementPDFSchemaData.getCanton(doc)));
            ++row;
            if (this.lines() && !this.isHeaderBottomLine()) {
                if (this.client()) {
                    TaxStatementPDFUtil.drawLine(cs, Color.BLACK, col2, ya + 10, xe, ya + 10, 1.0f);
                    TaxStatementPDFUtil.drawLine(cs, Color.BLACK, col2, ya - 60 - 3, xe, ya - 60 - 3, 1.0f);
                } else {
                    TaxStatementPDFUtil.drawLine(cs, Color.BLACK, col2, ya - 30, xe, ya - 30, 1.0f);
                    TaxStatementPDFUtil.drawLine(cs, Color.BLACK, col2, ya - 60 - 3, xe, ya - 60 - 3, 1.0f);
                }
            }
        }
    }
}

