/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.pdf.ssk;

import ch.ewv.taxstatement.pdf.TaxStatementPDFContext;
import ch.ewv.taxstatement.pdf.TaxStatementPDFRenderer;
import ch.ewv.taxstatement.pdf.TaxStatementPDFUtil;
import ch.ewv.taxstatement.pdf.ssk.TaxStatementSSKLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.w3c.dom.Document;

public class TaxStatementSSKContentTable
extends TaxStatementPDFRenderer {
    public static final String HEADER = "HEADER_CONTENT";
    public static final String HEADER_EXTENDED = "HEADER_CONTENT_EXTENDED";
    public static final String SECTION = "CONTENT_TABLE_SECTION";
    public static final String TITLE = "CONTENT_TABLE_TITLE";
    public static final String PAGE = "CONTENT_TABLE_PAGE";
    public static final int COL1 = 71;
    public static final int COL2 = 130;
    public static final int COL3 = 804;

    protected int col1() {
        return 71 + this.offsetX();
    }

    protected int col2() {
        return 130 + this.offsetX();
    }

    protected int col3() {
        return 804 + this.offsetX();
    }

    protected PDPage addPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content) throws IOException, ParseException, XPathExpressionException {
        this.endPage(ct, pdd, font, bold, doc, lang, data);
        PDPage page = new PDPage();
        page.setMediaBox(PDRectangle.A4);
        page.setRotation(90);
        pdd.addPage(page);
        ct.setPage(page).setRow(0);
        if (layout != null) {
            layout.addLayout(pdd, font, bold, logo, size, doc, lang, data, content, page, this.extended() ? HEADER_EXTENDED : HEADER);
            layout.addPageBarCode(pdd, font, bold, doc, page, 197);
        }
        return page;
    }

    protected PDPageContentStream addPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx) throws IOException, ParseException, XPathExpressionException {
        cs.transform(mx);
        cs.transform(mx);
        cs.transform(mx);
        cs.close();
        PDPage page = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content);
        cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
        cs.transform(mx);
        return cs;
    }

    protected void endPage(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data) throws IOException, ParseException, XPathExpressionException {
        if (ct.getPage() != null) {
            this.addHeader(ct, pdd, font, bold, doc, lang, data, ct.getPage());
        }
    }

    protected void addHeader(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, Document doc, Properties lang, Properties data, PDPage page) throws IOException, ParseException, XPathExpressionException {
        PDPageContentStream cs = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
        Matrix mx = new Matrix(0.0f, 1.0f, -1.0f, 0.0f, page.getMediaBox().getWidth(), 0.0f);
        cs.transform(mx);
        int yh = this.yh();
        int xa = this.xa();
        int xe = this.xe();
        int col1 = this.col1();
        int col2 = this.col2();
        int col3 = this.col3();
        int row = yh + 2 - 30;
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col1, row, TaxStatementPDFUtil.getText(lang, SECTION));
        TaxStatementPDFUtil.showText(cs, bold, 8, Color.BLACK, col2, row, TaxStatementPDFUtil.getText(lang, TITLE));
        TaxStatementPDFUtil.showTextRight(cs, bold, 8, Color.BLACK, col3, row, TaxStatementPDFUtil.getText(lang, PAGE));
        cs.transform(mx);
        cs.transform(mx);
        cs.transform(mx);
        cs.close();
    }

    protected PDPageContentStream addSection(TaxStatementPDFContext ct, PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content, PDPageContentStream cs, Matrix mx, String section, Integer index) throws IOException, ParseException, XPathExpressionException {
        int row = ct.getRow();
        if (content != null && section != null && index != null) {
            int ya = this.ya();
            int col1 = this.col1();
            int col2 = this.col2();
            int col3 = this.col3();
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col1, ya - ++row * 10, TaxStatementPDFUtil.roman(index));
            TaxStatementPDFUtil.showText(cs, font, 8, Color.BLACK, col2, ya - row * 10, section);
            TaxStatementPDFUtil.showTextRight(cs, font, 8, Color.BLACK, col3, ya - row * 10, (String)content.get(section));
            ++row;
        }
        ct.setRow(row);
        return cs;
    }

    protected void addContentTable(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content) throws IOException, ParseException, XPathExpressionException {
        if (this.content() != null && this.content().equals("true")) {
            TaxStatementPDFContext ct = new TaxStatementPDFContext();
            PDPage page = this.addPage(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content);
            this.endPage(ct, pdd, font, bold, doc, lang, data);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addContentData(PDDocument pdd, PDFont font, PDFont bold, TaxStatementSSKLayout layout, PDImageXObject logo, Dimension size, Document doc, Properties lang, Properties data, Properties content) throws IOException, ParseException, XPathExpressionException {
        ArrayList<String> sections = new ArrayList<String>();
        PDPage page = null;
        if (this.content() != null && this.content().equals("true") && content != null) {
            String v;
            Object k;
            TreeMap<Integer, Object> tree = new TreeMap<Integer, Object>();
            for (Map.Entry<Object, Object> entry : content.entrySet()) {
                k = (String)entry.getKey();
                v = (String)entry.getValue();
                tree.put(Integer.valueOf(v), k);
            }
            for (Map.Entry<Object, Object> entry : tree.entrySet()) {
                k = (Integer)entry.getKey();
                v = (String)entry.getValue();
                if (v == null || v.length() <= 0 || k == null || (Integer)k <= 0) continue;
                if (v.equals(TaxStatementPDFUtil.getText(lang, HEADER)) || v.equals(TaxStatementPDFUtil.getText(lang, HEADER_EXTENDED))) {
                    page = pdd.getPage((Integer)k - 1);
                    continue;
                }
                if (v.equals(TaxStatementPDFUtil.getText(lang, "HEADER_COVER")) || v.equals(TaxStatementPDFUtil.getText(lang, "HEADER_COVER_EXTENDED")) || v.equals(TaxStatementPDFUtil.getText(lang, "HEADER_LETTER")) || v.equals(TaxStatementPDFUtil.getText(lang, "HEADER_LETTER_EXTENDED"))) continue;
                sections.add(v);
            }
        }
        if (sections != null && !sections.isEmpty()) {
            int index = 0;
            if (page != null) {
                void var15_20;
                TaxStatementPDFContext ct = new TaxStatementPDFContext();
                PDPageContentStream pDPageContentStream = new PDPageContentStream(pdd, page, PDPageContentStream.AppendMode.APPEND, true);
                Matrix mx = new Matrix(0.0f, 1.0f, -1.0f, 0.0f, page.getMediaBox().getWidth(), 0.0f);
                pDPageContentStream.transform(mx);
                for (String section : sections) {
                    PDPageContentStream pDPageContentStream2 = this.addSection(ct, pdd, font, bold, layout, logo, size, doc, lang, data, content, (PDPageContentStream)var15_20, mx, section, ++index);
                }
                var15_20.transform(mx);
                var15_20.transform(mx);
                var15_20.transform(mx);
                var15_20.close();
            }
        }
    }
}

